/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.Stub;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.InvertedIndex;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder.CompositeBinaryFileStubBuilder<ClassFileDecompilers.Decompiler> {
    private static final Logger LOG = Logger.getInstance(ClassFileStubBuilder.class);
    public static final int STUB_VERSION = 23;
    private static final Comparator<Object> CLASS_NAME_COMPARATOR = Comparator.comparing(o -> o.getClass().getName());

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(0);
        }
        return true;
    }

    @NotNull
    public Stream<ClassFileDecompilers.Decompiler> getAllSubBuilders() {
        Stream stream = ClassFileDecompilers.EP_NAME.extensions();
        if (stream == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(1);
        }
        return stream;
    }

    @Nullable
    public ClassFileDecompilers.Decompiler getSubBuilder(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(2);
        }
        return ClassFileStubBuilder.setContentAndCompute(fileContent, () -> ClassFileDecompilers.find((VirtualFile)fileContent.getFile()));
    }

    @NotNull
    public String getSubBuilderVersion(@Nullable ClassFileDecompilers.Decompiler decompiler) {
        if (decompiler == null) {
            return "default";
        }
        int version = decompiler instanceof ClassFileDecompilers.Full ? ((ClassFileDecompilers.Full)decompiler).getStubBuilder().getStubVersion() : 0;
        String string = decompiler.getClass().getName() + ":" + version;
        if (string == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Stub buildStubTree(@NotNull FileContent fileContent, @Nullable ClassFileDecompilers.Decompiler decompiler) {
        if (fileContent == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(4);
        }
        return (Stub)ClassFileStubBuilder.setContentAndCompute(fileContent, () -> {
            VirtualFile file = fileContent.getFile();
            try {
                if (decompiler instanceof ClassFileDecompilers.Full) {
                    return ((ClassFileDecompilers.Full)decompiler).getStubBuilder().buildFileStub(fileContent);
                }
            }
            catch (ClsFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(file.getPath(), (Throwable)e);
                }
                LOG.info(file.getPath() + ": " + e.getMessage());
            }
            try {
                PsiJavaFileStub stub = ClsFileImpl.buildFileStub(file, fileContent.getContent());
                if (stub == null && fileContent.getFileName().indexOf(36) < 0) {
                    LOG.info("No stub built for the file " + fileContent);
                }
                return stub;
            }
            catch (ClsFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(file.getPath(), (Throwable)e);
                } else {
                    LOG.info(file.getPath() + ": " + e.getMessage());
                }
                return null;
            }
        });
    }

    public int getStubVersion() {
        int version = 23;
        if (!InvertedIndex.ARE_COMPOSITE_INDEXERS_ENABLED) {
            ArrayList decompilers = ContainerUtil.newArrayList((Object[])ClassFileDecompilers.EP_NAME.getExtensions());
            decompilers.sort(CLASS_NAME_COMPARATOR);
            for (ClassFileDecompilers.Decompiler decompiler : decompilers) {
                if (!(decompiler instanceof ClassFileDecompilers.Full)) continue;
                version = version * 31 + ((ClassFileDecompilers.Full)decompiler).getStubBuilder().getStubVersion() + decompiler.getClass().getName().hashCode();
            }
        }
        return version;
    }

    private static <T> T setContentAndCompute(@NotNull FileContent content, @NotNull Supplier<T> computation) {
        if (content == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(5);
        }
        if (computation == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(6);
        }
        try {
            content.getFile().setPreloadedContentHint(content.getContent());
            T t = computation.get();
            return t;
        }
        finally {
            content.getFile().setPreloadedContentHint(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClassFileStubBuilder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClassFileStubBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubBuilders";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBuilderVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSubBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setContentAndCompute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

