/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.SourceRootPresentation;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.ui.IconManager;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JavaDirectoryIconProvider
extends IconProvider
implements DumbAware {
    JavaDirectoryIconProvider() {
    }

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            JavaDirectoryIconProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiDirectory) {
            SourceFolder sourceFolder;
            Module module;
            PsiDirectory psiDirectory = (PsiDirectory)element;
            VirtualFile vFile = psiDirectory.getVirtualFile();
            Project project = psiDirectory.getProject();
            Icon symbolIcon = vFile.getParent() == null && vFile.getFileSystem() instanceof ArchiveFileSystem ? PlatformIcons.JAR_ICON : (ProjectRootsUtil.isModuleContentRoot((VirtualFile)vFile, (Project)project) ? ((module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(vFile)) == null || module.isDisposed() ? PlatformIcons.CONTENT_ROOT_ICON_CLOSED : ModuleType.get((Module)module).getIcon()) : (ProjectRootsUtil.findUnloadedModuleByContentRoot((VirtualFile)vFile, (Project)project) != null ? AllIcons.Modules.UnloadedModule : ((sourceFolder = ProjectRootsUtil.getModuleSourceRoot((VirtualFile)vFile, (Project)project)) != null ? SourceRootPresentation.getSourceRootIcon((SourceFolder)sourceFolder) : (JrtFileSystem.isModuleRoot((VirtualFile)vFile) ? AllIcons.Nodes.Module : (JavaDirectoryIconProvider.isValidPackage(psiDirectory) ? PlatformIcons.PACKAGE_ICON : (!Registry.is((String)"ide.hide.excluded.files") && ProjectRootManager.getInstance((Project)project).getFileIndex().isExcluded(vFile) ? AllIcons.Modules.ExcludeRoot : PlatformIcons.FOLDER_ICON))))));
            return IconManager.getInstance().createLayeredIcon((Iconable)element, symbolIcon, 0);
        }
        return null;
    }

    private static boolean isValidPackage(@NotNull PsiDirectory directory) {
        Project project;
        if (directory == null) {
            JavaDirectoryIconProvider.$$$reportNull$$$0(1);
        }
        PsiDirectoryFactory factory = (project = directory.getProject()).isDisposed() ? null : PsiDirectoryFactory.getInstance((Project)project);
        return factory != null && factory.isPackage(directory) && factory.isValidPackageName(factory.getQualifiedName(directory, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/JavaDirectoryIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidPackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

