/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.ui.components.JBList;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ClassesOrderRootTypeUIFactory
implements OrderRootTypeUIFactory {
    public SdkPathEditor createPathEditor(Sdk sdk) {
        return new MySdkPathEditor(new FileChooserDescriptor(true, true, true, false, true, true));
    }

    public Icon getIcon() {
        return AllIcons.Nodes.CompiledClassesFolder;
    }

    public String getNodeText() {
        return JavaUiBundle.message("library.classes.node", new Object[0]);
    }

    private static boolean isJrtRoot(VirtualFile file) {
        return file != null && JrtFileSystem.isModuleRoot((VirtualFile)file);
    }

    private static class MySdkPathEditor
    extends SdkPathEditor {
        MySdkPathEditor(FileChooserDescriptor descriptor) {
            super(JavaUiBundle.message("sdk.configure.classpath.tab", new Object[0]), OrderRootType.CLASSES, descriptor);
        }

        protected boolean isRemoveActionEnabled(VirtualFile[] files) {
            if (!super.isRemoveActionEnabled(files)) {
                return false;
            }
            for (VirtualFile file : files) {
                if (!ClassesOrderRootTypeUIFactory.isJrtRoot(file)) continue;
                return false;
            }
            return true;
        }

        protected ListCellRenderer<VirtualFile> createListCellRenderer(JBList<VirtualFile> list) {
            return new PathEditor.PathCellRenderer(){

                protected void customizeCellRenderer(@NotNull JList<? extends VirtualFile> list, VirtualFile file, int index, boolean selected, boolean focused) {
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.customizeCellRenderer(list, file, index, selected, focused);
                    if (ClassesOrderRootTypeUIFactory.isJrtRoot(file)) {
                        this.setIcon(AllIcons.Nodes.Module);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/roots/ui/configuration/libraryEditor/ClassesOrderRootTypeUIFactory$MySdkPathEditor$1", "customizeCellRenderer"));
                }
            };
        }
    }
}

