/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.ErrorPaneConfigurable;
import com.intellij.openapi.roots.ui.configuration.SidePanelCountLabel;
import com.intellij.openapi.roots.ui.configuration.SidePanelSeparator;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.util.Key;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.Gray;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SidePanel
extends JPanel {
    private final JList<SidePanelItem> myList;
    private final DefaultListModel<SidePanelItem> myModel;
    private final Place.Navigator myNavigator;
    private final Map<Integer, String> myIndex2Separator = new HashMap<Integer, String>();

    public SidePanel(Place.Navigator navigator) {
        this.myNavigator = navigator;
        this.setLayout(new BorderLayout());
        this.myModel = new DefaultListModel();
        this.myList = new JBList(this.myModel);
        this.myList.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myList.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        ListItemDescriptor<SidePanelItem> descriptor = new ListItemDescriptor<SidePanelItem>(){

            public String getTextFor(SidePanelItem value2) {
                return value2.myText;
            }

            public String getTooltipFor(SidePanelItem value2) {
                return null;
            }

            public Icon getIconFor(SidePanelItem value2) {
                return JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)16, (int)20));
            }

            public boolean hasSeparatorAboveOf(SidePanelItem value2) {
                return SidePanel.this.getSeparatorAbove(value2) != null;
            }

            public String getCaptionAboveOf(SidePanelItem value2) {
                return SidePanel.this.getSeparatorAbove(value2);
            }
        };
        this.myList.setCellRenderer((ListCellRenderer<SidePanelItem>)new GroupedItemsListRenderer<SidePanelItem>((ListItemDescriptor)descriptor, (ListItemDescriptor)descriptor){
            JPanel myExtraPanel;
            SidePanelCountLabel myCountLabel;
            final CellRendererPane myValidationParent;
            final /* synthetic */ ListItemDescriptor val$descriptor;
            {
                this.val$descriptor = listItemDescriptor;
                super(x0);
                this.myValidationParent = new CellRendererPane();
                this.mySeparatorComponent.setCaptionCentered(false);
                SidePanel.this.myList.add(this.myValidationParent);
            }

            protected SeparatorWithText createSeparator() {
                return new SidePanelSeparator();
            }

            protected void layout() {
                this.myRendererComponent.add((Component)this.mySeparatorComponent, (Object)"North");
                this.myExtraPanel.add((Component)this.myComponent, "Center");
                this.myExtraPanel.add((Component)this.myCountLabel, "East");
                this.myRendererComponent.add((Component)this.myExtraPanel, (Object)"Center");
            }

            public Component getListCellRendererComponent(JList<? extends SidePanelItem> list, SidePanelItem value2, int index, boolean isSelected, boolean cellHasFocus) {
                int errorsCount;
                ErrorPaneConfigurable errorPane;
                this.layout();
                this.myCountLabel.setText("");
                Component component = super.getListCellRendererComponent(list, (Object)value2, index, isSelected, cellHasFocus);
                if ("Problems".equals(this.val$descriptor.getTextFor((Object)value2)) && (errorPane = (ErrorPaneConfigurable)value2.myPlace.getPath("category")) != null && (errorsCount = errorPane.getErrorsCount()) > 0) {
                    this.myCountLabel.setSelected(isSelected);
                    this.myCountLabel.setText(errorsCount > 100 ? "100+" : String.valueOf(errorsCount));
                }
                if (UIUtil.isClientPropertyTrue(list, (Object)ExpandableItemsHandler.EXPANDED_RENDERER)) {
                    Rectangle bounds = list.getCellBounds(index, index);
                    bounds.setSize((int)component.getPreferredSize().getWidth(), (int)bounds.getHeight());
                    AbstractExpandableItemsHandler.setRelativeBounds((Component)component, (Rectangle)bounds, (Component)this.myExtraPanel, (Container)this.myValidationParent);
                    this.myExtraPanel.setSize((int)this.myExtraPanel.getPreferredSize().getWidth(), this.myExtraPanel.getHeight());
                    ComponentUtil.putClientProperty((JComponent)this.myExtraPanel, (Key)ExpandableItemsHandler.USE_RENDERER_BOUNDS, (Object)true);
                    return this.myExtraPanel;
                }
                return component;
            }

            protected JComponent createItemComponent() {
                this.myExtraPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                this.myCountLabel = new SidePanelCountLabel();
                JComponent component = super.createItemComponent();
                this.myTextLabel.setForeground((Color)Gray._240);
                this.myTextLabel.setOpaque(true);
                return component;
            }

            protected Color getBackground() {
                return UIUtil.SIDE_PANEL_BACKGROUND;
            }
        });
        this.add((Component)ScrollPaneFactory.createScrollPane(this.myList, (boolean)true), "Center");
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SidePanelItem value2 = (SidePanelItem)SidePanel.this.myList.getSelectedValue();
                if (value2 != null) {
                    SidePanel.this.myNavigator.navigateTo(value2.myPlace, false);
                }
            }
        });
    }

    public JList getList() {
        return this.myList;
    }

    public void addPlace(Place place, @NotNull Presentation presentation) {
        if (presentation == null) {
            SidePanel.$$$reportNull$$$0(0);
        }
        this.myModel.addElement(new SidePanelItem(place, presentation.getText()));
        this.revalidate();
        this.repaint();
    }

    public void addSeparator(@Nls String text2) {
        this.myIndex2Separator.put(this.myModel.size(), text2);
    }

    @Nullable
    private String getSeparatorAbove(SidePanelItem item) {
        return this.myIndex2Separator.get(this.myModel.indexOf(item));
    }

    public void select(Place place) {
        for (int i = 0; i < this.myModel.getSize(); ++i) {
            SidePanelItem item = this.myModel.getElementAt(i);
            if (!place.equals((Object)item.myPlace)) continue;
            this.myList.setSelectedValue(item, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/roots/ui/configuration/SidePanel", "addPlace"));
    }

    private static class SidePanelItem {
        private final Place myPlace;
        private final String myText;

        SidePanelItem(Place place, String text2) {
            this.myPlace = place;
            this.myText = text2;
        }

        public String toString() {
            return this.myText;
        }
    }
}

