/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.JavaContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SwingWorker;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JavaContentEntriesEditor
extends CommonContentEntriesEditor {
    public JavaContentEntriesEditor(String moduleName, ModuleConfigurationState state) {
        super(moduleName, state, new JpsModuleSourceRootType[]{JavaSourceRootType.SOURCE, JavaSourceRootType.TEST_SOURCE, JavaResourceRootType.RESOURCE, JavaResourceRootType.TEST_RESOURCE});
    }

    protected ContentEntryEditor createContentEntryEditor(String contentEntryUrl) {
        return new JavaContentEntryEditor(contentEntryUrl, this.getEditHandlers()){

            protected ModifiableRootModel getModel() {
                return JavaContentEntriesEditor.this.getModifiableModel();
            }
        };
    }

    private ModifiableRootModel getModifiableModel() {
        return this.getModel();
    }

    protected List<ContentEntry> addContentEntries(VirtualFile[] files) {
        List contentEntries = super.addContentEntries(files);
        if (!contentEntries.isEmpty()) {
            ContentEntry[] contentEntriesArray = contentEntries.toArray(new ContentEntry[0]);
            JavaContentEntriesEditor.addSourceRoots(this.myProject, contentEntriesArray, () -> this.addContentEntryPanels(contentEntriesArray));
        }
        return contentEntries;
    }

    private static void addSourceRoots(@NotNull Project project, ContentEntry[] contentEntries, Runnable finishRunnable) {
        if (project == null) {
            JavaContentEntriesEditor.$$$reportNull$$$0(0);
        }
        HashMap<ContentEntry, Object> entryToRootMap = new HashMap<ContentEntry, Object>();
        HashMap<File, ContentEntry> fileToEntryMap = new HashMap<File, ContentEntry>();
        for (ContentEntry contentEntry : contentEntries) {
            VirtualFile file = contentEntry.getFile();
            if (file == null) continue;
            entryToRootMap.put(contentEntry, null);
            fileToEntryMap.put(VfsUtilCore.virtualToIoFile((VirtualFile)file), contentEntry);
        }
        ProgressWindow progressWindow = new ProgressWindow(true, project);
        SmoothProgressAdapter progressIndicator = new SmoothProgressAdapter((ProgressIndicator)progressWindow, project);
        final Runnable searchRunnable = () -> JavaContentEntriesEditor.lambda$addSourceRoots$2(fileToEntryMap, (ProgressIndicator)progressIndicator, entryToRootMap, progressWindow);
        final Runnable addSourcesRunnable = () -> {
            for (ContentEntry contentEntry : contentEntries) {
                Collection suggestedRoots = (Collection)entryToRootMap.get(contentEntry);
                if (suggestedRoots == null) continue;
                for (JavaModuleSourceRoot suggestedRoot : suggestedRoots) {
                    VirtualFile sourceRoot = LocalFileSystem.getInstance().findFileByIoFile(suggestedRoot.getDirectory());
                    VirtualFile fileContent = contentEntry.getFile();
                    if (sourceRoot == null || fileContent == null || !VfsUtilCore.isAncestor((VirtualFile)fileContent, (VirtualFile)sourceRoot, (boolean)false)) continue;
                    contentEntry.addSourceFolder(sourceRoot, false, suggestedRoot.getPackagePrefix());
                }
            }
            if (finishRunnable != null) {
                finishRunnable.run();
            }
        };
        new SwingWorker(){

            public Object construct() {
                searchRunnable.run();
                return null;
            }

            public void finished() {
                addSourcesRunnable.run();
            }
        }.start();
    }

    private static /* synthetic */ void lambda$addSourceRoots$2(Map fileToEntryMap, ProgressIndicator progressIndicator, HashMap entryToRootMap, ProgressWindow progressWindow) {
        Runnable process2 = () -> {
            for (File file : fileToEntryMap.keySet()) {
                progressIndicator.setText(JavaUiBundle.message("module.paths.searching.source.roots.progress", file.getPath()));
                Collection<JavaModuleSourceRoot> roots = JavaSourceRootDetectionUtil.suggestRoots(file);
                entryToRootMap.put(fileToEntryMap.get(file), roots);
            }
        };
        progressWindow.setTitle(JavaUiBundle.message("module.paths.searching.source.roots.title", new Object[0]));
        ProgressManager.getInstance().runProcess(process2, progressIndicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/JavaContentEntriesEditor", "addSourceRoots"));
    }
}

