/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class CallHierarchyNodeDescriptor
extends HierarchyNodeDescriptor
implements Navigatable {
    private int myUsageCount;
    private final List<PsiReference> myReferences;
    private final boolean myNavigateToReference;

    public CallHierarchyNodeDescriptor(@NotNull Project project, HierarchyNodeDescriptor parentDescriptor, @NotNull PsiElement element, boolean isBase, boolean navigateToReference) {
        if (project == null) {
            CallHierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (element == null) {
            CallHierarchyNodeDescriptor.$$$reportNull$$$0(1);
        }
        super(project, (NodeDescriptor)parentDescriptor, element, isBase);
        this.myUsageCount = 1;
        this.myReferences = new ArrayList<PsiReference>();
        this.myNavigateToReference = navigateToReference;
    }

    public final PsiMember getEnclosingElement() {
        PsiElement element = this.getPsiElement();
        return element == null ? null : CallHierarchyNodeDescriptor.getEnclosingElement(element);
    }

    public static PsiMember getEnclosingElement(PsiElement element) {
        return (PsiMember)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiField.class, PsiMethod.class, PsiClass.class});
    }

    public final void incrementUsageCount() {
        ++this.myUsageCount;
    }

    public final PsiElement getTargetElement() {
        return this.getPsiElement();
    }

    public final boolean isValid() {
        return this.getEnclosingElement() != null;
    }

    public final boolean update() {
        PsiClass containingClass;
        PsiFile file;
        CompositeAppearance oldText = this.myHighlightedText;
        Icon oldIcon = this.getIcon();
        boolean changes = super.update();
        PsiMember enclosingElement = this.getEnclosingElement();
        if (enclosingElement == null) {
            return this.invalidElement();
        }
        this.installIcon((PsiElement)enclosingElement, changes);
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes mainTextAttributes = null;
        if (this.myColor != null) {
            mainTextAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        if (enclosingElement instanceof PsiMethod || enclosingElement instanceof PsiField) {
            if (enclosingElement instanceof SyntheticElement) {
                file = enclosingElement.getContainingFile();
                this.myHighlightedText.getEnding().addText(file != null ? file.getName() : JavaBundle.message((String)"node.call.hierarchy.unknown.jsp", (Object[])new Object[0]), mainTextAttributes);
            } else {
                StringBuilder buffer = new StringBuilder(128);
                PsiClass containingClass2 = enclosingElement.getContainingClass();
                if (containingClass2 != null) {
                    buffer.append(ClassPresentationUtil.getNameForClass(containingClass2, false));
                    buffer.append('.');
                }
                String methodText = enclosingElement instanceof PsiMethod ? PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)enclosingElement), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2) : enclosingElement.getName();
                buffer.append(methodText);
                this.myHighlightedText.getEnding().addText(buffer.toString(), mainTextAttributes);
            }
        } else if (FileTypeUtils.isInServerPageFile((PsiElement)enclosingElement) && enclosingElement instanceof PsiFile) {
            file = PsiUtilCore.getTemplateLanguageFile((PsiElement)enclosingElement);
            this.myHighlightedText.getEnding().addText(file.getName(), mainTextAttributes);
        } else {
            this.myHighlightedText.getEnding().addText(ClassPresentationUtil.getNameForClass((PsiClass)enclosingElement, false), mainTextAttributes);
        }
        if (this.myUsageCount > 1) {
            this.myHighlightedText.getEnding().addText(IdeBundle.message((String)"node.call.hierarchy.N.usages", (Object[])new Object[]{this.myUsageCount}), HierarchyNodeDescriptor.getUsageCountPrefixAttributes());
        }
        if (!(FileTypeUtils.isInServerPageFile((PsiElement)enclosingElement) && enclosingElement instanceof PsiFile || (containingClass = enclosingElement.getContainingClass()) == null)) {
            String packageName = JavaHierarchyUtil.getPackageName(containingClass);
            this.myHighlightedText.getEnding().addText("  (" + packageName + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText) || !Comparing.equal((Object)this.getIcon(), (Object)oldIcon)) {
            changes = true;
        }
        return changes;
    }

    public void addReference(PsiReference reference) {
        this.myReferences.add(reference);
    }

    public boolean hasReference(PsiReference reference) {
        return this.myReferences.contains(reference);
    }

    public void navigate(boolean requestFocus) {
        if (!this.myNavigateToReference) {
            PsiElement element = this.getPsiElement();
            if (element instanceof Navigatable && ((Navigatable)element).canNavigate()) {
                ((Navigatable)element).navigate(requestFocus);
            }
            return;
        }
        PsiReference firstReference = this.myReferences.get(0);
        PsiElement element = firstReference.getElement();
        PsiElement callElement = element.getParent();
        if (callElement instanceof Navigatable && ((Navigatable)callElement).canNavigate()) {
            ((Navigatable)callElement).navigate(requestFocus);
        } else {
            PsiFile psiFile = callElement.getContainingFile();
            if (psiFile == null || psiFile.getVirtualFile() == null) {
                return;
            }
            FileEditorManager.getInstance((Project)this.myProject).openFile(psiFile.getVirtualFile(), requestFocus);
        }
        Editor editor = PsiEditorUtil.findEditor((PsiElement)callElement);
        if (editor != null) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
            EditorColorsManager colorManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            ArrayList highlighters = new ArrayList();
            for (PsiReference psiReference : this.myReferences) {
                PsiElement eachElement = psiReference.getElement();
                PsiElement eachMethodCall = eachElement.getParent();
                if (eachMethodCall == null) continue;
                TextRange textRange = eachMethodCall.getTextRange();
                highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, false, highlighters);
            }
        }
    }

    public boolean canNavigate() {
        PsiFile psiFile;
        if (!this.myNavigateToReference) {
            PsiElement element = this.getPsiElement();
            return element instanceof Navigatable && ((Navigatable)element).canNavigate();
        }
        if (this.myReferences.isEmpty()) {
            return false;
        }
        PsiReference firstReference = this.myReferences.get(0);
        PsiElement callElement = firstReference.getElement().getParent();
        if (callElement == null || !callElement.isValid()) {
            return false;
        }
        return callElement instanceof Navigatable && ((Navigatable)callElement).canNavigate() || (psiFile = callElement.getContainingFile()) != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/hierarchy/call/CallHierarchyNodeDescriptor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

