/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.google.common.collect.ArrayListMultimap;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.SetupJavaProjectFromSourcesActivity;
import com.intellij.ide.SetupJavaProjectFromSourcesActivityKt;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.ide.util.importProject.DetectedRootData;
import com.intellij.ide.util.importProject.JavaModuleInsight;
import com.intellij.ide.util.importProject.LibrariesDetectionStep;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.importProject.RootDetectionProcessor;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.SdkLookup;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\b\u001a\u00020\u0007H\u0002J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u0012H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\fH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/SetupJavaProjectFromSourcesActivity;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "filesToLinks", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectDirectory", "findAndSetupJdk", "", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "notifyAboutAutomaticProjectStructure", "runActivity", "searchImporters", "Lcom/google/common/collect/ArrayListMultimap;", "Lcom/intellij/projectImport/ProjectOpenProcessor;", "setupFromSources", "projectDir", "showNotificationToImport", "providersAndFiles", "hasBeenOpenedBySpecificProcessor", "", "intellij.java.ui"})
public final class SetupJavaProjectFromSourcesActivity
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (this.hasBeenOpenedBySpecificProcessor(project)) {
            return;
        }
        String string = JavaUiBundle.message("task.searching.for.project.sources", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JavaUiBundle.message(\"ta\u2026ing.for.project.sources\")");
        String title = string;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, project, title, project, title, true){
            final /* synthetic */ SetupJavaProjectFromSourcesActivity this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;

            public void run(@NotNull ProgressIndicator indicator) {
                VirtualFile projectDir;
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                VirtualFile virtualFile = projectDir = this.$project.getBaseDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"projectDir");
                ArrayListMultimap importers = SetupJavaProjectFromSourcesActivity.access$searchImporters(this.this$0, virtualFile);
                if (!importers.isEmpty()) {
                    SetupJavaProjectFromSourcesActivity.access$showNotificationToImport(this.this$0, this.$project, projectDir, importers);
                } else {
                    SetupJavaProjectFromSourcesActivity.access$setupFromSources(this.this$0, this.$project, projectDir, indicator);
                }
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    private final boolean hasBeenOpenedBySpecificProcessor(@NotNull Project $this$hasBeenOpenedBySpecificProcessor) {
        return Intrinsics.areEqual((Object)true, (Object)((Boolean)$this$hasBeenOpenedBySpecificProcessor.getUserData(PlatformProjectOpenProcessor.PROJECT_OPENED_BY_PLATFORM_PROCESSOR))) ^ true;
    }

    private final ArrayListMultimap<ProjectOpenProcessor, VirtualFile> searchImporters(VirtualFile projectDirectory) {
        ArrayListMultimap providersAndFiles = ArrayListMultimap.create();
        VfsUtil.visitChildrenRecursively((VirtualFile)projectDirectory, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Void>(providersAndFiles, new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS, VirtualFileVisitor.limit((int)5)}){
            final /* synthetic */ ArrayListMultimap $providersAndFiles;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                if (file.isDirectory() && FileTypeRegistry.getInstance().isFileIgnored(file)) {
                    VirtualFileVisitor.Result result = VirtualFileVisitor.SKIP_CHILDREN;
                    Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"SKIP_CHILDREN");
                    return result;
                }
                ExtensionPointName extensionPointName = ProjectOpenProcessor.EXTENSION_POINT_NAME;
                Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"ProjectOpenProcessor.EXTENSION_POINT_NAME");
                List list = extensionPointName.getExtensionList();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ProjectOpenProcessor.EXT\u2026_POINT_NAME.extensionList");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ProjectOpenProcessor provider = (ProjectOpenProcessor)element$iv$iv;
                    boolean bl = false;
                    if (!(provider.canOpenProject(file) && !(provider instanceof PlatformProjectOpenProcessor))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List providers2 = (List)destination$iv$iv;
                for (ProjectOpenProcessor provider : providers2) {
                    List files = this.$providersAndFiles.get((Object)provider);
                    if (files.isEmpty()) {
                        files.add(file);
                        continue;
                    }
                    List list2 = files;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"files");
                    if (VfsUtilCore.isAncestor((VirtualFile)((VirtualFile)CollectionsKt.last((List)list2)), (VirtualFile)file, (boolean)true)) continue;
                    files.add(file);
                }
                VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
                Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"CONTINUE");
                return result;
            }
            {
                this.$providersAndFiles = $captured_local_variable$0;
                super($super_call_param$1);
            }
        }));
        ArrayListMultimap arrayListMultimap = providersAndFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayListMultimap, (String)"providersAndFiles");
        return arrayListMultimap;
    }

    private final void showNotificationToImport(Project project, VirtualFile projectDirectory, ArrayListMultimap<ProjectOpenProcessor, VirtualFile> providersAndFiles) {
        boolean bl;
        Notification notification;
        block6: {
            NotificationListener.Adapter showFileInProjectViewListener2 = new NotificationListener.Adapter(project){
                final /* synthetic */ Project $project;

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(e.getDescription());
                    ProjectViewSelectInTarget.select((Project)this.$project, (Object)file, (String)"ProjectPane", null, (VirtualFile)file, (boolean)true);
                }
                {
                    this.$project = $captured_local_variable$0;
                }
            };
            String title = null;
            String content = null;
            if (providersAndFiles.keySet().size() == 1) {
                Set set = providersAndFiles.keySet();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"providersAndFiles.keySet()");
                ProjectOpenProcessor processor = (ProjectOpenProcessor)CollectionsKt.single((Iterable)set);
                List files = providersAndFiles.get((Object)processor);
                Object[] objectArray = new Object[2];
                ProjectOpenProcessor projectOpenProcessor = processor;
                Intrinsics.checkExpressionValueIsNotNull((Object)projectOpenProcessor, (String)"processor");
                objectArray[0] = projectOpenProcessor.getName();
                objectArray[1] = files.size();
                String string = JavaUiBundle.message("build.script.found.notification", objectArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JavaUiBundle.message(\"bu\u2026ocessor.name, files.size)");
                title = string;
                List list = files;
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"files");
                content = this.filesToLinks(list, projectDirectory);
            } else {
                String string = JavaUiBundle.message("build.scripts.from.multiple.providers.found.notification", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JavaUiBundle.message(\"bu\u2026ders.found.notification\")");
                title = string;
                content = CollectionsKt.joinToString$default((Iterable)providersAndFiles.asMap().entrySet(), (CharSequence)"<br/>", null, null, (int)0, null, (Function1)((Function1)new Function1<Map.Entry<ProjectOpenProcessor, Collection<VirtualFile>>, String>(this, projectDirectory){
                    final /* synthetic */ SetupJavaProjectFromSourcesActivity this$0;
                    final /* synthetic */ VirtualFile $projectDirectory;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final String invoke(@NotNull Map.Entry<ProjectOpenProcessor, Collection<VirtualFile>> $dstr$provider$files) {
                        void provider;
                        Intrinsics.checkParameterIsNotNull($dstr$provider$files, (String)"<name for destructuring parameter 0>");
                        Map.Entry<ProjectOpenProcessor, Collection<VirtualFile>> entry = $dstr$provider$files;
                        boolean bl = false;
                        ProjectOpenProcessor projectOpenProcessor = entry.getKey();
                        entry = $dstr$provider$files;
                        bl = false;
                        Collection<VirtualFile> files = entry.getValue();
                        StringBuilder stringBuilder = new StringBuilder();
                        void v1 = provider;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"provider");
                        StringBuilder stringBuilder2 = stringBuilder.append(v1.getName()).append(": ");
                        Collection<VirtualFile> collection = files;
                        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"files");
                        return stringBuilder2.append(SetupJavaProjectFromSourcesActivity.access$filesToLinks(this.this$0, collection, this.$projectDirectory)).toString();
                    }
                    {
                        this.this$0 = setupJavaProjectFromSourcesActivity;
                        this.$projectDirectory = virtualFile;
                        super(1);
                    }
                }), (int)30, null);
            }
            notification = SetupJavaProjectFromSourcesActivityKt.access$getNOTIFICATION_GROUP$p().createNotification(title, content, NotificationType.INFORMATION, (NotificationListener)showFileInProjectViewListener2);
            Set set = providersAndFiles.keySet();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"providersAndFiles.keySet()");
            Iterable $this$all$iv = set;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ProjectOpenProcessor it = (ProjectOpenProcessor)element$iv;
                    boolean bl2 = false;
                    if (it.canImportProjectAfterwards()) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            String string = providersAndFiles.keySet().size() > 1 ? JavaUiBundle.message("build.script.found.notification.import.all", new Object[0]) : JavaUiBundle.message("build.script.found.notification.import", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (providersAndFiles.ke\u2026fication.import\")\n      }");
            String actionName = string;
            notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)actionName, (Runnable)new Runnable(providersAndFiles, project){
                final /* synthetic */ ArrayListMultimap $providersAndFiles;
                final /* synthetic */ Project $project;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    Map map2 = this.$providersAndFiles.asMap();
                    Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"providersAndFiles.asMap()");
                    Map map3 = map2;
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = map3.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> entry;
                        Map.Entry<K, V> entry2 = entry = iterator.next();
                        boolean bl2 = false;
                        map3 = (ProjectOpenProcessor)entry2.getKey();
                        entry2 = entry;
                        bl2 = false;
                        Collection files = (Collection)entry2.getValue();
                        for (VirtualFile file : files) {
                            void provider;
                            provider.importProjectAfterwards(this.$project, file);
                        }
                    }
                }
                {
                    this.$providersAndFiles = arrayListMultimap;
                    this.$project = project;
                }
            }));
        }
        notification.notify(project);
    }

    private final String filesToLinks(Collection<VirtualFile> files, VirtualFile projectDirectory) {
        return CollectionsKt.joinToString$default((Iterable)files, null, null, null, (int)0, null, (Function1)((Function1)new Function1<VirtualFile, String>(projectDirectory){
            final /* synthetic */ VirtualFile $projectDirectory;

            @NotNull
            public final String invoke(@NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                return "<a href='" + file.getPath() + "'>" + VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)this.$projectDirectory) + "</a>";
            }
            {
                this.$projectDirectory = virtualFile;
                super(1);
            }
        }), (int)31, null);
    }

    private final void setupFromSources(Project project, VirtualFile projectDir, ProgressIndicator indicator) {
        ProjectFromSourcesBuilderImpl builder = new ProjectFromSourcesBuilderImpl(new WizardContext(project, (Disposable)project), ModulesProvider.EMPTY_MODULES_PROVIDER);
        String string = projectDir.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"projectDir.path");
        String projectPath = string;
        builder.setBaseProjectPath(projectPath);
        List<DetectedRootData> list = RootDetectionProcessor.detectRoots(new File(projectPath));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"RootDetectionProcessor.d\u2026tRoots(File(projectPath))");
        List<DetectedRootData> roots = list;
        MultiMap<ProjectStructureDetector, DetectedProjectRoot> rootsMap = RootDetectionProcessor.createRootsMap(roots);
        builder.setupProjectStructure(rootsMap);
        for (ProjectStructureDetector detector : rootsMap.keySet()) {
            ProjectDescriptor descriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder.getProjectDescriptor(detector), (String)"builder.getProjectDescriptor(detector)");
            JavaModuleInsight moduleInsight = new JavaModuleInsight((ProgressIndicator)new DelegatingProgressIndicator(), builder.getExistingModuleNames(), builder.getExistingProjectLibraryNames());
            descriptor.setLibraries(LibrariesDetectionStep.calculate(moduleInsight, builder));
            moduleInsight.scanModules();
            descriptor.setModules(moduleInsight.getSuggestedModules());
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(builder, project, projectPath){
            final /* synthetic */ ProjectFromSourcesBuilderImpl $builder;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $projectPath;

            public final void run() {
                this.$builder.commit(this.$project);
                String compileOutput = StringsKt.endsWith$default((CharSequence)this.$projectPath, (char)'/', (boolean)false, (int)2, null) ? this.$projectPath + "out" : this.$projectPath + "/out";
                NewProjectUtil.setCompilerOutputPath(this.$project, compileOutput);
            }
            {
                this.$builder = projectFromSourcesBuilderImpl;
                this.$project = project;
                this.$projectPath = string;
            }
        });
        this.findAndSetupJdk(project, indicator);
        if (roots.size() > 3) {
            this.notifyAboutAutomaticProjectStructure(project);
        }
    }

    private final void findAndSetupJdk(Project project, ProgressIndicator indicator) {
        CompletableFuture future = new CompletableFuture();
        SdkLookupBuilder sdkLookupBuilder = SdkLookup.Companion.newLookupBuilder().withProgressIndicator(indicator);
        JavaSdk javaSdk = JavaSdk.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)javaSdk, (String)"JavaSdk.getInstance()");
        sdkLookupBuilder.withSdkType((SdkType)javaSdk).withVersionFilter((Function1)findAndSetupJdk.1.INSTANCE).withProject(project).onDownloadableSdkSuggested((Function1)findAndSetupJdk.2.INSTANCE).onSdkResolved((Function1)new Function1<Sdk, Unit>(future){
            final /* synthetic */ CompletableFuture $future;

            public final void invoke(@Nullable Sdk it) {
                this.$future.complete(it);
            }
            {
                this.$future = completableFuture;
                super(1);
            }
        }).executeLookup();
        try {
            Sdk sdk = (Sdk)future.get();
            if (sdk != null) {
                WriteAction.runAndWait((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<Throwable>(project, sdk){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Sdk $sdk;

                    public final void run() {
                        NewProjectUtil.applyJdkToProject(this.$project, this.$sdk);
                    }
                    {
                        this.$project = project;
                        this.$sdk = sdk;
                    }
                }));
            }
        }
        catch (Throwable t) {
            SetupJavaProjectFromSourcesActivityKt.access$getLOG$p().warn("Couldn't lookup for a JDK", t);
        }
    }

    private final void notifyAboutAutomaticProjectStructure(Project project) {
        String string = JavaUiBundle.message("project.structure.automatically.detected.notification", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JavaUiBundle.message(\"pr\u2026y.detected.notification\")");
        String message2 = string;
        Notification notification = SetupJavaProjectFromSourcesActivityKt.access$getNOTIFICATION_GROUP$p().createNotification("", message2, NotificationType.INFORMATION, null);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)JavaUiBundle.message("project.structure.automatically.detected.notification.gotit.action", new Object[0]), (Runnable)notifyAboutAutomaticProjectStructure.1.INSTANCE));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)JavaUiBundle.message("project.structure.automatically.detected.notification.configure.action", new Object[0]), (Runnable)new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                ProjectSettingsService.getInstance((Project)this.$project).openProjectSettings();
            }
            {
                this.$project = project;
            }
        }));
        notification.notify(project);
    }

    public static final /* synthetic */ ArrayListMultimap access$searchImporters(SetupJavaProjectFromSourcesActivity $this, VirtualFile projectDirectory) {
        return $this.searchImporters(projectDirectory);
    }

    public static final /* synthetic */ void access$showNotificationToImport(SetupJavaProjectFromSourcesActivity $this, Project project, VirtualFile projectDirectory, ArrayListMultimap providersAndFiles) {
        $this.showNotificationToImport(project, projectDirectory, (ArrayListMultimap<ProjectOpenProcessor, VirtualFile>)providersAndFiles);
    }

    public static final /* synthetic */ void access$setupFromSources(SetupJavaProjectFromSourcesActivity $this, Project project, VirtualFile projectDir, ProgressIndicator indicator) {
        $this.setupFromSources(project, projectDir, indicator);
    }

    public static final /* synthetic */ String access$filesToLinks(SetupJavaProjectFromSourcesActivity $this, Collection files, VirtualFile projectDirectory) {
        return $this.filesToLinks(files, projectDirectory);
    }
}

