/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindClassUsagesDialog;
import com.intellij.find.findUsages.FindMethodUsagesDialog;
import com.intellij.find.findUsages.FindPackageUsagesDialog;
import com.intellij.find.findUsages.FindThrowUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.FindVariableUsagesDialog;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandlerFactory;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.JavaNonCodeSearchElementDescriptionProvider;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFindUsagesHandler
extends FindUsagesHandler {
    private static final Logger LOG = Logger.getInstance(JavaFindUsagesHandler.class);
    @Deprecated
    protected static final String ACTION_STRING = "to find usages of";
    private final PsiElement[] myElementsToSearch;
    private final JavaFindUsagesHandlerFactory myFactory;

    public JavaFindUsagesHandler(@NotNull PsiElement psiElement, @NotNull JavaFindUsagesHandlerFactory factory) {
        if (psiElement == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(1);
        }
        this(psiElement, PsiElement.EMPTY_ARRAY, factory);
    }

    public JavaFindUsagesHandler(@NotNull PsiElement psiElement, PsiElement @NotNull [] elementsToSearch, @NotNull JavaFindUsagesHandlerFactory factory) {
        if (psiElement == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(2);
        }
        if (factory == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(3);
        }
        if (elementsToSearch == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(4);
        }
        super(psiElement);
        this.myElementsToSearch = elementsToSearch;
        this.myFactory = factory;
    }

    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiPackage) {
            return new FindPackageUsagesDialog(element, this.getProject(), (FindUsagesOptions)this.myFactory.getFindPackageOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        }
        if (element instanceof PsiClass) {
            return new FindClassUsagesDialog(element, this.getProject(), (FindUsagesOptions)this.myFactory.getFindClassOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        }
        if (element instanceof PsiMethod) {
            return new FindMethodUsagesDialog(element, this.getProject(), (FindUsagesOptions)this.myFactory.getFindMethodOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        }
        if (element instanceof PsiVariable) {
            return new FindVariableUsagesDialog(element, this.getProject(), (FindUsagesOptions)this.myFactory.getFindVariableOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            return new FindThrowUsagesDialog(element, this.getProject(), this.myFactory.getFindThrowOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, (FindUsagesHandler)this);
        }
        AbstractFindUsagesDialog abstractFindUsagesDialog = super.getFindUsagesDialog(isSingleFile, toShowInNewTab, mustOpenInNewTab);
        if (abstractFindUsagesDialog == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(5);
        }
        return abstractFindUsagesDialog;
    }

    private static boolean askWhetherShouldSearchForParameterInOverridingMethods(@NotNull PsiElement psiElement, @NotNull PsiParameter parameter2) {
        if (psiElement == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(6);
        }
        if (parameter2 == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(7);
        }
        return Messages.showOkCancelDialog((Project)psiElement.getProject(), (String)JavaBundle.message((String)"find.parameter.usages.in.overriding.methods.prompt", (Object[])new Object[]{parameter2.getName()}), (String)JavaBundle.message((String)"find.parameter.usages.in.overriding.methods.title", (Object[])new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private static PsiElement @NotNull [] getParameterElementsToSearch(@NotNull PsiParameter parameter2, @NotNull PsiMethod method) {
        if (parameter2 == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(8);
        }
        if (method == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(9);
        }
        PsiMethod[] overrides = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY);
        for (int i = 0; i < overrides.length; ++i) {
            PsiElement navigationElement = overrides[i].getNavigationElement();
            if (!(navigationElement instanceof PsiMethod)) continue;
            overrides[i] = (PsiMethod)navigationElement;
        }
        ArrayList<PsiParameter> elementsToSearch = new ArrayList<PsiParameter>(overrides.length + 1);
        elementsToSearch.add(parameter2);
        int idx = method.getParameterList().getParameterIndex(parameter2);
        for (PsiMethod override : overrides) {
            PsiParameter[] parameters2 = override.getParameterList().getParameters();
            if (idx >= parameters2.length) continue;
            elementsToSearch.add(parameters2[idx]);
        }
        PsiClass aClass = (PsiClass)ReadAction.compute(() -> ((PsiMethod)method).getContainingClass());
        if (aClass != null) {
            FunctionalExpressionSearch.search((PsiClass)aClass).forEach(element -> {
                PsiParameter[] parameters2;
                if (element instanceof PsiLambdaExpression && idx < (parameters2 = ((PsiLambdaExpression)element).getParameterList().getParameters()).length) {
                    elementsToSearch.add(parameters2[idx]);
                }
            });
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(elementsToSearch);
        if (psiElementArray == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(10);
        }
        return psiElementArray;
    }

    public PsiElement @NotNull [] getPrimaryElements() {
        PsiElement[] psiElementArray;
        PsiMethod method;
        PsiParameter parameter2;
        PsiElement scope;
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiParameter && (scope = (parameter2 = (PsiParameter)element).getDeclarationScope()) instanceof PsiMethod && PsiUtil.canBeOverridden((PsiMethod)(method = (PsiMethod)scope))) {
            boolean hasOverridden;
            PsiClass aClass = method.getContainingClass();
            LOG.assertTrue(aClass != null);
            boolean bl = hasOverridden = OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
            if (!hasOverridden) {
                boolean bl2 = hasOverridden = FunctionalExpressionSearch.search((PsiClass)aClass).findFirst() != null;
            }
            if (hasOverridden && JavaFindUsagesHandler.askWhetherShouldSearchForParameterInOverridingMethods(element, parameter2)) {
                return JavaFindUsagesHandler.getParameterElementsToSearch(parameter2, method);
            }
        }
        if (this.myElementsToSearch.length == 0) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = element;
        } else {
            psiElementArray = this.myElementsToSearch;
        }
        if (psiElementArray == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(11);
        }
        return psiElementArray;
    }

    public PsiElement @NotNull [] getSecondaryElements() {
        PsiField field;
        PsiClass containingClass;
        PsiElement element = this.getPsiElement();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(12);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (element instanceof PsiField && (containingClass = (field = (PsiField)element).getContainingClass()) != null) {
            PsiMethod setter;
            String fieldName = field.getName();
            String propertyName = JavaCodeStyleManager.getInstance((Project)this.getProject()).variableNameToPropertyName(fieldName, VariableKind.FIELD);
            THashSet accessors = new THashSet();
            boolean isStatic = field.hasModifierProperty("static");
            List<PsiMethod> methods = Arrays.asList(containingClass.getMethods());
            PsiMethod getter = PropertyUtilBase.findPropertyGetterWithType((String)propertyName, (boolean)isStatic, (PsiType)field.getType(), methods);
            if (getter != null) {
                accessors.add(getter);
            }
            if ((setter = PropertyUtilBase.findPropertySetterWithType((String)propertyName, (boolean)isStatic, (PsiType)field.getType(), methods)) != null) {
                accessors.add(setter);
            }
            accessors.addAll(PropertyUtilBase.getAccessors((PsiClass)containingClass, (String)fieldName));
            accessors.removeIf(accessor -> field != PropertyUtilBase.findPropertyFieldByMember((PsiMember)accessor));
            if (!accessors.isEmpty()) {
                boolean doSearch;
                boolean containsPhysical = ContainerUtil.find((Iterable)accessors, psiMethod -> psiMethod.isPhysical()) != null;
                boolean bl = doSearch = !containsPhysical || JavaFindUsagesHandler.askShouldSearchAccessors(fieldName);
                if (doSearch) {
                    THashSet elements = new THashSet();
                    for (PsiMethod accessor2 : accessors) {
                        ContainerUtil.addAll((Collection)elements, (Object[])SuperMethodWarningUtil.checkSuperMethods(accessor2, JavaFindUsagesHandler.getActionString()));
                    }
                    PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)elements);
                    if (psiElementArray == null) {
                        JavaFindUsagesHandler.$$$reportNull$$$0(13);
                    }
                    return psiElementArray;
                }
            }
        }
        PsiElement[] psiElementArray = super.getSecondaryElements();
        if (psiElementArray == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(14);
        }
        return psiElementArray;
    }

    private static boolean askShouldSearchAccessors(@NotNull String fieldName) {
        if (fieldName == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(15);
        }
        return Messages.showOkCancelDialog((String)JavaBundle.message((String)"find.field.accessors.prompt", (Object[])new Object[]{fieldName}), (String)JavaBundle.message((String)"find.field.accessors.title", (Object[])new Object[0]), (String)JavaBundle.message((String)"include.accessors", (Object[])new Object[0]), (String)JavaBundle.message((String)"exclude.accessors", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiPackage) {
            JavaPackageFindUsagesOptions javaPackageFindUsagesOptions = this.myFactory.getFindPackageOptions();
            if (javaPackageFindUsagesOptions == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(16);
            }
            return javaPackageFindUsagesOptions;
        }
        if (element instanceof PsiClass) {
            JavaClassFindUsagesOptions javaClassFindUsagesOptions = this.myFactory.getFindClassOptions();
            if (javaClassFindUsagesOptions == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(17);
            }
            return javaClassFindUsagesOptions;
        }
        if (element instanceof PsiMethod) {
            JavaMethodFindUsagesOptions javaMethodFindUsagesOptions = this.myFactory.getFindMethodOptions();
            if (javaMethodFindUsagesOptions == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(18);
            }
            return javaMethodFindUsagesOptions;
        }
        if (element instanceof PsiVariable) {
            JavaVariableFindUsagesOptions javaVariableFindUsagesOptions = this.myFactory.getFindVariableOptions();
            if (javaVariableFindUsagesOptions == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(19);
            }
            return javaVariableFindUsagesOptions;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            JavaThrowFindUsagesOptions javaThrowFindUsagesOptions = this.myFactory.getFindThrowOptions();
            if (javaThrowFindUsagesOptions == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(20);
            }
            return javaThrowFindUsagesOptions;
        }
        FindUsagesOptions findUsagesOptions = super.getFindUsagesOptions(dataContext);
        if (findUsagesOptions == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(21);
        }
        return findUsagesOptions;
    }

    protected Set<String> getStringsToSearch(@NotNull PsiElement element) {
        if (element == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(22);
        }
        return JavaFindUsagesHelper.getElementNames(element);
    }

    public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<? super UsageInfo> processor, @NotNull FindUsagesOptions options) {
        if (element == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(23);
        }
        if (processor == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(24);
        }
        if (options == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(25);
        }
        return JavaFindUsagesHelper.processElementUsages(element, options, processor);
    }

    protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(26);
        }
        return !isSingleFile && new JavaNonCodeSearchElementDescriptionProvider().getElementDescription(psiElement, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.NON_JAVA) != null;
    }

    @NotNull
    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target, @NotNull SearchScope searchScope) {
        if (target == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(27);
        }
        if (searchScope == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(28);
        }
        if (target instanceof PsiMethod) {
            LinkedHashSet<PsiMethod> superTargets = new LinkedHashSet<PsiMethod>();
            PsiMethod[] superMethods = ((PsiMethod)target).findDeepestSuperMethods();
            if (superMethods.length == 0) {
                superTargets.add((PsiMethod)target);
            }
            if (searchScope instanceof LocalSearchScope) {
                Object[] scopeElements = ((LocalSearchScope)searchScope).getScope();
                GlobalSearchScope resolveScope = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])ContainerUtil.map2Array((Object[])scopeElements, GlobalSearchScope.class, PsiElement::getResolveScope)));
                for (HierarchicalMethodSignature superSignature : PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)target, resolveScope).getSuperSignatures()) {
                    PsiMethod[] psiMethodArray;
                    PsiMethod method = superSignature.getMethod();
                    PsiMethod[] deepestSupers = method.findDeepestSuperMethods();
                    if (deepestSupers.length == 0) {
                        PsiMethod[] psiMethodArray2 = new PsiMethod[1];
                        psiMethodArray = psiMethodArray2;
                        psiMethodArray2[0] = method;
                    } else {
                        psiMethodArray = deepestSupers;
                    }
                    Collections.addAll(superTargets, psiMethodArray);
                }
            } else {
                Collections.addAll(superTargets, superMethods);
            }
            LinkedHashSet<PsiReference> result = new LinkedHashSet<PsiReference>();
            for (PsiMethod superMethod : superTargets) {
                result.addAll(MethodReferencesSearch.search((PsiMethod)superMethod, (SearchScope)searchScope, (boolean)true).findAll());
            }
            LinkedHashSet<PsiReference> linkedHashSet = result;
            if (linkedHashSet == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(29);
            }
            return linkedHashSet;
        }
        Collection collection = super.findReferencesToHighlight(target, searchScope);
        if (collection == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(30);
        }
        return collection;
    }

    @NotNull
    protected static String getActionString() {
        String string = FindBundle.message((String)"find.super.method.warning.action.verb", (Object[])new Object[0]);
        if (string == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToSearch";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/JavaFindUsagesHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/JavaFindUsagesHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesDialog";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterElementsToSearch";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryElements";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryElements";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesOptions";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencesToHighlight";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "askWhetherShouldSearchForParameterInOverridingMethods";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParameterElementsToSearch";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "askShouldSearchAccessors";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getStringsToSearch";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processElementUsages";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isSearchForTextOccurrencesAvailable";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findReferencesToHighlight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

