/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldDescriptorImpl
extends ValueDescriptorImpl
implements FieldDescriptor {
    public static final String OUTER_LOCAL_VAR_FIELD_PREFIX = "val$";
    private final Field myField;
    private final ObjectReference myObject;
    private Boolean myIsPrimitive;
    private final boolean myIsStatic;

    public FieldDescriptorImpl(Project project, ObjectReference objRef, @NotNull Field field) {
        if (field == null) {
            FieldDescriptorImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myIsPrimitive = null;
        this.myObject = objRef;
        this.myField = field;
        this.myIsStatic = field.isStatic();
        this.setLvalue(!field.isFinal());
    }

    @Override
    public Field getField() {
        return this.myField;
    }

    @Override
    public ObjectReference getObject() {
        return this.myObject;
    }

    @Override
    public void setAncestor(NodeDescriptor oldDescriptor) {
        super.setAncestor(oldDescriptor);
        Boolean isPrimitive = ((FieldDescriptorImpl)oldDescriptor).myIsPrimitive;
        if (isPrimitive != null) {
            this.myIsPrimitive = isPrimitive;
        }
    }

    @Override
    public boolean isPrimitive() {
        if (this.myIsPrimitive == null) {
            Value value2 = this.getValue();
            this.myIsPrimitive = value2 != null ? Boolean.valueOf(super.isPrimitive()) : Boolean.valueOf(DebuggerUtils.isPrimitiveType((String)this.myField.typeName()));
        }
        return this.myIsPrimitive;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (this.myObject != null) {
                Value fieldValue = this.myObject.getValue(this.myField);
                if (this.populateExceptionStackTraceIfNeeded(fieldValue, evaluationContext)) {
                    fieldValue = this.myObject.getValue(this.myField);
                }
                return fieldValue;
            }
            return this.myField.declaringType().getValue(this.myField);
        }
        catch (InternalException e) {
            if (evaluationContext.getDebugProcess().getVirtualMachineProxy().canBeModified()) {
                LOG.debug((Throwable)e);
            } else {
                LOG.warn((Throwable)e);
            }
            throw new EvaluateException("Internal error, see logs for more details");
        }
        catch (ObjectCollectedException ignored) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    private boolean populateExceptionStackTraceIfNeeded(Value value2, EvaluationContextImpl evaluationContext) {
        if ("stackTrace".equals(this.getName()) && ViewsGeneralSettings.getInstance().POPULATE_THROWABLE_STACKTRACE && value2 instanceof ArrayReference && ((ArrayReference)value2).length() == 0 && DebuggerUtils.instanceOf((Type)this.myObject.type(), (String)"java.lang.Throwable")) {
            try {
                FieldDescriptorImpl.invokeExceptionGetStackTrace(this.myObject, evaluationContext);
                return true;
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        return false;
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    @Override
    public String getName() {
        return this.myField.name();
    }

    @Override
    public String calcValueName() {
        String res = super.calcValueName();
        if (Boolean.TRUE.equals(this.getUserData(SHOW_DECLARING_TYPE))) {
            return NodeRendererSettings.getInstance().getClassRenderer().renderTypeName(this.myField.declaringType().name()) + "." + res;
        }
        return res;
    }

    public boolean isOuterLocalVariableValue() {
        try {
            return DebuggerUtils.isSynthetic((TypeComponent)this.myField) && this.myField.name().startsWith(OUTER_LOCAL_VAR_FIELD_PREFIX);
        }
        catch (UnsupportedOperationException ignored) {
            return false;
        }
    }

    @Override
    @Nullable
    public String getDeclaredType() {
        return this.myField.typeName();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        String fieldName;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        if (this.isStatic()) {
            String typeName = this.myField.declaringType().name().replace('$', '.');
            typeName = DebuggerTreeNodeExpression.normalize(typeName, PositionUtil.getContextElement((StackFrameContext)context), this.myProject);
            fieldName = typeName + "." + this.getName();
        } else {
            fieldName = this.isOuterLocalVariableValue() ? StringUtil.trimStart((String)this.getName(), (String)OUTER_LOCAL_VAR_FIELD_PREFIX) : "this." + this.getName();
        }
        try {
            return elementFactory.createExpressionFromText(fieldName, null);
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(JavaDebuggerBundle.message((String)"error.invalid.field.name", (Object[])new Object[]{this.getName()}), (Throwable)e);
        }
    }

    @Override
    public XValueModifier getModifier(JavaValue value2) {
        return new JavaValueModifier(value2){

            @Override
            protected void setValueImpl(@NotNull XExpression expression2, @NotNull XValueModifier.XModificationCallback callback) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (callback == null) {
                    1.$$$reportNull$$$0(1);
                }
                final DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(FieldDescriptorImpl.this.getProject()).getContext();
                final Field field = FieldDescriptorImpl.this.getField();
                FieldValueSetter setter = null;
                if (!field.isStatic()) {
                    ObjectReference object = FieldDescriptorImpl.this.getObject();
                    if (object != null) {
                        setter = v -> object.setValue(field, v);
                    }
                } else {
                    ReferenceType refType = field.declaringType();
                    if (refType instanceof ClassType) {
                        ClassType classType = (ClassType)refType;
                        setter = v -> classType.setValue(field, v);
                    }
                }
                if (setter != null) {
                    final FieldValueSetter finalSetter = setter;
                    this.set(expression2, callback, debuggerContext, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            finalSetter.setValue(1.preprocessValue(evaluationContext, newValue, this.getLType()));
                            1.update(debuggerContext);
                        }

                        @Override
                        public ClassLoaderReference getClassLoader(EvaluationContextImpl evaluationContext) {
                            return field.declaringType().classLoader();
                        }

                        @Override
                        @NotNull
                        public Type getLType() throws ClassNotLoadedException {
                            Type type2 = field.type();
                            if (type2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return type2;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/FieldDescriptorImpl$1$1", "getLType"));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/ui/impl/watch/FieldDescriptorImpl$1";
                objectArray[2] = "setValueImpl";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/debugger/ui/impl/watch/FieldDescriptorImpl", "<init>"));
    }

    private static interface FieldValueSetter {
        public void setValue(Value var1) throws InvalidTypeException, ClassNotLoadedException;
    }
}

