/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.parsers;

import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.debugger.memory.agent.UnexpectedValueFormatException;
import com.intellij.debugger.memory.agent.parsers.BackwardReferencesParser;
import com.intellij.debugger.memory.agent.parsers.ObjectReferencesParser;
import com.intellij.debugger.memory.agent.parsers.ResultParser;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/debugger/memory/agent/parsers/GcRootsPathsParser;", "Lcom/intellij/debugger/memory/agent/parsers/ResultParser;", "Lcom/intellij/debugger/memory/agent/ReferringObjectsInfo;", "()V", "parse", "value", "Lcom/sun/jdi/Value;", "fillWithNulls", "", "Lcom/sun/jdi/ArrayReference;", "intellij.java.debugger.impl"})
public final class GcRootsPathsParser
implements ResultParser<ReferringObjectsInfo> {
    public static final GcRootsPathsParser INSTANCE;

    @Override
    @NotNull
    public ReferringObjectsInfo parse(@NotNull Value value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        if (value2 instanceof ArrayReference) {
            if (((ArrayReference)value2).length() != 2) {
                throw (Throwable)new UnexpectedValueFormatException("Array must represent 2 values: objects and backward references");
            }
            Value value3 = ((ArrayReference)value2).getValue(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)value3, (String)"value.getValue(0)");
            Object values = ObjectReferencesParser.INSTANCE.parse(value3);
            Value value4 = ((ArrayReference)value2).getValue(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)value4, (String)"value.getValue(1)");
            Object backwardReferences = BackwardReferencesParser.INSTANCE.parse(value4);
            this.fillWithNulls((ArrayReference)value2);
            return new ReferringObjectsInfo((List<? extends ObjectReference>)values, (List<? extends List<Integer>>)backwardReferences);
        }
        throw (Throwable)new UnexpectedValueFormatException("Array of arrays is expected");
    }

    /*
     * WARNING - void declaration
     */
    private final void fillWithNulls(@NotNull ArrayReference $this$fillWithNulls) {
        int n = 0;
        int n2 = $this$fillWithNulls.length();
        while (n < n2) {
            void i;
            $this$fillWithNulls.setValue((int)i, null);
            ++i;
        }
    }

    private GcRootsPathsParser() {
    }

    static {
        GcRootsPathsParser gcRootsPathsParser;
        INSTANCE = gcRootsPathsParser = new GcRootsPathsParser();
    }
}

