/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.debugger.engine.RemoteStateState;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.debugger.impl.attach.JavaDebuggerAttachUtil;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.debugger.impl.attach.SAJDWPRemoteConnection;
import com.intellij.debugger.impl.attach.SAPidRemoteConnection;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.execution.application.AppMainV2;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.xdebugger.attach.XDefaultLocalAttachGroup;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.intellij.xdebugger.attach.XLocalAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XLocalAttachGroup;
import com.jetbrains.sa.SaJdwp;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaAttachDebuggerProvider
implements XLocalAttachDebuggerProvider {
    private static final Logger LOG = Logger.getInstance(JavaAttachDebuggerProvider.class);
    private static final Key<Map<String, LocalAttachInfo>> ADDRESS_MAP_KEY = Key.create((String)"ADDRESS_MAP");
    private static final XLocalAttachGroup ourAttachGroup = new JavaDebuggerAttachGroup("Java", -20);

    @NotNull
    public XLocalAttachGroup getAttachGroup() {
        XLocalAttachGroup xLocalAttachGroup = ourAttachGroup;
        if (xLocalAttachGroup == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(0);
        }
        return xLocalAttachGroup;
    }

    @NotNull
    public List<XLocalAttachDebugger> getAvailableDebuggers(@NotNull Project project, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        LocalAttachInfo info;
        HashMap<String, LocalAttachInfo> addressMap;
        if (project == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(1);
        }
        if (processInfo == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(2);
        }
        if (contextHolder == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(3);
        }
        if ((addressMap = (HashMap<String, LocalAttachInfo>)contextHolder.getUserData(ADDRESS_MAP_KEY)) == null) {
            addressMap = new HashMap<String, LocalAttachInfo>();
            contextHolder.putUserData(ADDRESS_MAP_KEY, addressMap);
            HashMap<String, LocalAttachInfo> map2 = addressMap;
            Set<String> attachedPids = JavaDebuggerAttachUtil.getAttachedPids(project);
            VirtualMachine.list().forEach(desc -> {
                String pid = desc.id();
                LocalAttachInfo address = JavaAttachDebuggerProvider.getProcessAttachInfo(pid, attachedPids, false);
                if (address != null) {
                    map2.put(pid, address);
                }
            });
        }
        if ((info = JavaAttachDebuggerProvider.getAttachInfo(project, processInfo.getPid(), processInfo.getCommandLine(), addressMap)) != null && this.isDebuggerAttach(info)) {
            List<XLocalAttachDebugger> list = Collections.singletonList(new JavaLocalAttachDebugger(project, info));
            if (list == null) {
                JavaAttachDebuggerProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<XLocalAttachDebugger> list = Collections.emptyList();
        if (list == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    boolean isDebuggerAttach(LocalAttachInfo info) {
        return info instanceof DebuggerLocalAttachInfo;
    }

    @Nullable
    private static LocalAttachInfo getAttachInfo(@Nullable Project project, int pid, String commandLine, @Nullable Map<String, LocalAttachInfo> addressMap) {
        LocalAttachInfo res;
        String pidString = String.valueOf(pid);
        if (addressMap != null && (res = addressMap.get(pidString)) != null) {
            return res;
        }
        res = JavaAttachDebuggerProvider.getProcessAttachInfo(ParametersListUtil.parse((String)commandLine), pidString);
        if (res == null && addressMap == null) {
            res = JavaAttachDebuggerProvider.getProcessAttachInfo(pidString, project != null ? JavaDebuggerAttachUtil.getAttachedPids(project) : Collections.emptySet(), true);
        }
        return res;
    }

    @Nullable
    static LocalAttachInfo getProcessAttachInfo(List<String> arguments, String pid) {
        for (String argument : arguments) {
            String[] params;
            if (!argument.startsWith("-agentlib:jdwp") || !argument.contains("server=y") || !argument.contains("transport=dt_shmem") && !argument.contains("transport=dt_socket")) continue;
            boolean socket = argument.contains("transport=dt_socket");
            for (String param : params = argument.split(",")) {
                if (!param.startsWith("address")) continue;
                try {
                    String address = param.split("=")[1];
                    address = StringUtil.trimStart((String)address, (String)"*:");
                    return new DebuggerLocalAttachInfo(socket, address, null, pid, false);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LocalAttachInfo getProcessAttachInfo(String pid, @NotNull Set<String> attachedPids, boolean validate) {
        if (attachedPids == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(6);
        }
        if (!attachedPids.contains(pid)) {
            Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> JavaAttachDebuggerProvider.getProcessAttachInfoInt(pid, validate));
            try {
                LocalAttachInfo localAttachInfo = (LocalAttachInfo)future.get(5L, TimeUnit.SECONDS);
                return localAttachInfo;
            }
            catch (Exception e) {
                LOG.info("Timeout while getting attach info", (Throwable)e);
            }
            finally {
                future.cancel(true);
            }
        }
        return null;
    }

    @Nullable
    static LocalAttachInfo getProcessAttachInfo(@NotNull BaseProcessHandler processHandler) {
        if (processHandler == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(7);
        }
        return JavaAttachDebuggerProvider.getAttachInfo(null, OSProcessUtil.getProcessID((Process)processHandler.getProcess()), processHandler.getCommandLine(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static LocalAttachInfo getProcessAttachInfoInt(String pid, boolean validate) {
        int n;
        String[] stringArray;
        boolean autoAddress;
        String property;
        String command;
        block27: {
            VirtualMachine vm = null;
            try {
                vm = validate ? JavaDebuggerAttachUtil.attachVirtualMachine(pid) : VirtualMachine.attach(pid);
                Properties agentProperties = vm.getAgentProperties();
                command = agentProperties.getProperty("sun.java.command");
                if (!StringUtil.isEmpty((String)command)) {
                    command = StringUtil.replace((String)command, (String)AppMainV2.class.getName(), (String)"").trim();
                    command = StringUtil.notNullize((String)StringUtil.substringBefore((String)command, (String)" "), (String)command);
                }
                if ((property = agentProperties.getProperty("sun.jdwp.listenerAddress")) != null && property.indexOf(58) != -1) {
                    autoAddress = false;
                    String args = agentProperties.getProperty("sun.jvm.args");
                    if (StringUtil.isEmpty((String)args)) return new DebuggerLocalAttachInfo(!"dt_shmem".equals(StringUtil.substringBefore((String)property, (String)":")), StringUtil.substringAfter((String)property, (String)":"), command, pid, autoAddress);
                    stringArray = args.split(" ");
                    n = stringArray.length;
                    break block27;
                }
                if (pid.equals(OSProcessUtil.getApplicationPid())) return null;
                Properties systemProperties = vm.getSystemProperties();
                LocalAttachInfo info = SAJDWPLocalAttachInfo.create(systemProperties, command, pid);
                if (info != null) {
                    LocalAttachInfo localAttachInfo = info;
                    return localAttachInfo;
                }
                info = SAPIDLocalAttachInfo.create(systemProperties, command, pid);
                if (info == null) return null;
                LocalAttachInfo localAttachInfo = info;
                return localAttachInfo;
            }
            catch (InternalError e) {
                LOG.warn((Throwable)e);
                return null;
            }
            catch (AttachNotSupportedException | IOException exception) {
                return null;
            }
            finally {
                if (vm != null) {
                    try {
                        vm.detach();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            String arg = stringArray[i];
            if (!arg.startsWith("-agentlib:jdwp")) continue;
            autoAddress = !arg.contains("address=");
            return new DebuggerLocalAttachInfo(!"dt_shmem".equals(StringUtil.substringBefore((String)property, (String)":")), StringUtil.substringAfter((String)property, (String)":"), command, pid, autoAddress);
        }
        return new DebuggerLocalAttachInfo(!"dt_shmem".equals(StringUtil.substringBefore((String)property, (String)":")), StringUtil.substringAfter((String)property, (String)":"), command, pid, autoAddress);
    }

    static void attach(LocalAttachInfo info, Project project) {
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createConfiguration(info.getSessionName(), ProcessAttachRunConfigurationType.FACTORY);
        ((ProcessAttachRunConfiguration)runSettings.getConfiguration()).myAttachInfo = info;
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)runSettings, (Executor)ProcessAttachDebugExecutor.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/attach/JavaAttachDebuggerProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachedPids";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/attach/JavaAttachDebuggerProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDebuggers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDebuggers";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProcessAttachInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ProcessAttachRunConfigurationType
    implements ConfigurationType {
        static final ProcessAttachRunConfigurationType INSTANCE = new ProcessAttachRunConfigurationType();
        static final ConfigurationFactory FACTORY = new ConfigurationFactory(INSTANCE){

            @NotNull
            public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new ProcessAttachRunConfiguration(project);
            }

            @NotNull
            public String getId() {
                String string = INSTANCE.getId();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/impl/attach/JavaAttachDebuggerProvider$ProcessAttachRunConfigurationType$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/impl/attach/JavaAttachDebuggerProvider$ProcessAttachRunConfigurationType$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createTemplateConfiguration";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        private ProcessAttachRunConfigurationType() {
        }

        @NotNull
        @Nls
        public String getDisplayName() {
            String string = this.getId();
            if (string == null) {
                ProcessAttachRunConfigurationType.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        public String getConfigurationTypeDescription() {
            return this.getId();
        }

        public Icon getIcon() {
            return null;
        }

        @NotNull
        public String getId() {
            return "ProcessAttachRunConfigurationType";
        }

        public ConfigurationFactory[] getConfigurationFactories() {
            return new ConfigurationFactory[]{FACTORY};
        }

        public String getHelpTopic() {
            return "reference.dialogs.rundebug.ProcessAttachRunConfigurationType";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/attach/JavaAttachDebuggerProvider$ProcessAttachRunConfigurationType", "getDisplayName"));
        }
    }

    private static class ProcessAttachRunConfiguration
    extends RunConfigurationBase<Element> {
        private LocalAttachInfo myAttachInfo;

        protected ProcessAttachRunConfiguration(@NotNull Project project) {
            if (project == null) {
                ProcessAttachRunConfiguration.$$$reportNull$$$0(0);
            }
            super(project, ProcessAttachRunConfigurationType.FACTORY, "ProcessAttachRunConfiguration");
        }

        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            throw new IllegalStateException("Editing is not supported");
        }

        @Nullable
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            if (executor == null) {
                ProcessAttachRunConfiguration.$$$reportNull$$$0(1);
            }
            if (environment == null) {
                ProcessAttachRunConfiguration.$$$reportNull$$$0(2);
            }
            return new RemoteStateState(this.getProject(), this.myAttachInfo.createConnection());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/impl/attach/JavaAttachDebuggerProvider$ProcessAttachRunConfiguration";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ProcessAttachDebuggerRunner
    extends GenericDebuggerRunner {
        @Override
        @NotNull
        public String getRunnerId() {
            return "ProcessAttachDebuggerRunner";
        }

        @Override
        @Nullable
        protected RunContentDescriptor createContentDescriptor(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            if (state == null) {
                ProcessAttachDebuggerRunner.$$$reportNull$$$0(0);
            }
            if (environment == null) {
                ProcessAttachDebuggerRunner.$$$reportNull$$$0(1);
            }
            return this.attachVirtualMachine(state, environment, ((RemoteState)state).getRemoteConnection(), false);
        }

        @Override
        public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
            if (executorId == null) {
                ProcessAttachDebuggerRunner.$$$reportNull$$$0(2);
            }
            if (profile == null) {
                ProcessAttachDebuggerRunner.$$$reportNull$$$0(3);
            }
            return executorId.equals(ProcessAttachDebugExecutor.INSTANCE.getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executorId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/impl/attach/JavaAttachDebuggerProvider$ProcessAttachDebuggerRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createContentDescriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canRun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProcessAttachDebugExecutor
    extends DefaultDebugExecutor {
        static ProcessAttachDebugExecutor INSTANCE = new ProcessAttachDebugExecutor();

        private ProcessAttachDebugExecutor() {
        }

        @NotNull
        public String getId() {
            return "ProcessAttachDebug";
        }
    }

    static abstract class LocalAttachInfo {
        final String myClass;
        final String myPid;

        LocalAttachInfo(String aClass, String pid) {
            this.myClass = aClass;
            this.myPid = pid;
        }

        abstract RemoteConnection createConnection();

        String getSessionName() {
            return "pid " + this.myPid;
        }

        abstract String getDebuggerName();

        String getProcessDisplayText(String text2) {
            return text2;
        }
    }

    static class SAJDWPLocalAttachInfo
    extends LocalAttachInfo {
        private final List<String> myCommands;

        SAJDWPLocalAttachInfo(String aClass, String pid, List<String> commands) {
            super(aClass, pid);
            this.myCommands = commands;
        }

        @Nullable
        static LocalAttachInfo create(Properties systemProperties, String aClass, String pid) {
            try {
                List commands = SaJdwp.getServerProcessCommand((Properties)systemProperties, (String)pid, (String)"0", (boolean)false, (String)PathUtil.getJarPathForClass(SaJdwp.class));
                return new SAJDWPLocalAttachInfo(aClass, pid, commands);
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        RemoteConnection createConnection() {
            return new SAJDWPRemoteConnection(this.myPid, this.myCommands);
        }

        @Override
        String getDebuggerName() {
            return "Read Only Java Debugger";
        }
    }

    static class SAPIDLocalAttachInfo
    extends LocalAttachInfo {
        final String mySAJarPath;

        SAPIDLocalAttachInfo(String aClass, String pid, String SAJarPath) {
            super(aClass, pid);
            this.mySAJarPath = SAJarPath;
        }

        @Nullable
        static SAPIDLocalAttachInfo create(Properties systemProperties, String aClass, String pid) throws IOException {
            File saJdiJar = new File(systemProperties.getProperty("java.home"), "../lib/sa-jdi.jar");
            if (saJdiJar.exists()) {
                return new SAPIDLocalAttachInfo(aClass, pid, saJdiJar.getCanonicalPath());
            }
            return null;
        }

        @Override
        RemoteConnection createConnection() {
            return new SAPidRemoteConnection(this.myPid, this.mySAJarPath);
        }

        @Override
        String getDebuggerName() {
            return "Read Only Java Debugger";
        }
    }

    private static class DebuggerLocalAttachInfo
    extends LocalAttachInfo {
        private final boolean myUseSocket;
        private final String myAddress;
        private final boolean myAutoAddress;

        DebuggerLocalAttachInfo(boolean socket, @NotNull String address, String aClass, String pid, boolean autoAddress) {
            if (address == null) {
                DebuggerLocalAttachInfo.$$$reportNull$$$0(0);
            }
            super(aClass, pid);
            this.myUseSocket = socket;
            this.myAddress = address;
            this.myAutoAddress = autoAddress;
        }

        @Override
        RemoteConnection createConnection() {
            if (this.myAutoAddress) {
                return new PidRemoteConnection(this.myPid);
            }
            String host = "127.0.0.1";
            String port = this.myAddress;
            int pos = port.indexOf(":");
            if (pos != -1) {
                host = port.substring(0, pos);
                port = port.substring(pos + 1);
            }
            return new PidRemoteConnection(this.myPid, this.myUseSocket, host, port, false);
        }

        @Override
        String getSessionName() {
            if (this.myAutoAddress) {
                return super.getSessionName();
            }
            return this.myAddress.contains(":") ? this.myAddress : "localhost:" + this.myAddress;
        }

        @Override
        String getDebuggerName() {
            return "Java Debugger";
        }

        @Override
        String getProcessDisplayText(String text2) {
            return text2 + " (" + this.myAddress + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "address", "com/intellij/debugger/impl/attach/JavaAttachDebuggerProvider$DebuggerLocalAttachInfo", "<init>"));
        }
    }

    static class JavaDebuggerAttachGroup
    extends XDefaultLocalAttachGroup {
        private final String myName;
        private final int myOrder;

        JavaDebuggerAttachGroup(String name2, int order) {
            this.myName = name2;
            this.myOrder = order;
        }

        public int getOrder() {
            return this.myOrder;
        }

        @NotNull
        public String getGroupName() {
            String string = this.myName;
            if (string == null) {
                JavaDebuggerAttachGroup.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getProcessDisplayText(@NotNull Project project, @NotNull ProcessInfo info, @NotNull UserDataHolder dataHolder) {
            if (project == null) {
                JavaDebuggerAttachGroup.$$$reportNull$$$0(1);
            }
            if (info == null) {
                JavaDebuggerAttachGroup.$$$reportNull$$$0(2);
            }
            if (dataHolder == null) {
                JavaDebuggerAttachGroup.$$$reportNull$$$0(3);
            }
            LocalAttachInfo attachInfo = JavaAttachDebuggerProvider.getAttachInfo(project, info.getPid(), info.getCommandLine(), (Map)dataHolder.getUserData(ADDRESS_MAP_KEY));
            assert (attachInfo != null);
            String executable = info.getExecutableDisplayName();
            String res = "java".equals(executable) ? (!StringUtil.isEmpty((String)attachInfo.myClass) ? attachInfo.myClass : StringUtil.notNullize((String)((String)ArrayUtil.getLastElement((Object[])info.getCommandLine().split(" "))))) : executable;
            String string = attachInfo.getProcessDisplayText(res);
            if (string == null) {
                JavaDebuggerAttachGroup.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/attach/JavaAttachDebuggerProvider$JavaDebuggerAttachGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/attach/JavaAttachDebuggerProvider$JavaDebuggerAttachGroup";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessDisplayText";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getProcessDisplayText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JavaLocalAttachDebugger
    implements XLocalAttachDebugger {
        private final Project myProject;
        private final LocalAttachInfo myInfo;

        JavaLocalAttachDebugger(@NotNull Project project, @NotNull LocalAttachInfo info) {
            if (project == null) {
                JavaLocalAttachDebugger.$$$reportNull$$$0(0);
            }
            if (info == null) {
                JavaLocalAttachDebugger.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myInfo = info;
        }

        @NotNull
        public String getDebuggerDisplayName() {
            String string = this.myInfo.getDebuggerName();
            if (string == null) {
                JavaLocalAttachDebugger.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void attachDebugSession(@NotNull Project project, @NotNull ProcessInfo processInfo) {
            if (project == null) {
                JavaLocalAttachDebugger.$$$reportNull$$$0(3);
            }
            if (processInfo == null) {
                JavaLocalAttachDebugger.$$$reportNull$$$0(4);
            }
            JavaAttachDebuggerProvider.attach(this.myInfo, this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/attach/JavaAttachDebuggerProvider$JavaLocalAttachDebugger";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/attach/JavaAttachDebuggerProvider$JavaLocalAttachDebugger";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggerDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "attachDebugSession";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

