/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;

class NewArrayInstanceEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance(NewArrayInstanceEvaluator.class);
    private final Evaluator myArrayTypeEvaluator;
    private final Evaluator myDimensionEvaluator;
    private final Evaluator myInitializerEvaluator;

    NewArrayInstanceEvaluator(Evaluator arrayTypeEvaluator, Evaluator dimensionEvaluator, Evaluator initializerEvaluator) {
        this.myArrayTypeEvaluator = arrayTypeEvaluator;
        this.myDimensionEvaluator = dimensionEvaluator;
        this.myInitializerEvaluator = initializerEvaluator;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        int dimension;
        Object o;
        DebugProcessImpl debugProcess = context.getDebugProcess();
        Object obj = this.myArrayTypeEvaluator.evaluate(context);
        if (!(obj instanceof ArrayType)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.array.type.expected", (Object[])new Object[0]));
        }
        ArrayType arrayType = (ArrayType)obj;
        Object[] initialValues = null;
        if (this.myDimensionEvaluator != null) {
            o = this.myDimensionEvaluator.evaluate(context);
            if (!(o instanceof Value) || !DebuggerUtils.isNumeric((Value)((Value)o))) {
                throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.array.dimention.numeric.value.expected", (Object[])new Object[0]));
            }
            PrimitiveValue value2 = (PrimitiveValue)o;
            dimension = value2.intValue();
        } else {
            o = this.myInitializerEvaluator.evaluate(context);
            if (!(o instanceof Object[])) {
                throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.cannot.evaluate.array.initializer", (Object[])new Object[0]));
            }
            initialValues = (Object[])o;
            dimension = initialValues.length;
        }
        ArrayReference arrayReference = DebuggerUtilsEx.mirrorOfArray(arrayType, dimension, context);
        if (initialValues != null && initialValues.length > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting initial values: dimension = " + dimension + "; array size is " + initialValues.length);
            }
            NewArrayInstanceEvaluator.setInitialValues(arrayReference, initialValues, context);
        }
        return arrayReference;
    }

    private static void setInitialValues(ArrayReference arrayReference, Object[] values, EvaluationContextImpl context) throws EvaluateException {
        ArrayType type2 = (ArrayType)arrayReference.referenceType();
        DebugProcessImpl debugProcess = context.getDebugProcess();
        try {
            if (type2.componentType() instanceof ArrayType) {
                ArrayType componentType = (ArrayType)type2.componentType();
                int length = arrayReference.length();
                for (int idx = 0; idx < length; ++idx) {
                    Object value2 = values[idx];
                    if (value2 instanceof Value) {
                        arrayReference.setValue(idx, (Value)value2);
                        continue;
                    }
                    ArrayReference componentArray = (ArrayReference)arrayReference.getValue(idx);
                    Object[] componentArrayValues = (Object[])value2;
                    if (componentArray == null) {
                        componentArray = DebuggerUtilsEx.mirrorOfArray(componentType, componentArrayValues.length, context);
                        arrayReference.setValue(idx, (Value)componentArray);
                    }
                    NewArrayInstanceEvaluator.setInitialValues(componentArray, componentArrayValues, context);
                }
            } else if (values.length > 0) {
                arrayReference.setValues(new ArrayList<Object>(Arrays.asList(values)));
            }
        }
        catch (ClassNotLoadedException ex) {
            ReferenceType referenceType;
            try {
                referenceType = context.isAutoLoadClasses() ? debugProcess.loadClass(context, ex.className(), type2.classLoader()) : null;
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            if (referenceType != null) {
                NewArrayInstanceEvaluator.setInitialValues(arrayReference, values, context);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"error.class.not.loaded", (Object[])new Object[]{ex.className()}));
        }
        catch (InvalidTypeException ex) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.incompatible.array.initializer.type", (Object[])new Object[0]));
        }
        catch (IndexOutOfBoundsException ex) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.invalid.array.size", (Object[])new Object[0]));
        }
        catch (ClassCastException ex) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.cannot.initialize.array", (Object[])new Object[0]));
        }
    }
}

