/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.AutoRendererAction;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.JavaReferringObjectsValue;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewAsGroup
extends ActionGroup
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ViewAsGroup.class);
    private volatile AnAction[] myChildren = AnAction.EMPTY_ARRAY;

    public ViewAsGroup() {
        super(Presentation.NULL_STRING, true);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (this.myChildren == null) {
            ViewAsGroup.$$$reportNull$$$0(0);
        }
        return this.myChildren;
    }

    private static AnAction[] calcChildren(List<JavaValue> values, Project project) {
        AnAction[] viewAsActions;
        ArrayList<RendererAction> renderers = new ArrayList<RendererAction>();
        List<NodeRenderer> allRenderers = NodeRendererSettings.getInstance().getAllRenderers(project);
        boolean anyValueDescriptor = false;
        for (NodeRenderer nodeRenderer : allRenderers) {
            boolean allApp = true;
            for (JavaValue value2 : values) {
                if (value2 instanceof JavaReferringObjectsValue) {
                    return AnAction.EMPTY_ARRAY;
                }
                ValueDescriptorImpl valueDescriptor = value2.getDescriptor();
                anyValueDescriptor = true;
                if (valueDescriptor.isValueValid() && nodeRenderer.isApplicable(valueDescriptor.getType())) continue;
                allApp = false;
                break;
            }
            if (!anyValueDescriptor) {
                return AnAction.EMPTY_ARRAY;
            }
            if (!allApp) continue;
            renderers.add(new RendererAction(nodeRenderer));
        }
        ArrayList<Object> children = new ArrayList<Object>();
        for (AnAction viewAsAction : viewAsActions = ((DefaultActionGroup)ActionManager.getInstance().getAction("Debugger.Representation")).getChildren(null)) {
            if (viewAsAction instanceof AutoRendererAction) {
                if (renderers.size() <= 1) continue;
                viewAsAction.getTemplatePresentation().setVisible(true);
                children.add(viewAsAction);
                continue;
            }
            children.add(viewAsAction);
        }
        if (!children.isEmpty()) {
            children.add(Separator.getInstance());
        }
        children.addAll(renderers);
        return children.toArray(AnAction.EMPTY_ARRAY);
    }

    public void update(final @NotNull AnActionEvent event) {
        if (event == null) {
            ViewAsGroup.$$$reportNull$$$0(1);
        }
        if (!DebuggerAction.isFirstStart(event)) {
            return;
        }
        this.myChildren = AnAction.EMPTY_ARRAY;
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(event.getDataContext());
        final List<JavaValue> values = ViewAsGroup.getSelectedValues(event);
        if (values.isEmpty()) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        final DebugProcessImpl process2 = debuggerContext.getDebugProcess();
        if (process2 == null) {
            event.getPresentation().setEnabled(false);
            return;
        }
        process2.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                ViewAsGroup.access$202(ViewAsGroup.this, ViewAsGroup.calcChildren(values, process2.getProject()));
                DebuggerAction.enableAction(event, ViewAsGroup.this.myChildren.length > 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/ViewAsGroup$1", "threadAction"));
            }
        });
    }

    @NotNull
    public static List<JavaValue> getSelectedValues(AnActionEvent event) {
        List list = StreamEx.of((Collection)XDebuggerTreeActionBase.getSelectedNodes((DataContext)event.getDataContext())).map(XValueContainerNode::getValueContainer).select(JavaValue.class).toList();
        if (list == null) {
            ViewAsGroup.$$$reportNull$$$0(2);
        }
        return list;
    }

    static /* synthetic */ AnAction[] access$202(ViewAsGroup x0, AnAction[] x1) {
        x0.myChildren = x1;
        return x1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/actions/ViewAsGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/actions/ViewAsGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedValues";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RendererAction
    extends ToggleAction {
        private final NodeRenderer myNodeRenderer;

        RendererAction(NodeRenderer nodeRenderer) {
            super(nodeRenderer.getName());
            this.myNodeRenderer = nodeRenderer;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            List<JavaValue> values;
            if (e == null) {
                RendererAction.$$$reportNull$$$0(0);
            }
            if ((values = ViewAsGroup.getSelectedValues(e)).isEmpty()) {
                return false;
            }
            for (JavaValue value2 : values) {
                if (value2.getDescriptor().getLastRenderer() == this.myNodeRenderer) continue;
                return false;
            }
            return true;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                RendererAction.$$$reportNull$$$0(1);
            }
            if (!state) {
                return;
            }
            DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
            List<JavaValue> values = ViewAsGroup.getSelectedValues(e);
            final List selectedNodes = XDebuggerTreeActionBase.getSelectedNodes((DataContext)e.getDataContext());
            LOG.assertTrue(!values.isEmpty());
            DebugProcessImpl process2 = debuggerContext.getDebugProcess();
            if (process2 == null) {
                return;
            }
            process2.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (XValueNodeImpl node : selectedNodes) {
                        XValue container = (XValue)node.getValueContainer();
                        if (!(container instanceof JavaValue)) continue;
                        ((JavaValue)container).setRenderer(myNodeRenderer, node);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/ViewAsGroup$RendererAction$1", "threadAction"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/debugger/actions/ViewAsGroup$RendererAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

