/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.ModuleSourceSet;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.CompilerCacheManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.compiler.server.BuildManager;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.DummyCompileContext;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.DefaultModuleConfigurationEditorFactory;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompilerUtil;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Chunk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.DateFormatUtil;
import gnu.trove.THashSet;
import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.TaskFuture;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class CompileDriver {
    private static final Logger LOG = Logger.getInstance(CompileDriver.class);
    private static final Key<Boolean> COMPILATION_STARTED_AUTOMATICALLY = Key.create((String)"compilation_started_automatically");
    private static final Key<ExitStatus> COMPILE_SERVER_BUILD_STATUS = Key.create((String)"COMPILE_SERVER_BUILD_STATUS");
    private static final long ONE_MINUTE_MS = 60000L;
    private final Project myProject;
    private final Map<Module, String> myModuleOutputPaths = new HashMap<Module, String>();
    private final Map<Module, String> myModuleTestOutputPaths = new HashMap<Module, String>();

    public CompileDriver(Project project) {
        this.myProject = project;
    }

    public void setCompilerFilter(CompilerFilter compilerFilter) {
    }

    public void rebuild(CompileStatusNotification callback) {
        this.doRebuild(callback, new ProjectCompileScope(this.myProject));
    }

    public void make(CompileScope scope, CompileStatusNotification callback) {
        this.make(scope, false, callback);
    }

    public void make(CompileScope scope, boolean withModalProgress, CompileStatusNotification callback) {
        if (this.validateCompilerConfiguration(scope)) {
            this.startup(scope, false, false, withModalProgress, callback, null);
        } else {
            callback.finished(true, 0, 0, (CompileContext)DummyCompileContext.create((Project)this.myProject));
        }
    }

    public boolean isUpToDate(CompileScope scope) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("isUpToDate operation started");
        }
        CompilerTask task = new CompilerTask(this.myProject, "Classes up-to-date check", true, false, false, CompileDriver.isCompilationStartedAutomatically(scope));
        CompileContextImpl compileContext = new CompileContextImpl(this.myProject, task, scope, true, false);
        Ref result = new Ref();
        Runnable compileWork = () -> {
            ProgressIndicator indicator = compileContext.getProgressIndicator();
            if (indicator.isCanceled() || this.myProject.isDisposed()) {
                return;
            }
            try {
                TaskFuture<?> future = this.compileInExternalProcess(compileContext, true);
                if (future != null) {
                    while (!future.waitFor(200L, TimeUnit.MILLISECONDS)) {
                        if (!indicator.isCanceled()) continue;
                        future.cancel(false);
                    }
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            finally {
                result.set(COMPILE_SERVER_BUILD_STATUS.get((UserDataHolder)compileContext));
                if (!this.myProject.isDisposed()) {
                    CompilerCacheManager.getInstance(this.myProject).flushCaches();
                }
            }
        };
        ProgressIndicatorProvider indicatorProvider = ProgressIndicatorProvider.getInstance();
        if (!EventQueue.isDispatchThread() && indicatorProvider.getProgressIndicator() != null) {
            task.run(compileWork, null, indicatorProvider.getProgressIndicator());
        } else {
            task.start(compileWork, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("isUpToDate operation finished");
        }
        return ExitStatus.UP_TO_DATE.equals(result.get());
    }

    public void compile(CompileScope scope, CompileStatusNotification callback) {
        if (this.validateCompilerConfiguration(scope)) {
            this.startup(scope, false, true, callback, null);
        } else {
            callback.finished(true, 0, 0, (CompileContext)DummyCompileContext.create((Project)this.myProject));
        }
    }

    private void doRebuild(CompileStatusNotification callback, CompileScope compileScope) {
        if (this.validateCompilerConfiguration(compileScope)) {
            this.startup(compileScope, true, false, callback, null);
        } else {
            callback.finished(true, 0, 0, (CompileContext)DummyCompileContext.create((Project)this.myProject));
        }
    }

    public static void setCompilationStartedAutomatically(CompileScope scope) {
        scope.putUserData(COMPILATION_STARTED_AUTOMATICALLY, (Object)true);
    }

    private static boolean isCompilationStartedAutomatically(CompileScope scope) {
        return Boolean.TRUE.equals(scope.getUserData(COMPILATION_STARTED_AUTOMATICALLY));
    }

    private List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildScopes(@NotNull CompileContextImpl compileContext, CompileScope scope, Collection<String> paths) {
        if (compileContext == null) {
            CompileDriver.$$$reportNull$$$0(0);
        }
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        boolean forceBuild = !compileContext.isMake();
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> explicitScopes = CompileScopeUtil.getBaseScopeForExternalBuild(scope);
        if (explicitScopes != null) {
            scopes.addAll(explicitScopes);
        } else if (!(compileContext.isRebuild() || paths.isEmpty() && CompileScopeUtil.allProjectModulesAffected(compileContext))) {
            CompileScopeUtil.addScopesForSourceSets(scope.getAffectedSourceSets(), scope.getAffectedUnloadedModules(), scopes, forceBuild);
        } else {
            scopes.addAll(CmdlineProtoUtil.createAllModulesScopes((boolean)forceBuild));
        }
        if (paths.isEmpty()) {
            scopes = this.mergeScopesFromProviders(scope, scopes, forceBuild);
        }
        return scopes;
    }

    private List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> mergeScopesFromProviders(CompileScope scope, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, boolean forceBuild) {
        for (BuildTargetScopeProvider provider : (BuildTargetScopeProvider[])BuildTargetScopeProvider.EP_NAME.getExtensions()) {
            List providerScopes = (List)ReadAction.compute(() -> this.myProject.isDisposed() ? Collections.emptyList() : provider.getBuildTargetScopes(scope, this.myProject, forceBuild));
            scopes = CompileScopeUtil.mergeScopes(scopes, (List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>)providerScopes);
        }
        return scopes;
    }

    @Nullable
    private TaskFuture<?> compileInExternalProcess(final @NotNull CompileContextImpl compileContext, boolean onlyCheckUpToDate) {
        HashMap<String, String> builderParams;
        if (compileContext == null) {
            CompileDriver.$$$reportNull$$$0(1);
        }
        CompileScope scope = compileContext.getCompileScope();
        List<String> paths = CompileScopeUtil.fetchFiles(compileContext);
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes = this.getBuildScopes(compileContext, scope, paths);
        if (onlyCheckUpToDate) {
            builderParams = new HashMap<String, String>();
        } else {
            Map exported = scope.exportUserData();
            if (!exported.isEmpty()) {
                builderParams = new HashMap();
                for (Map.Entry entry : exported.entrySet()) {
                    String _key = ((Key)entry.getKey()).toString();
                    String _value = entry.getValue().toString();
                    builderParams.put(_key, _value);
                }
            } else {
                builderParams = new HashMap();
            }
        }
        if (!scope.getAffectedUnloadedModules().isEmpty()) {
            builderParams.put("load_unloaded_modules", Boolean.TRUE.toString());
        }
        final MultiMap<String, Artifact> outputToArtifact = ArtifactCompilerUtil.containsArtifacts(scopes) ? ArtifactCompilerUtil.createOutputToArtifactMap(this.myProject) : null;
        BuildManager buildManager = BuildManager.getInstance();
        buildManager.cancelAutoMakeTasks(this.myProject);
        return buildManager.scheduleBuild(this.myProject, compileContext.isRebuild(), compileContext.isMake(), onlyCheckUpToDate, scopes, paths, builderParams, new DefaultMessageHandler(this.myProject){

            @Override
            public void sessionTerminated(@NotNull UUID sessionId) {
                ProblemsView view;
                if (sessionId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (compileContext.shouldUpdateProblemsView() && (view = (ProblemsView)CompileDriver.this.myProject.getServiceIfCreated(ProblemsView.class)) != null) {
                    view.clearProgress();
                    view.clearOldMessages(compileContext.getCompileScope(), compileContext.getSessionId());
                }
            }

            @Override
            public void handleFailure(@NotNull UUID sessionId, CmdlineRemoteProto.Message.Failure failure) {
                String trace;
                if (sessionId == null) {
                    1.$$$reportNull$$$0(1);
                }
                compileContext.addMessage(CompilerMessageCategory.ERROR, failure.hasDescription() ? failure.getDescription() : "", null, -1, -1);
                String string = trace = failure.hasStacktrace() ? failure.getStacktrace() : null;
                if (trace != null) {
                    LOG.info(trace);
                }
                compileContext.putUserData(COMPILE_SERVER_BUILD_STATUS, ExitStatus.ERRORS);
            }

            @Override
            protected void handleCompileMessage(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage message2) {
                CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind2 = message2.getKind();
                String messageText = message2.getText();
                if (kind2 == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.PROGRESS) {
                    ProgressIndicator indicator = compileContext.getProgressIndicator();
                    indicator.setText(messageText);
                    if (message2.hasDone()) {
                        indicator.setFraction((double)message2.getDone());
                    }
                } else {
                    String sourceFilePath;
                    CompilerMessageCategory category = CompileDriver.convertToCategory(kind2, CompilerMessageCategory.INFORMATION);
                    String string = sourceFilePath = message2.hasSourceFilePath() ? message2.getSourceFilePath() : null;
                    if (sourceFilePath != null) {
                        sourceFilePath = FileUtil.toSystemIndependentName((String)sourceFilePath);
                    }
                    long line = message2.hasLine() ? message2.getLine() : -1L;
                    long column = message2.hasColumn() ? message2.getColumn() : -1L;
                    String srcUrl = sourceFilePath != null ? VirtualFileManager.constructUrl((String)"file", (String)sourceFilePath) : null;
                    compileContext.addMessage(category, messageText, srcUrl, (int)line, (int)column);
                    if (compileContext.shouldUpdateProblemsView() && kind2 == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.JPS_INFO) {
                        Project project = compileContext.getProject();
                        ProblemsView.getInstance(project).addMessage(new CompilerMessageImpl(project, category, messageText), compileContext.getSessionId());
                    }
                }
            }

            @Override
            protected void handleBuildEvent(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event) {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type eventType = event.getEventType();
                switch (eventType) {
                    case FILES_GENERATED: {
                        List generated = event.getGeneratedFilesList();
                        CompilationStatusListener publisher = CompileDriver.this.myProject.isDisposed() ? null : (CompilationStatusListener)CompileDriver.this.myProject.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
                        THashSet writtenArtifactOutputPaths = outputToArtifact != null ? new THashSet(FileUtil.PATH_HASHING_STRATEGY) : null;
                        for (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile generatedFile : generated) {
                            Collection artifacts;
                            String root = FileUtil.toSystemIndependentName((String)generatedFile.getOutputRoot());
                            String relativePath = FileUtil.toSystemIndependentName((String)generatedFile.getRelativePath());
                            if (publisher != null) {
                                publisher.fileGenerated(root, relativePath);
                            }
                            if (outputToArtifact == null || (artifacts = outputToArtifact.get((Object)root)).isEmpty()) continue;
                            writtenArtifactOutputPaths.add(FileUtil.toSystemDependentName((String)DeploymentUtil.appendToPath((String)root, (String)relativePath)));
                        }
                        if (writtenArtifactOutputPaths == null || writtenArtifactOutputPaths.isEmpty()) break;
                        ArtifactsCompiler.addWrittenPaths(compileContext, (Set<String>)writtenArtifactOutputPaths);
                        break;
                    }
                    case BUILD_COMPLETED: {
                        ExitStatus status = ExitStatus.SUCCESS;
                        if (event.hasCompletionStatus()) {
                            CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status completionStatus = event.getCompletionStatus();
                            switch (completionStatus) {
                                case CANCELED: {
                                    status = ExitStatus.CANCELLED;
                                    break;
                                }
                                case ERRORS: {
                                    status = ExitStatus.ERRORS;
                                    break;
                                }
                                case SUCCESS: {
                                    status = ExitStatus.SUCCESS;
                                    break;
                                }
                                case UP_TO_DATE: {
                                    status = ExitStatus.UP_TO_DATE;
                                }
                            }
                        }
                        compileContext.putUserDataIfAbsent(COMPILE_SERVER_BUILD_STATUS, status);
                        break;
                    }
                    case CUSTOM_BUILDER_MESSAGE: {
                        String text2;
                        CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage message2;
                        if (!event.hasCustomBuilderMessage() || !"JPS".equals((message2 = event.getCustomBuilderMessage()).getBuilderId()) || !"!unprocessed_fs_changes_detected!".equals(message2.getMessageType()) || StringUtil.isEmpty((String)(text2 = message2.getMessageText()))) break;
                        compileContext.addMessage(CompilerMessageCategory.INFORMATION, text2, null, -1, -1);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "sessionId";
                objectArray2[1] = "com/intellij/compiler/impl/CompileDriver$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sessionTerminated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleFailure";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void startup(CompileScope scope, boolean isRebuild, boolean forceCompile, CompileStatusNotification callback, CompilerMessage message2) {
        this.startup(scope, isRebuild, forceCompile, false, callback, message2);
    }

    private void startup(CompileScope scope, boolean isRebuild, boolean forceCompile, boolean withModalProgress, CompileStatusNotification callback, CompilerMessage message2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        String name2 = JavaCompilerBundle.message((String)(isRebuild ? "compiler.content.name.rebuild" : (forceCompile ? "compiler.content.name.recompile" : "compiler.content.name.make")), (Object[])new Object[0]);
        CompilerTask compileTask = new CompilerTask(this.myProject, name2, isUnitTestMode, !withModalProgress, true, CompileDriver.isCompilationStartedAutomatically(scope), withModalProgress);
        StatusBar.Info.set((String)"", (Project)this.myProject, (String)"Compiler");
        this.myProject.save();
        if (!isUnitTestMode) {
            ApplicationManager.getApplication().saveSettings();
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        CompileContextImpl compileContext = new CompileContextImpl(this.myProject, compileTask, scope, !isRebuild && !forceCompile, isRebuild);
        Runnable compileWork = () -> {
            ProgressIndicator indicator = compileContext.getProgressIndicator();
            if (indicator.isCanceled() || this.myProject.isDisposed()) {
                if (callback != null) {
                    callback.finished(true, 0, 0, (CompileContext)compileContext);
                }
                return;
            }
            CompilerCacheManager compilerCacheManager = CompilerCacheManager.getInstance(this.myProject);
            try {
                LOG.info("COMPILATION STARTED (BUILD PROCESS)");
                if (message2 != null) {
                    compileContext.addMessage(message2);
                }
                if (isRebuild) {
                    CompilerUtil.runInContext(compileContext, "Clearing build system data...", () -> compilerCacheManager.clearCaches(compileContext));
                }
                boolean beforeTasksOk = this.executeCompileTasks(compileContext, true);
                int errorCount = compileContext.getMessageCount(CompilerMessageCategory.ERROR);
                if (!beforeTasksOk || errorCount > 0) {
                    COMPILE_SERVER_BUILD_STATUS.set((UserDataHolder)compileContext, (Object)(errorCount > 0 ? ExitStatus.ERRORS : ExitStatus.CANCELLED));
                    return;
                }
                TaskFuture<?> future = this.compileInExternalProcess(compileContext, false);
                if (future != null) {
                    while (!future.waitFor(200L, TimeUnit.MILLISECONDS)) {
                        if (!indicator.isCanceled()) continue;
                        future.cancel(false);
                    }
                    if (!this.executeCompileTasks(compileContext, false)) {
                        COMPILE_SERVER_BUILD_STATUS.set((UserDataHolder)compileContext, (Object)ExitStatus.CANCELLED);
                    }
                    if (compileContext.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                        COMPILE_SERVER_BUILD_STATUS.set((UserDataHolder)compileContext, (Object)ExitStatus.ERRORS);
                    }
                }
            }
            catch (ProcessCanceledException ignored) {
                compileContext.putUserDataIfAbsent(COMPILE_SERVER_BUILD_STATUS, ExitStatus.CANCELLED);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            finally {
                compilerCacheManager.flushCaches();
                long duration = this.notifyCompilationCompleted(compileContext, callback, (ExitStatus)COMPILE_SERVER_BUILD_STATUS.get((UserDataHolder)compileContext));
                CompilerUtil.logDuration("\tCOMPILATION FINISHED (BUILD PROCESS); Errors: " + compileContext.getMessageCount(CompilerMessageCategory.ERROR) + "; warnings: " + compileContext.getMessageCount(CompilerMessageCategory.WARNING), duration);
            }
        };
        compileTask.start(compileWork, () -> {
            int rv;
            if (isRebuild && (rv = Messages.showOkCancelDialog((Project)this.myProject, (String)JavaCompilerBundle.message((String)"you.are.about.to.rebuild.the.whole.project", (Object[])new Object[0]), (String)JavaCompilerBundle.message((String)"confirm.project.rebuild", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.build", (Object[])new Object[0]), (String)JavaCompilerBundle.message((String)"button.rebuild", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == 0) {
                this.startup(scope, false, false, callback, null);
                return;
            }
            this.startup(scope, isRebuild, forceCompile, callback, message2);
        });
    }

    @Nullable
    public static ExitStatus getExternalBuildExitStatus(CompileContext context) {
        return (ExitStatus)context.getUserData(COMPILE_SERVER_BUILD_STATUS);
    }

    private long notifyCompilationCompleted(CompileContextImpl compileContext, CompileStatusNotification callback, ExitStatus _status) {
        long duration = System.currentTimeMillis() - compileContext.getStartCompilationStamp();
        if (!this.myProject.isDisposed()) {
            HashSet affectedRoots;
            Module[] affectedModules = compileContext.getCompileScope().getAffectedModules();
            if (_status != ExitStatus.UP_TO_DATE && _status != ExitStatus.CANCELLED && !(affectedRoots = ContainerUtil.newHashSet((Object[])CompilerPaths.getOutputPaths((Module[])affectedModules))).isEmpty()) {
                ProgressIndicator indicator = compileContext.getProgressIndicator();
                indicator.setText(JavaCompilerBundle.message((String)"synchronizing.output.directories", (Object[])new Object[0]));
                CompilerUtil.refreshOutputRoots(affectedRoots);
                indicator.setText("");
            }
        }
        SwingUtilities.invokeLater(() -> {
            int errorCount = 0;
            int warningCount = 0;
            try {
                errorCount = compileContext.getMessageCount(CompilerMessageCategory.ERROR);
                warningCount = compileContext.getMessageCount(CompilerMessageCategory.WARNING);
                if (callback != null) {
                    callback.finished(_status == ExitStatus.CANCELLED, errorCount, warningCount, (CompileContext)compileContext);
                }
            }
            catch (Throwable throwable) {
                if (callback != null) {
                    callback.finished(_status == ExitStatus.CANCELLED, errorCount, warningCount, (CompileContext)compileContext);
                }
                throw throwable;
            }
            if (!this.myProject.isDisposed()) {
                MessageType messageType;
                String statusMessage = CompileDriver.createStatusMessage(_status, warningCount, errorCount, duration);
                MessageType messageType2 = errorCount > 0 ? MessageType.ERROR : (messageType = warningCount > 0 ? MessageType.WARNING : MessageType.INFO);
                if (duration > 60000L && CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).DISPLAY_NOTIFICATION_POPUP) {
                    ToolWindowManager.getInstance((Project)this.myProject).notifyByBalloon("Messages", messageType, statusMessage);
                }
                String wrappedMessage = _status != ExitStatus.UP_TO_DATE ? "<a href='#'>" + statusMessage + "</a>" : statusMessage;
                Notification notification = CompilerManager.NOTIFICATION_GROUP.createNotification("", wrappedMessage, messageType.toNotificationType(), (NotificationListener)new MessagesActivationListener(compileContext)).setImportant(false);
                compileContext.getBuildSession().registerCloseAction(() -> ((Notification)notification).expire());
                notification.notify(this.myProject);
                if (_status != ExitStatus.UP_TO_DATE && compileContext.getMessageCount(null) > 0) {
                    String msg = DateFormatUtil.formatDateTime((Date)new Date()) + " - " + statusMessage;
                    compileContext.addMessage(CompilerMessageCategory.INFORMATION, msg, null, -1, -1);
                }
            }
        });
        return duration;
    }

    private static String createStatusMessage(ExitStatus status, int warningCount, int errorCount, long duration) {
        String message2;
        if (status == ExitStatus.CANCELLED) {
            message2 = JavaCompilerBundle.message((String)"status.compilation.aborted", (Object[])new Object[0]);
        } else if (status == ExitStatus.UP_TO_DATE) {
            message2 = JavaCompilerBundle.message((String)"status.all.up.to.date", (Object[])new Object[0]);
        } else {
            message2 = status == ExitStatus.SUCCESS ? (warningCount > 0 ? JavaCompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings", (Object[])new Object[]{warningCount}) : JavaCompilerBundle.message((String)"status.compilation.completed.successfully", (Object[])new Object[0])) : JavaCompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings.and.errors", (Object[])new Object[]{errorCount, warningCount});
            message2 = message2 + " in " + StringUtil.formatDurationApproximate((long)duration);
        }
        return message2;
    }

    private String getModuleOutputPath(Module module, boolean inTestSourceContent) {
        Map<Module, String> map2 = inTestSourceContent ? this.myModuleTestOutputPaths : this.myModuleOutputPaths;
        return map2.computeIfAbsent(module, k -> CompilerPaths.getModuleOutputPath((Module)module, (boolean)inTestSourceContent));
    }

    public void executeCompileTask(CompileTask task, CompileScope scope, String contentName, Runnable onTaskFinished) {
        CompilerTask progressManagerTask = new CompilerTask(this.myProject, contentName, false, false, true, CompileDriver.isCompilationStartedAutomatically(scope));
        CompileContextImpl compileContext = new CompileContextImpl(this.myProject, progressManagerTask, scope, false, false);
        FileDocumentManager.getInstance().saveAllDocuments();
        progressManagerTask.start(() -> {
            try {
                task.execute((CompileContext)compileContext);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            finally {
                if (onTaskFinished != null) {
                    onTaskFinished.run();
                }
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCompileTasks(CompileContext context, boolean beforeTasks) {
        block10: {
            if (this.myProject.isDisposed()) {
                return false;
            }
            CompilerManager manager = CompilerManager.getInstance((Project)this.myProject);
            ProgressIndicator progressIndicator = context.getProgressIndicator();
            progressIndicator.pushState();
            try {
                List tasks;
                List list = tasks = beforeTasks ? manager.getBeforeTasks() : manager.getAfterTaskList();
                if (tasks.size() <= 0) break block10;
                progressIndicator.setText(JavaCompilerBundle.message((String)(beforeTasks ? "progress.executing.precompile.tasks" : "progress.executing.postcompile.tasks"), (Object[])new Object[0]));
                for (CompileTask task : tasks) {
                    try {
                        if (task.execute(context)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        LOG.error("Error executing task", t);
                        context.addMessage(CompilerMessageCategory.INFORMATION, "Task " + task.toString() + " failed, please see idea.log for details", null, -1, -1);
                    }
                }
            }
            finally {
                progressIndicator.popState();
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
                if (statusBar != null) {
                    statusBar.setInfo("");
                }
            }
        }
        return true;
    }

    private boolean validateCompilerConfiguration(CompileScope scope) {
        try {
            Module[] scopeModules = scope.getAffectedModules();
            ArrayList<String> modulesWithoutOutputPathSpecified = new ArrayList<String>();
            ArrayList<String> modulesWithoutJdkAssigned = new ArrayList<String>();
            CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
            boolean projectSdkNotSpecified = false;
            boolean projectOutputNotSpecified = false;
            for (Module module : scopeModules) {
                if (!compilerManager.isValidationEnabled(module)) continue;
                boolean hasSources = CompileDriver.hasSources(module, JavaSourceRootType.SOURCE);
                boolean hasTestSources = CompileDriver.hasSources(module, JavaSourceRootType.TEST_SOURCE);
                if (!hasSources && !hasTestSources) continue;
                Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (jdk == null) {
                    projectSdkNotSpecified |= ModuleRootManager.getInstance((Module)module).isSdkInherited();
                    modulesWithoutJdkAssigned.add(module.getName());
                }
                String outputPath = this.getModuleOutputPath(module, false);
                String testsOutputPath = this.getModuleOutputPath(module, true);
                if (outputPath == null && testsOutputPath == null) {
                    CompilerModuleExtension compilerExtension = CompilerModuleExtension.getInstance((Module)module);
                    projectOutputNotSpecified |= compilerExtension != null && compilerExtension.isCompilerOutputPathInherited();
                    modulesWithoutOutputPathSpecified.add(module.getName());
                    continue;
                }
                if (outputPath == null && hasSources) {
                    modulesWithoutOutputPathSpecified.add(module.getName());
                }
                if (testsOutputPath != null || !hasTestSources) continue;
                modulesWithoutOutputPathSpecified.add(module.getName());
            }
            if (!modulesWithoutJdkAssigned.isEmpty()) {
                this.showNotSpecifiedError("error.jdk.not.specified", projectSdkNotSpecified, modulesWithoutJdkAssigned, JavaCompilerBundle.message((String)"modules.classpath.title", (Object[])new Object[0]));
                return false;
            }
            if (!modulesWithoutOutputPathSpecified.isEmpty()) {
                this.showNotSpecifiedError("error.output.not.specified", projectOutputNotSpecified, modulesWithoutOutputPathSpecified, DefaultModuleConfigurationEditorFactory.getInstance().getOutputEditorDisplayName());
                return false;
            }
            List chunks = ModuleCompilerUtil.getCyclicDependencies((Project)this.myProject, Arrays.asList(scopeModules));
            for (Chunk chunk : chunks) {
                Set sourceSets = chunk.getNodes();
                if (sourceSets.size() <= 1) continue;
                Sdk jdk = null;
                LanguageLevel languageLevel = null;
                for (ModuleSourceSet sourceSet : sourceSets) {
                    Module module = sourceSet.getModule();
                    Sdk moduleJdk = ModuleRootManager.getInstance((Module)module).getSdk();
                    if (jdk == null) {
                        jdk = moduleJdk;
                    } else if (!jdk.equals(moduleJdk)) {
                        this.showCyclicModulesHaveDifferentJdksError(ModuleSourceSet.getModules((Collection)sourceSets));
                        return false;
                    }
                    LanguageLevel moduleLanguageLevel = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
                    if (languageLevel == null) {
                        languageLevel = moduleLanguageLevel;
                        continue;
                    }
                    if (languageLevel.equals((Object)moduleLanguageLevel)) continue;
                    this.showCyclicModulesHaveDifferentLanguageLevel(ModuleSourceSet.getModules((Collection)sourceSets));
                    return false;
                }
            }
            return true;
        }
        catch (Throwable e) {
            LOG.error(e);
            return false;
        }
    }

    private void showCyclicModulesHaveDifferentLanguageLevel(Set<? extends Module> modulesInChunk) {
        Module firstModule = (Module)ContainerUtil.getFirstItem(modulesInChunk);
        LOG.assertTrue(firstModule != null);
        String moduleNameToSelect = firstModule.getName();
        String moduleNames = CompileDriver.getModulesString(modulesInChunk);
        Messages.showMessageDialog((Project)this.myProject, (String)JavaCompilerBundle.message((String)"error.chunk.modules.must.have.same.language.level", (Object[])new Object[]{moduleNames}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(moduleNameToSelect, null);
    }

    private void showCyclicModulesHaveDifferentJdksError(Set<? extends Module> modulesInChunk) {
        Module firstModule = (Module)ContainerUtil.getFirstItem(modulesInChunk);
        LOG.assertTrue(firstModule != null);
        String moduleNameToSelect = firstModule.getName();
        String moduleNames = CompileDriver.getModulesString(modulesInChunk);
        Messages.showMessageDialog((Project)this.myProject, (String)JavaCompilerBundle.message((String)"error.chunk.modules.must.have.same.jdk", (Object[])new Object[]{moduleNames}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(moduleNameToSelect, null);
    }

    private static String getModulesString(Collection<? extends Module> modulesInChunk) {
        return StringUtil.join(modulesInChunk, module -> "\"" + module.getName() + "\"", (String)"\n");
    }

    private static boolean hasSources(Module module, JavaSourceRootType rootType) {
        return !ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)rootType).isEmpty();
    }

    private void showNotSpecifiedError(@PropertyKey(resourceBundle="messages.JavaCompilerBundle") @NonNls String resourceId, boolean notSpecifiedValueInheritedFromProject, List<String> modules, String editorNameToSelect) {
        String nameToSelect = null;
        StringBuilder names2 = new StringBuilder();
        int maxModulesToShow = 10;
        for (String name2 : ContainerUtil.getFirstItems(modules, (int)10)) {
            if (nameToSelect == null && !notSpecifiedValueInheritedFromProject) {
                nameToSelect = name2;
            }
            if (names2.length() > 0) {
                names2.append(",\n");
            }
            names2.append("\"");
            names2.append(name2);
            names2.append("\"");
        }
        if (modules.size() > 10) {
            names2.append(",\n...");
        }
        String message2 = JavaCompilerBundle.message((String)resourceId, (Object[])new Object[]{modules.size(), names2.toString()});
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(message2);
        }
        Messages.showMessageDialog((Project)this.myProject, (String)message2, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(nameToSelect, editorNameToSelect);
    }

    private void showConfigurationDialog(@Nullable String moduleNameToSelect, @Nullable String tabNameToSelect) {
        ProjectSettingsService service = ProjectSettingsService.getInstance((Project)this.myProject);
        if (moduleNameToSelect != null) {
            service.showModuleConfigurationDialog(moduleNameToSelect, tabNameToSelect);
        } else {
            service.openProjectSettings();
        }
    }

    public static CompilerMessageCategory convertToCategory(CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind2, CompilerMessageCategory defaultCategory) {
        switch (kind2) {
            case ERROR: 
            case INTERNAL_BUILDER_ERROR: {
                return CompilerMessageCategory.ERROR;
            }
            case WARNING: {
                return CompilerMessageCategory.WARNING;
            }
            case INFO: 
            case JPS_INFO: 
            case OTHER: {
                return CompilerMessageCategory.INFORMATION;
            }
        }
        return defaultCategory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "compileContext";
        objectArray2[1] = "com/intellij/compiler/impl/CompileDriver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBuildScopes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compileInExternalProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MessagesActivationListener
    extends NotificationListener.Adapter {
        private final WeakReference<Project> myProjectRef;
        private final Object myContentId;

        MessagesActivationListener(CompileContextImpl compileContext) {
            this.myProjectRef = new WeakReference<Project>(compileContext.getProject());
            this.myContentId = compileContext.getBuildSession().getContentId();
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            Project project;
            if (notification == null) {
                MessagesActivationListener.$$$reportNull$$$0(0);
            }
            if (e == null) {
                MessagesActivationListener.$$$reportNull$$$0(1);
            }
            if ((project = (Project)this.myProjectRef.get()) != null && !project.isDisposed() && CompilerTask.showCompilerContent(project, this.myContentId)) {
                ToolWindow tw = ToolWindowManager.getInstance((Project)project).getToolWindow("Messages");
                if (tw != null) {
                    tw.activate(null, false);
                }
            } else {
                notification.expire();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/compiler/impl/CompileDriver$MessagesActivationListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

