/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.visibility;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.visibility.AccessCanBeTightenedInspection;
import com.intellij.codeInspection.visibility.EntryPointWithVisibilityLevel;
import com.intellij.codeInspection.visibility.VisibilityExtension;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import one.util.streamex.StreamEx;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VisibilityInspection
extends GlobalJavaBatchInspectionTool {
    private static final ExtensionPointName<VisibilityExtension> EP_NAME = new ExtensionPointName("com.intellij.visibility");
    private static final Logger LOG = Logger.getInstance(VisibilityInspection.class);
    public boolean SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS = true;
    public boolean SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES = true;
    public boolean SUGGEST_PRIVATE_FOR_INNERS;
    public boolean SUGGEST_FOR_CONSTANTS = true;
    private final Map<String, Boolean> myExtensions = new TreeMap<String, Boolean>();
    @NonNls
    public static final String SHORT_NAME = "WeakerAccess";

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @NotNull
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new AccessCanBeTightenedInspection(this);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
        if (string == null) {
            VisibilityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        RefClass refClass;
        RefMethod refMethod;
        Boolean isEnumConstant;
        RefField refField;
        if (refEntity == null) {
            VisibilityInspection.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            VisibilityInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            VisibilityInspection.$$$reportNull$$$0(3);
        }
        if (globalContext == null) {
            VisibilityInspection.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            VisibilityInspection.$$$reportNull$$$0(5);
        }
        if (!(refEntity instanceof RefJavaElement)) {
            return null;
        }
        RefJavaElement refElement = (RefJavaElement)refEntity;
        if (refElement instanceof RefParameter) {
            return null;
        }
        if (refElement.isSyntheticJSP()) {
            return null;
        }
        if (!this.SUGGEST_FOR_CONSTANTS && refEntity instanceof RefField && (refField = (RefField)refEntity).isFinal() && refField.isStatic() && refField.isOnlyAssignedInInitializer()) {
            return null;
        }
        int minLevel = this.getMinVisibilityLevel(refElement);
        if (refElement.isEntry() && minLevel == -1) {
            return null;
        }
        if (refElement instanceof RefField) {
            Boolean implicitlyWritten = (Boolean)refElement.getUserData(RefField.IMPLICITLY_WRITTEN);
            if (implicitlyWritten != null && implicitlyWritten.booleanValue()) {
                return null;
            }
            Boolean implicitlyRead = (Boolean)refElement.getUserData(RefField.IMPLICITLY_READ);
            if (implicitlyRead != null && implicitlyRead.booleanValue()) {
                return null;
            }
        }
        if (refElement instanceof RefImplicitConstructor) {
            return null;
        }
        if (refElement instanceof RefField && (isEnumConstant = (Boolean)refElement.getUserData(RefField.ENUM_CONSTANT)) != null && isEnumConstant.booleanValue()) {
            return null;
        }
        if (refElement instanceof RefMethod && (refMethod = (RefMethod)refElement).isExternalOverride()) {
            return null;
        }
        if (refElement instanceof RefClass && ((refClass = (RefClass)refElement).isAnonymous() || refClass.isServlet() || refClass.isApplet() || refClass.isLocalClass())) {
            return null;
        }
        if (this.keepVisibilityLevel(refElement)) {
            return null;
        }
        if (refElement.getInReferences().isEmpty()) {
            if (minLevel == -1 && (minLevel = this.getMinVisibilityLevel(refElement)) == -1) {
                return null;
            }
            String weakestAccess = PsiUtil.getAccessModifier((int)minLevel);
            if (weakestAccess != refElement.getAccessModifier()) {
                return VisibilityInspection.createDescriptions((RefElement)refElement, weakestAccess, manager, globalContext);
            }
        }
        if (refElement instanceof RefClass && VisibilityInspection.isTopLevelClass((RefElement)refElement) && minLevel <= 0 && !this.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES) {
            return null;
        }
        if (refElement.getOwner() instanceof RefClass && (refClass = (RefClass)refElement.getOwner()).isInterface()) {
            return null;
        }
        String access = this.getPossibleAccess(refElement, minLevel <= 0 ? 1 : minLevel);
        if (access != refElement.getAccessModifier()) {
            return VisibilityInspection.createDescriptions((RefElement)refElement, access, manager, globalContext);
        }
        return null;
    }

    private boolean keepVisibilityLevel(@NotNull RefJavaElement refElement) {
        if (refElement == null) {
            VisibilityInspection.$$$reportNull$$$0(6);
        }
        return StreamEx.of((Collection)EntryPointsManagerBase.DEAD_CODE_EP_NAME.getExtensionList()).select(EntryPointWithVisibilityLevel.class).anyMatch(point -> point.keepVisibilityLevel(this.isEntryPointEnabled((EntryPointWithVisibilityLevel)((Object)point)), refElement));
    }

    private static CommonProblemDescriptor @NotNull [] createDescriptions(RefElement refElement, String access, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        PsiElement element;
        PsiElement nameIdentifier;
        if (manager == null) {
            VisibilityInspection.$$$reportNull$$$0(7);
        }
        if (globalContext == null) {
            VisibilityInspection.$$$reportNull$$$0(8);
        }
        PsiElement psiElement = nameIdentifier = (element = refElement.getPsiElement()) != null ? IdentifierUtil.getNameIdentifier((PsiElement)element) : null;
        if (nameIdentifier != null) {
            String message2;
            String quickFixName = "Make " + ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE) + " ";
            if (access.equals("private")) {
                message2 = VisibilityInspection.getCanBePrivate();
                quickFixName = quickFixName + VisibilityUtil.toPresentableText((String)"private");
            } else if (access.equals("packageLocal")) {
                message2 = VisibilityInspection.getCanBePackageLocal();
                quickFixName = quickFixName + VisibilityUtil.toPresentableText((String)"packageLocal");
            } else {
                message2 = VisibilityInspection.getCanBeProtected();
                quickFixName = quickFixName + VisibilityUtil.toPresentableText((String)"protected");
            }
            ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[]{manager.createProblemDescriptor(nameIdentifier, message2, (LocalQuickFix)new AcceptSuggestedAccess(globalContext.getRefManager(), access, quickFixName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
            if (problemDescriptorArray == null) {
                VisibilityInspection.$$$reportNull$$$0(9);
            }
            return problemDescriptorArray;
        }
        if (CommonProblemDescriptor.EMPTY_ARRAY == null) {
            VisibilityInspection.$$$reportNull$$$0(10);
        }
        return CommonProblemDescriptor.EMPTY_ARRAY;
    }

    @EntryPointWithVisibilityLevel.VisibilityLevelResult
    int getMinVisibilityLevel(@NotNull PsiMember member) {
        if (member == null) {
            VisibilityInspection.$$$reportNull$$$0(11);
        }
        return ((StreamEx)StreamEx.of((Object[])EntryPointsManagerBase.DEAD_CODE_EP_NAME.getExtensions()).select(EntryPointWithVisibilityLevel.class).filter(point -> this.isEntryPointEnabled((EntryPointWithVisibilityLevel)((Object)point)))).mapToInt(point -> point.getMinVisibilityLevel(member)).max().orElse(-1);
    }

    private boolean isEntryPointEnabled(EntryPointWithVisibilityLevel point) {
        return this.myExtensions.getOrDefault(point.getId(), true);
    }

    @EntryPointWithVisibilityLevel.VisibilityLevelResult
    private int getMinVisibilityLevel(@NotNull RefJavaElement refElement) {
        PsiElement element;
        if (refElement == null) {
            VisibilityInspection.$$$reportNull$$$0(12);
        }
        if ((element = refElement.getPsiElement()) instanceof PsiMember) {
            return this.getMinVisibilityLevel((PsiMember)element);
        }
        return -1;
    }

    @NotNull
    @PsiModifier.ModifierConstant
    private String getPossibleAccess(@NotNull RefJavaElement refElement, int minLevel) {
        String weakerAccess;
        if (refElement == null) {
            VisibilityInspection.$$$reportNull$$$0(13);
        }
        String curAccess = refElement.getAccessModifier();
        String weakestAccess = PsiUtil.getAccessModifier((int)minLevel);
        if (VisibilityInspection.isTopLevelClass((RefElement)refElement) || VisibilityInspection.isCalledOnSubClasses((RefElement)refElement)) {
            weakestAccess = "packageLocal";
        }
        if (VisibilityInspection.isAbstractMethod((RefElement)refElement)) {
            weakestAccess = "protected";
        }
        if (curAccess == weakestAccess) {
            String string = curAccess;
            if (string == null) {
                VisibilityInspection.$$$reportNull$$$0(14);
            }
            return string;
        }
        while ((weakerAccess = this.getWeakerAccess(curAccess, (RefElement)refElement)) != null && RefJavaUtil.getInstance().compareAccess(weakerAccess, weakestAccess) >= 0 && this.isAccessible(refElement, weakerAccess)) {
            curAccess = weakerAccess;
        }
        String string = curAccess;
        if (string == null) {
            VisibilityInspection.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static boolean isCalledOnSubClasses(RefElement refElement) {
        return refElement instanceof RefMethod && ((RefMethod)refElement).isCalledOnSubClass();
    }

    private static boolean isAbstractMethod(RefElement refElement) {
        return refElement instanceof RefMethod && ((RefMethod)refElement).isAbstract();
    }

    private static boolean isTopLevelClass(RefElement refElement) {
        return refElement instanceof RefClass && RefJavaUtil.getInstance().getTopLevelClass(refElement) == refElement;
    }

    @Nullable
    @PsiModifier.ModifierConstant
    private String getWeakerAccess(@PsiModifier.ModifierConstant String curAccess, RefElement refElement) {
        if (curAccess == "public") {
            return VisibilityInspection.isTopLevelClass(refElement) ? "packageLocal" : "protected";
        }
        if (curAccess == "protected") {
            return this.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS ? "packageLocal" : "private";
        }
        if (curAccess == "packageLocal") {
            return "private";
        }
        return null;
    }

    private boolean isAccessible(@NotNull RefJavaElement to, @NotNull @PsiModifier.ModifierConstant String accessModifier) {
        if (to == null) {
            VisibilityInspection.$$$reportNull$$$0(16);
        }
        if (accessModifier == null) {
            VisibilityInspection.$$$reportNull$$$0(17);
        }
        for (Object refElement : to.getInReferences()) {
            if (this.isAccessibleFrom((RefElement)refElement, to, accessModifier)) continue;
            return false;
        }
        if (to instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)to;
            if (refMethod.isAbstract() && (refMethod.getDerivedMethods().isEmpty() || refMethod.getAccessModifier() == "private")) {
                return false;
            }
            for (RefMethod refOverride : refMethod.getDerivedMethods()) {
                if (accessModifier == "private") {
                    return false;
                }
                if (this.isAccessibleFrom((RefElement)refOverride, to, accessModifier)) continue;
                return false;
            }
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                if (RefJavaUtil.getInstance().compareAccess(refSuper.getAccessModifier(), accessModifier) <= 0) continue;
                return false;
            }
        }
        if (to instanceof RefClass) {
            RefClass refClass = (RefClass)to;
            for (Object subClass : refClass.getSubClasses()) {
                if (this.isAccessibleFrom((RefElement)subClass, to, accessModifier)) continue;
                return false;
            }
            List children = refClass.getChildren();
            for (RefEntity refElement : children) {
                if (this.isAccessible((RefJavaElement)refElement, accessModifier)) continue;
                return false;
            }
            for (RefEntity refElement : refClass.getInTypeReferences()) {
                if (this.isAccessibleFrom((RefElement)refElement, (RefJavaElement)refClass, accessModifier)) continue;
                return false;
            }
            List<RefJavaElement> classExporters = ((RefClassImpl)refClass).getClassExporters();
            if (classExporters != null) {
                for (RefJavaElement refExporter : classExporters) {
                    if (VisibilityInspection.getAccessLevel(accessModifier) >= VisibilityInspection.getAccessLevel(refExporter.getAccessModifier())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static int getAccessLevel(@PsiModifier.ModifierConstant String access) {
        if (access == "private") {
            return 1;
        }
        if (access == "packageLocal") {
            return 2;
        }
        if (access == "protected") {
            return 3;
        }
        return 4;
    }

    private boolean isAccessibleFrom(RefElement from, RefJavaElement to, String accessModifier) {
        if (accessModifier == "public") {
            return true;
        }
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        if (accessModifier == "packageLocal") {
            return RefJavaUtil.getPackage((RefEntity)from) == RefJavaUtil.getPackage((RefEntity)to);
        }
        RefClass fromTopLevel = refUtil.getTopLevelClass(from);
        RefClass toTopLevel = refUtil.getTopLevelClass((RefElement)to);
        RefClass fromOwner = refUtil.getOwnerClass(from);
        RefClass toOwner = refUtil.getOwnerClass((RefElement)to);
        if (accessModifier == "protected") {
            if (to instanceof RefJavaElementImpl && ((RefJavaElementImpl)to).isProtectedAccessForbidden()) {
                return false;
            }
            return fromTopLevel != null && refUtil.isInheritor(fromTopLevel, toOwner) || fromOwner != null && refUtil.isInheritor(fromOwner, toTopLevel) || toTopLevel != null && toTopLevel == fromTopLevel;
        }
        if (accessModifier == "private") {
            if (this.SUGGEST_PRIVATE_FOR_INNERS) {
                PsiClass fromTopLevelElement;
                PsiClass psiClass = fromTopLevelElement = fromTopLevel != null ? (PsiClass)fromTopLevel.getPsiElement() : null;
                if (fromTopLevelElement != null && VisibilityInspection.isInExtendsList(to, fromTopLevelElement.getExtendsList())) {
                    return false;
                }
                if (fromTopLevelElement != null && VisibilityInspection.isInExtendsList(to, fromTopLevelElement.getImplementsList())) {
                    return false;
                }
                if (fromTopLevelElement != null && VisibilityInspection.isInAnnotations(to, fromTopLevelElement)) {
                    return false;
                }
                return fromTopLevel == toOwner || fromOwner == toTopLevel || toOwner != null && (refUtil.getOwnerClass((RefElement)toOwner) == from || from instanceof RefMethod && toOwner == ((RefMethod)from).getOwnerClass() || from instanceof RefField && toOwner == ((RefField)from).getOwnerClass());
            }
            if (fromOwner != null && fromOwner.isStatic() && !to.isStatic() && refUtil.isInheritor(fromOwner, toOwner)) {
                return false;
            }
            if (fromTopLevel == toOwner) {
                if (from instanceof RefClass && to instanceof RefClass) {
                    PsiClass fromClass = ((RefClass)from).getUastElement().getJavaPsi();
                    if (VisibilityInspection.isInExtendsList(to, fromClass.getExtendsList())) {
                        return false;
                    }
                    if (VisibilityInspection.isInExtendsList(to, fromClass.getImplementsList())) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isInAnnotations(RefJavaElement to, @NotNull PsiClass fromTopLevelElement) {
        PsiModifierList modifierList;
        if (fromTopLevelElement == null) {
            VisibilityInspection.$$$reportNull$$$0(18);
        }
        if ((modifierList = fromTopLevelElement.getModifierList()) == null) {
            return false;
        }
        final PsiElement toElement = to.getPsiElement();
        final boolean[] resolved = new boolean[]{false};
        modifierList.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (resolved[0]) {
                    return;
                }
                super.visitReferenceExpression(expression2);
                if (expression2.resolve() == toElement) {
                    resolved[0] = true;
                }
            }
        });
        return resolved[0];
    }

    private static boolean isInExtendsList(RefJavaElement to, PsiReferenceList extendsList) {
        if (extendsList != null) {
            PsiJavaCodeReferenceElement[] referenceElements;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                PsiReferenceParameterList parameterList = referenceElement.getParameterList();
                if (parameterList == null) continue;
                for (PsiType type2 : parameterList.getTypeArguments()) {
                    if (!extendsList.getManager().areElementsEquivalent((PsiElement)PsiUtil.resolveClassInType((PsiType)type2), to.getPsiElement())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean queryExternalUsagesRequests(final @NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        if (manager == null) {
            VisibilityInspection.$$$reportNull$$$0(19);
        }
        if (globalContext == null) {
            VisibilityInspection.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            VisibilityInspection.$$$reportNull$$$0(21);
        }
        final EntryPointsManager entryPointsManager = globalContext.getEntryPointsManager(manager);
        for (RefElement entryPoint : entryPointsManager.getEntryPoints(manager)) {
            if (((Boolean)ReadAction.nonBlocking(() -> entryPoint instanceof RefJavaElement && this.getMinVisibilityLevel((RefJavaElement)entryPoint) > 0).executeSynchronously()).booleanValue()) continue;
            VisibilityInspection.ignoreElement(processor, (RefEntity)entryPoint);
        }
        for (VisibilityExtension addin : EP_NAME.getExtensionList()) {
            addin.fillIgnoreList(manager, processor);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(refEntity instanceof RefElement)) {
                    return;
                }
                if (processor.getDescriptions(refEntity) == null) {
                    return;
                }
                refEntity.accept((RefVisitor)new RefJavaVisitor(){

                    public void visitField(@NotNull RefField refField) {
                        if (refField == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (refField.getAccessModifier() != "private") {
                            globalContext.enqueueFieldUsagesProcessor(refField, psiReference -> {
                                VisibilityInspection.ignoreElement(processor, (RefEntity)refField);
                                return false;
                            });
                        }
                    }

                    public void visitMethod(@NotNull RefMethod refMethod) {
                        if (refMethod == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (!refMethod.isExternalOverride() && refMethod.getAccessModifier() != "private" && !(refMethod instanceof RefImplicitConstructor)) {
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, derivedMethod -> {
                                VisibilityInspection.ignoreElement(processor, (RefEntity)refMethod);
                                return false;
                            });
                            globalContext.enqueueMethodUsagesProcessor(refMethod, psiReference -> {
                                VisibilityInspection.ignoreElement(processor, (RefEntity)refMethod);
                                return false;
                            });
                        }
                    }

                    public void visitClass(@NotNull RefClass refClass) {
                        if (refClass == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (!refClass.isAnonymous()) {
                            globalContext.enqueueDerivedClassesProcessor(refClass, inheritor -> {
                                VisibilityInspection.ignoreElement(processor, (RefEntity)refClass);
                                return false;
                            });
                            globalContext.enqueueClassUsagesProcessor(refClass, psiReference -> {
                                VisibilityInspection.ignoreElement(processor, (RefEntity)refClass);
                                return false;
                            });
                            RefMethod defaultConstructor = refClass.getDefaultConstructor();
                            if (entryPointsManager.isAddNonJavaEntries() && defaultConstructor != null) {
                                String qualifiedName;
                                PsiClass psiClass = (PsiClass)ObjectUtils.tryCast((Object)refClass.getPsiElement(), PsiClass.class);
                                String string = qualifiedName = psiClass != null ? psiClass.getQualifiedName() : null;
                                if (qualifiedName != null) {
                                    Project project = manager.getProject();
                                    PsiSearchHelper.getInstance((Project)project).processUsagesInNonJavaFiles(qualifiedName, (file, startOffset, endOffset) -> {
                                        entryPointsManager.addEntryPoint((RefElement)defaultConstructor, false);
                                        VisibilityInspection.ignoreElement(processor, (RefEntity)defaultConstructor);
                                        return false;
                                    }, GlobalSearchScope.projectScope((Project)project));
                                }
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "refField";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "refMethod";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "refClass";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/codeInspection/visibility/VisibilityInspection$2$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitField";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitMethod";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitClass";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/visibility/VisibilityInspection$2", "visitElement"));
            }
        });
        return false;
    }

    private static void ignoreElement(@NotNull ProblemDescriptionsProcessor processor, @NotNull RefEntity refElement) {
        RefClass refClass;
        RefMethod defaultConstructor;
        if (processor == null) {
            VisibilityInspection.$$$reportNull$$$0(22);
        }
        if (refElement == null) {
            VisibilityInspection.$$$reportNull$$$0(23);
        }
        processor.ignoreElement(refElement);
        if (refElement instanceof RefClass && (defaultConstructor = (refClass = (RefClass)refElement).getDefaultConstructor()) != null) {
            processor.ignoreElement((RefEntity)defaultConstructor);
            return;
        }
        RefEntity owner2 = refElement.getOwner();
        if (owner2 instanceof RefElement) {
            processor.ignoreElement(owner2);
        }
    }

    public void compose(@NotNull StringBuilder buf, @NotNull RefEntity refEntity, @NotNull HTMLComposer composer) {
        if (buf == null) {
            VisibilityInspection.$$$reportNull$$$0(24);
        }
        if (refEntity == null) {
            VisibilityInspection.$$$reportNull$$$0(25);
        }
        if (composer == null) {
            VisibilityInspection.$$$reportNull$$$0(26);
        }
        composer.appendElementInReferences(buf, (RefElement)refEntity);
    }

    @NotNull
    public QuickFix<?> getQuickFix(String hint) {
        return new AcceptSuggestedAccess(null, hint, null);
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix2) {
        if (fix2 == null) {
            VisibilityInspection.$$$reportNull$$$0(27);
        }
        return ((AcceptSuggestedAccess)fix2).myHint;
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            VisibilityInspection.$$$reportNull$$$0(28);
        }
        super.writeSettings(node);
        for (Map.Entry<String, Boolean> entry : this.myExtensions.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            node.addContent(new Element("disabledExtension").setAttribute("id", entry.getKey()));
        }
        for (Element child : node.getChildren()) {
            if (!"SUGGEST_FOR_CONSTANTS".equals(child.getAttributeValue("name")) || !"true".equals(child.getAttributeValue("value"))) continue;
            node.removeContent((Content)child);
            break;
        }
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            VisibilityInspection.$$$reportNull$$$0(29);
        }
        super.readSettings(node);
        for (Element extension : node.getChildren("disabledExtension")) {
            String id = extension.getAttributeValue("id");
            if (id == null) continue;
            this.myExtensions.put(id, false);
        }
    }

    public void setEntryPointEnabled(@NotNull String entryPointId, boolean enabled) {
        if (entryPointId == null) {
            VisibilityInspection.$$$reportNull$$$0(30);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
        this.myExtensions.put(entryPointId, enabled);
    }

    private static String getCanBePrivate() {
        return JavaAnalysisBundle.message((String)"inspection.visibility.compose.suggestion", (Object[])new Object[]{VisibilityUtil.toPresentableText((String)"private")});
    }

    private static String getCanBePackageLocal() {
        return JavaAnalysisBundle.message((String)"inspection.visibility.compose.suggestion", (Object[])new Object[]{VisibilityUtil.toPresentableText((String)"packageLocal")});
    }

    private static String getCanBeProtected() {
        return JavaAnalysisBundle.message((String)"inspection.visibility.compose.suggestion", (Object[])new Object[]{VisibilityUtil.toPresentableText((String)"protected")});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/visibility/VisibilityInspection";
                break;
            }
            case 1: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 5: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessModifier";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromTopLevelElement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composer";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPointId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/visibility/VisibilityInspection";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptions";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleAccess";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "keepVisibilityLevel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMinVisibilityLevel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleAccess";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isInAnnotations";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "ignoreElement";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "compose";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setEntryPointEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AcceptSuggestedAccess
    implements LocalQuickFix {
        private final RefManager myManager;
        @PsiModifier.ModifierConstant
        private final String myHint;
        private final String myName;

        private AcceptSuggestedAccess(RefManager manager, @PsiModifier.ModifierConstant String hint, String name2) {
            this.myManager = manager;
            this.myHint = hint;
            this.myName = name2;
        }

        @NotNull
        public String getName() {
            String string = this.myName != null ? this.myName : this.getFamilyName();
            if (string == null) {
                AcceptSuggestedAccess.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.visibility.accept.quickfix", (Object[])new Object[0]);
            if (string == null) {
                AcceptSuggestedAccess.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiModifierListOwner element;
            if (project == null) {
                AcceptSuggestedAccess.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AcceptSuggestedAccess.$$$reportNull$$$0(3);
            }
            if ((element = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiModifierListOwner.class)) != null) {
                PsiMethod psiMethod;
                PsiClass containingClass;
                RefElement refElement = null;
                if (this.myManager != null) {
                    refElement = this.myManager.getReference((PsiElement)element);
                }
                if (element instanceof PsiVariable) {
                    ((PsiVariable)element).normalizeDeclaration();
                }
                PsiModifierList list = element.getModifierList();
                LOG.assertTrue(list != null);
                if (element instanceof PsiMethod && (containingClass = (psiMethod = (PsiMethod)element).getContainingClass()) != null && containingClass.getParent() instanceof PsiFile && this.myHint == "private" && list.hasModifierProperty("final")) {
                    list.setModifierProperty("final", false);
                }
                list.setModifierProperty(this.myHint, true);
                if (refElement instanceof RefJavaElement) {
                    RefJavaUtil.getInstance().setAccessModifier((RefJavaElement)refElement, this.myHint);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/visibility/VisibilityInspection$AcceptSuggestedAccess";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/visibility/VisibilityInspection$AcceptSuggestedAccess";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myPackageLocalForMembersCheckbox;
        private final JCheckBox myPrivateForInnersCheckbox;
        private final JCheckBox myPackageLocalForTopClassesCheckbox;
        private final JCheckBox mySuggestForConstantsCheckbox;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.anchor = 18;
            this.myPackageLocalForMembersCheckbox = new JCheckBox(JavaAnalysisBundle.message((String)"inspection.visibility.option.package.private.members", (Object[])new Object[0]));
            this.myPackageLocalForMembersCheckbox.setSelected(VisibilityInspection.this.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS);
            this.myPackageLocalForMembersCheckbox.getModel().addItemListener(e -> {
                VisibilityInspection.this.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS = this.myPackageLocalForMembersCheckbox.isSelected();
            });
            gc.gridy = 0;
            this.add((Component)this.myPackageLocalForMembersCheckbox, gc);
            this.myPackageLocalForTopClassesCheckbox = new JCheckBox(JavaAnalysisBundle.message((String)"inspection.visibility.package.private.top.level.classes", (Object[])new Object[0]));
            this.myPackageLocalForTopClassesCheckbox.setSelected(VisibilityInspection.this.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES);
            this.myPackageLocalForTopClassesCheckbox.getModel().addItemListener(e -> {
                VisibilityInspection.this.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES = this.myPackageLocalForTopClassesCheckbox.isSelected();
            });
            ++gc.gridy;
            this.add((Component)this.myPackageLocalForTopClassesCheckbox, gc);
            this.myPrivateForInnersCheckbox = new JCheckBox(JavaAnalysisBundle.message((String)"inspection.visibility.private.inner.members", (Object[])new Object[0]));
            this.myPrivateForInnersCheckbox.setSelected(VisibilityInspection.this.SUGGEST_PRIVATE_FOR_INNERS);
            this.myPrivateForInnersCheckbox.getModel().addItemListener(e -> {
                VisibilityInspection.this.SUGGEST_PRIVATE_FOR_INNERS = this.myPrivateForInnersCheckbox.isSelected();
            });
            ++gc.gridy;
            this.add((Component)this.myPrivateForInnersCheckbox, gc);
            this.mySuggestForConstantsCheckbox = new JCheckBox(JavaAnalysisBundle.message((String)"inspection.visibility.option.constants", (Object[])new Object[0]));
            this.mySuggestForConstantsCheckbox.setSelected(VisibilityInspection.this.SUGGEST_FOR_CONSTANTS);
            this.mySuggestForConstantsCheckbox.getModel().addItemListener(e -> {
                VisibilityInspection.this.SUGGEST_FOR_CONSTANTS = this.mySuggestForConstantsCheckbox.isSelected();
            });
            ++gc.gridy;
            this.add((Component)this.mySuggestForConstantsCheckbox, gc);
            for (EntryPoint entryPoint : (EntryPoint[])EntryPointsManagerBase.DEAD_CODE_EP_NAME.getExtensions()) {
                if (!(entryPoint instanceof EntryPointWithVisibilityLevel)) continue;
                ++gc.gridy;
                JCheckBox checkBox = new JCheckBox(((EntryPointWithVisibilityLevel)entryPoint).getTitle());
                checkBox.setSelected(VisibilityInspection.this.isEntryPointEnabled((EntryPointWithVisibilityLevel)entryPoint));
                checkBox.addActionListener(e -> VisibilityInspection.this.myExtensions.put(((EntryPointWithVisibilityLevel)entryPoint).getId(), checkBox.isSelected()));
                this.add((Component)checkBox, gc);
            }
            ++gc.gridy;
            gc.weighty = 1.0;
            this.add((Component)new VerticalBox(), gc);
        }
    }
}

