/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.suspiciousNameCombination;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.AddEditDeleteListPanel;
import com.intellij.ui.IdeBorderFactory;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.ui.UiUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class SuspiciousNameCombinationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    private static final String ELEMENT_GROUPS = "group";
    @NonNls
    private static final String ATTRIBUTE_NAMES = "names";
    @NonNls
    private static final String ELEMENT_IGNORED_METHODS = "ignored";
    protected final List<String> myNameGroups = new ArrayList<String>();
    final MethodMatcher myIgnoredMethods = new MethodMatcher().add("java.io.PrintStream", "println").add("java.io.PrintWriter", "println").add("java.lang.System", "identityHashCode").add("java.sql.PreparedStatement", "set.*").add("java.sql.ResultSet", "update.*").add("java.sql.SQLOutput", "write.*").add("java.lang.Integer", "compare.*").add("java.lang.Long", "compare.*").add("java.lang.Short", "compare").add("java.lang.Byte", "compare").add("java.lang.Character", "compare").add("java.lang.Boolean", "compare").add("java.lang.Math", ".*").add("java.lang.StrictMath", ".*");
    private final Map<String, String> myWordToGroupMap = new HashMap<String, String>();
    private int myLongestWord = 0;

    public SuspiciousNameCombinationInspection() {
        this.addNameGroup("x,width,left,right");
        this.addNameGroup("y,height,top,bottom");
    }

    @Nullable
    public JComponent createOptionsPanel() {
        NameGroupsPanel nameGroupsPanel = new NameGroupsPanel();
        ListTable table = new ListTable(new ListWrappingTableModel(Arrays.asList(this.myIgnoredMethods.getClassNames(), this.myIgnoredMethods.getMethodNamePatterns()), new String[]{InspectionGadgetsBundle.message("result.of.method.call.ignored.class.column.title", new Object[0]), InspectionGadgetsBundle.message("result.of.method.call.ignored.method.column.title", new Object[0])}));
        JPanel tablePanel = UiUtils.createAddRemoveTreeClassChooserPanel(table, InspectionGadgetsBundle.message("choose.class", new Object[0]), new String[0]);
        JPanel panel2 = new JPanel(new GridLayout(2, 1));
        panel2.add((Component)((Object)nameGroupsPanel));
        tablePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JavaBundle.message((String)"section.title.inspection.suspicious.names.ignore.methods", (Object[])new Object[0]), (boolean)false));
        panel2.add(tablePanel);
        return panel2;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    protected void clearNameGroups() {
        this.myNameGroups.clear();
        this.myWordToGroupMap.clear();
        this.myLongestWord = 0;
    }

    public void addNameGroup(@NonNls String group) {
        this.myNameGroups.add(group);
        List words = StringUtil.split((String)group, (String)",");
        for (String word : words) {
            String canonicalized = SuspiciousNameCombinationInspection.canonicalize(word);
            this.myLongestWord = Math.max(this.myLongestWord, canonicalized.length());
            this.myWordToGroupMap.put(canonicalized, group);
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.probable.bugs", (Object[])new Object[0]);
        if (string == null) {
            SuspiciousNameCombinationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "SuspiciousNameCombination";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousNameCombinationInspection.$$$reportNull$$$0(1);
        }
        return new MyVisitor(holder);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            SuspiciousNameCombinationInspection.$$$reportNull$$$0(2);
        }
        this.clearNameGroups();
        for (Object o : node.getChildren(ELEMENT_GROUPS)) {
            Element e = (Element)o;
            this.addNameGroup(e.getAttributeValue(ATTRIBUTE_NAMES));
        }
        Element ignoredMethods = node.getChild(ELEMENT_IGNORED_METHODS);
        if (ignoredMethods != null) {
            this.myIgnoredMethods.readSettings(ignoredMethods);
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            SuspiciousNameCombinationInspection.$$$reportNull$$$0(3);
        }
        for (String group : this.myNameGroups) {
            Element e = new Element(ELEMENT_GROUPS);
            node.addContent(e);
            e.setAttribute(ATTRIBUTE_NAMES, group);
        }
        Element ignoredMethods = new Element(ELEMENT_IGNORED_METHODS);
        node.addContent(ignoredMethods);
        this.myIgnoredMethods.writeSettings(ignoredMethods);
    }

    @NotNull
    private static String canonicalize(String word) {
        String string = StringUtil.toLowerCase((String)word.trim());
        if (string == null) {
            SuspiciousNameCombinationInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalize";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myProblemsHolder;

        MyVisitor(ProblemsHolder problemsHolder) {
            this.myProblemsHolder = problemsHolder;
        }

        public void visitVariable(PsiVariable variable) {
            PsiExpression expr2;
            if (variable.hasInitializer() && (expr2 = variable.getInitializer()) instanceof PsiReferenceExpression) {
                PsiReferenceExpression refExpr = (PsiReferenceExpression)expr2;
                PsiIdentifier nameIdentifier = variable.getNameIdentifier();
                this.checkCombination((PsiElement)(nameIdentifier != null ? nameIdentifier : variable), variable.getName(), refExpr.getReferenceName(), "suspicious.name.assignment");
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            PsiExpression lhs = expression2.getLExpression();
            PsiExpression rhs = expression2.getRExpression();
            if (lhs instanceof PsiReferenceExpression && rhs instanceof PsiReferenceExpression) {
                PsiReferenceExpression lhsExpr = (PsiReferenceExpression)lhs;
                PsiReferenceExpression rhsExpr = (PsiReferenceExpression)rhs;
                this.checkCombination((PsiElement)lhsExpr, lhsExpr.getReferenceName(), rhsExpr.getReferenceName(), "suspicious.name.assignment");
            }
        }

        public void visitCallExpression(PsiCallExpression expression2) {
            PsiMethod psiMethod = expression2.resolveMethod();
            if (SuspiciousNameCombinationInspection.this.myIgnoredMethods.matches(psiMethod)) {
                return;
            }
            PsiExpressionList argList = expression2.getArgumentList();
            if (psiMethod != null && argList != null) {
                PsiExpression[] args = argList.getExpressions();
                PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
                for (int i = 0; i < parameters2.length && i < args.length; ++i) {
                    String refName;
                    if (!(args[i] instanceof PsiReferenceExpression) || this.findNameGroup(refName = ((PsiReferenceExpression)args[i]).getReferenceName()) == null) continue;
                    this.checkCombination((PsiElement)args[i], parameters2[i].getName(), refName, "suspicious.name.parameter");
                }
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiExpression returnValue = statement.getReturnValue();
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)returnValue, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            if (returnValue instanceof PsiReferenceExpression && containingMethod != null) {
                String refName = ((PsiReferenceExpression)returnValue).getReferenceName();
                this.checkCombination((PsiElement)returnValue, containingMethod.getName(), refName, "suspicious.name.return");
            }
        }

        private void checkCombination(PsiElement location, @Nullable String name2, @Nullable String referenceName, @PropertyKey(resourceBundle="messages.JavaErrorBundle") String key2) {
            String nameGroup1 = this.findNameGroup(name2);
            String nameGroup2 = this.findNameGroup(referenceName);
            if (nameGroup1 != null && nameGroup2 != null && !nameGroup1.equals(nameGroup2)) {
                this.myProblemsHolder.registerProblem(location, JavaErrorBundle.message(key2, referenceName, name2), new LocalQuickFix[0]);
            }
        }

        @Nullable
        private String findNameGroup(@Nullable String name2) {
            if (name2 == null) {
                return null;
            }
            String[] words = NameUtil.splitNameIntoWords((String)name2);
            Arrays.asList(words).replaceAll(x$0 -> SuspiciousNameCombinationInspection.canonicalize(x$0));
            String result = null;
            for (int i = 0; i < words.length; ++i) {
                String word = "";
                for (int j = i; j < words.length && (word = word + words[j]).length() <= SuspiciousNameCombinationInspection.this.myLongestWord; ++j) {
                    String group = (String)SuspiciousNameCombinationInspection.this.myWordToGroupMap.get(word);
                    if (group == null) continue;
                    if (result == null) {
                        result = group;
                        continue;
                    }
                    if (result.equals(group)) continue;
                    return null;
                }
            }
            return result;
        }
    }

    private class NameGroupsPanel
    extends AddEditDeleteListPanel<String> {
        NameGroupsPanel() {
            super(AnalysisBundle.message((String)"suspicious.name.combination.options.title", (Object[])new Object[0]), SuspiciousNameCombinationInspection.this.myNameGroups);
            this.myListModel.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    NameGroupsPanel.this.saveChanges();
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    NameGroupsPanel.this.saveChanges();
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    NameGroupsPanel.this.saveChanges();
                }
            });
        }

        protected String findItemToAdd() {
            return Messages.showInputDialog((Component)((Object)this), (String)AnalysisBundle.message((String)"suspicious.name.combination.options.prompt", (Object[])new Object[0]), (String)AnalysisBundle.message((String)"suspicious.name.combination.add.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", null);
        }

        protected String editSelectedItem(String inputValue) {
            return Messages.showInputDialog((Component)((Object)this), (String)AnalysisBundle.message((String)"suspicious.name.combination.options.prompt", (Object[])new Object[0]), (String)AnalysisBundle.message((String)"suspicious.name.combination.edit.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)inputValue, null);
        }

        private void saveChanges() {
            SuspiciousNameCombinationInspection.this.clearNameGroups();
            for (int i = 0; i < this.myListModel.getSize(); ++i) {
                SuspiciousNameCombinationInspection.this.addNameGroup((String)this.myListModel.getElementAt(i));
            }
        }
    }
}

