/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.redundantCast;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.codeInspection.miscGenerics.SuspiciousMethodCallUtil;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantCastInspection
extends GenericsInspectionToolBase {
    private final LocalQuickFix myQuickFixAction = new AcceptSuggested();
    @NonNls
    private static final String SHORT_NAME = "RedundantCast";
    public boolean IGNORE_SUSPICIOUS_METHOD_CALLS;

    @Override
    public ProblemDescriptor @Nullable [] getDescriptions(@NotNull PsiElement where, @NotNull InspectionManager manager, boolean isOnTheFly) {
        List<PsiTypeCastExpression> redundantCasts;
        if (where == null) {
            RedundantCastInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            RedundantCastInspection.$$$reportNull$$$0(1);
        }
        if ((redundantCasts = RedundantCastUtil.getRedundantCastsInside(where)).isEmpty()) {
            return null;
        }
        ArrayList<ProblemDescriptor> descriptions = new ArrayList<ProblemDescriptor>(redundantCasts.size());
        for (PsiTypeCastExpression redundantCast : redundantCasts) {
            ProblemDescriptor descriptor = this.createDescription(redundantCast, manager, isOnTheFly);
            if (descriptor == null) continue;
            descriptions.add(descriptor);
        }
        if (descriptions.isEmpty()) {
            return null;
        }
        return descriptions.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Override
    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            RedundantCastInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            RedundantCastInspection.$$$reportNull$$$0(3);
        }
        return this.getDescriptions((PsiElement)field, manager, isOnTheFly);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            RedundantCastInspection.$$$reportNull$$$0(4);
        }
        if (this.IGNORE_SUSPICIOUS_METHOD_CALLS) {
            super.writeSettings(node);
        }
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JavaAnalysisBundle.message((String)"ignore.casts.in.suspicious.collections.method.calls", (Object[])new Object[0]), "IGNORE_SUSPICIOUS_METHOD_CALLS");
        return optionsPanel;
    }

    @Nullable
    private ProblemDescriptor createDescription(@NotNull PsiTypeCastExpression cast, @NotNull InspectionManager manager, boolean onTheFly) {
        String message2;
        PsiElement gParent;
        if (cast == null) {
            RedundantCastInspection.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            RedundantCastInspection.$$$reportNull$$$0(6);
        }
        PsiExpression operand2 = cast.getOperand();
        PsiTypeElement castType = cast.getCastType();
        if (operand2 == null || castType == null) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)cast.getParent());
        if (parent instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiMethodCallExpression && this.IGNORE_SUSPICIOUS_METHOD_CALLS && (message2 = SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage((PsiMethodCallExpression)gParent, operand2, operand2.getType(), true, new ArrayList<SuspiciousMethodCallUtil.PatternMethod>(), 0)) != null) {
            return null;
        }
        String message3 = JavaAnalysisBundle.message((String)"inspection.redundant.cast.problem.descriptor", (Object[])new Object[]{"<code>" + PsiExpressionTrimRenderer.render((PsiExpression)operand2) + "</code>", "<code>#ref</code> #loc"});
        return manager.createProblemDescriptor((PsiElement)castType, message3, this.myQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, onTheFly);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.verbose.or.redundant.code.constructs", (Object[])new Object[0]);
        if (string == null) {
            RedundantCastInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cast";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDescription";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AcceptSuggested
    implements LocalQuickFix {
        private AcceptSuggested() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.redundant.cast.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                AcceptSuggested.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement castTypeElement;
            PsiTypeCastExpression cast;
            if (project == null) {
                AcceptSuggested.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AcceptSuggested.$$$reportNull$$$0(2);
            }
            PsiTypeCastExpression psiTypeCastExpression = cast = (castTypeElement = descriptor.getPsiElement()) == null ? null : (PsiTypeCastExpression)castTypeElement.getParent();
            if (cast != null) {
                RemoveRedundantCastUtil.removeCast(cast);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection$AcceptSuggested";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection$AcceptSuggested";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

