/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.optionalToIf.Operation;
import com.intellij.codeInspection.optionalToIf.OptionalToIfContext;
import com.intellij.codeInspection.optionalToIf.OptionalToIfInspection;
import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class IntermediateOperation
implements Operation {
    IntermediateOperation() {
    }

    @Nullable
    static IntermediateOperation create(@NotNull String name2, PsiExpression @NotNull [] args) {
        if (name2 == null) {
            IntermediateOperation.$$$reportNull$$$0(0);
        }
        if (args == null) {
            IntermediateOperation.$$$reportNull$$$0(1);
        }
        if (args.length != 1) {
            return null;
        }
        if (name2.equals("map")) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new Map(fn);
        }
        if (name2.equals("filter")) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new Filter(fn);
        }
        if (name2.equals("or")) {
            FunctionHelper fn = FunctionHelper.create(args[0], 0);
            return fn == null ? null : Or.create(fn);
        }
        if (name2.equals("flatMap")) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : FlatMap.create(fn);
        }
        return null;
    }

    @Nullable
    private static List<OptionalToIfInspection.OperationRecord> extractRecords(@NotNull FunctionHelper fn) {
        PsiMethodCallExpression chainExpression;
        if (fn == null) {
            IntermediateOperation.$$$reportNull$$$0(2);
        }
        if ((chainExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)fn.getExpression(), PsiMethodCallExpression.class)) == null) {
            return null;
        }
        List<Operation> operations = OptionalToIfInspection.extractOperations(chainExpression, false);
        if (operations == null || operations.isEmpty()) {
            return null;
        }
        return OptionalToIfInspection.createRecords(operations);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fn";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/optionalToIf/IntermediateOperation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "extractRecords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class FlatMap
    extends IntermediateOperation {
        private final List<OptionalToIfInspection.OperationRecord> myRecords;
        private final String myVarName;
        private final FunctionHelper myFn;

        @Contract(pure=true)
        private FlatMap(List<OptionalToIfInspection.OperationRecord> records, String varName, FunctionHelper fn) {
            this.myRecords = records;
            this.myVarName = varName;
            this.myFn = fn;
        }

        @Override
        @NotNull
        public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
            ChainVariable outVar;
            if (inVar == null) {
                FlatMap.$$$reportNull$$$0(0);
            }
            ChainVariable chainVariable = this.myVarName.equals((outVar = this.myRecords.get((int)(this.myRecords.size() - 1)).myOutVar).getName()) ? inVar : outVar;
            if (chainVariable == null) {
                FlatMap.$$$reportNull$$$0(1);
            }
            return chainVariable;
        }

        @Nullable
        static FlatMap create(@NotNull FunctionHelper fn) {
            String varName;
            if (fn == null) {
                FlatMap.$$$reportNull$$$0(2);
            }
            if ((varName = fn.tryLightTransform()) == null) {
                return null;
            }
            List records = IntermediateOperation.extractRecords(fn);
            return records == null ? null : new FlatMap(records, varName, fn);
        }

        @Override
        @NotNull
        public StreamEx<OptionalToIfInspection.OperationRecord> nestedOperations() {
            StreamEx streamEx = StreamEx.of(this.myRecords).flatMap(or -> (StreamEx)StreamEx.of((Object)or).append(or.myOperation.nestedOperations()));
            if (streamEx == null) {
                FlatMap.$$$reportNull$$$0(3);
            }
            return streamEx;
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                FlatMap.$$$reportNull$$$0(4);
            }
            if (outVar == null) {
                FlatMap.$$$reportNull$$$0(5);
            }
            if (code == null) {
                FlatMap.$$$reportNull$$$0(6);
            }
            if (context == null) {
                FlatMap.$$$reportNull$$$0(7);
            }
            List records = (List)StreamEx.of(this.myRecords).map(r -> this.replaceFnVariable((OptionalToIfInspection.OperationRecord)r, inVar, context)).collect(Collectors.toList());
            return OptionalToIfInspection.wrapCode(context, records, code);
        }

        @NotNull
        @Contract(value="_, _, _ -> new")
        private OptionalToIfInspection.OperationRecord replaceFnVariable(@NotNull OptionalToIfInspection.OperationRecord record, @NotNull ChainVariable outerVar, @NotNull OptionalToIfContext context) {
            if (record == null) {
                FlatMap.$$$reportNull$$$0(8);
            }
            if (outerVar == null) {
                FlatMap.$$$reportNull$$$0(9);
            }
            if (context == null) {
                FlatMap.$$$reportNull$$$0(10);
            }
            ChainVariable inVar = this.replaceFnVariable(record.myInVar, outerVar);
            ChainVariable outVar = this.replaceFnVariable(record.myOutVar, outerVar);
            Operation operation = record.myOperation;
            operation.rename(this.myVarName, outerVar.getName(), context);
            return new OptionalToIfInspection.OperationRecord(inVar, outVar, operation);
        }

        private ChainVariable replaceFnVariable(@NotNull ChainVariable variable, @NotNull ChainVariable replacement) {
            if (variable == null) {
                FlatMap.$$$reportNull$$$0(11);
            }
            if (replacement == null) {
                FlatMap.$$$reportNull$$$0(12);
            }
            return this.myVarName.equals(variable.getName()) ? replacement : variable;
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull String newName, @NotNull OptionalToIfContext context) {
            if (oldName == null) {
                FlatMap.$$$reportNull$$$0(13);
            }
            if (newName == null) {
                FlatMap.$$$reportNull$$$0(14);
            }
            if (context == null) {
                FlatMap.$$$reportNull$$$0(15);
            }
            this.myRecords.forEach(r -> r.myOperation.rename(oldName, newName, context));
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            String name2;
            if (inVar == null) {
                FlatMap.$$$reportNull$$$0(16);
            }
            if (outVar == null) {
                FlatMap.$$$reportNull$$$0(17);
            }
            if (context == null) {
                FlatMap.$$$reportNull$$$0(18);
            }
            if ((name2 = this.myFn.getParameterName(0)) != null) {
                inVar.addBestNameCandidate(name2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inVar";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/optionalToIf/IntermediateOperation$FlatMap";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fn";
                    break;
                }
                case 5: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outVar";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 7: 
                case 10: 
                case 15: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "record";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outerVar";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/optionalToIf/IntermediateOperation$FlatMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutVar";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nestedOperations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getOutVar";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceFnVariable";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "rename";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "preprocessVariables";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class Or
    extends IntermediateOperation {
        private final List<OptionalToIfInspection.OperationRecord> myRecords;

        @Contract(pure=true)
        Or(List<OptionalToIfInspection.OperationRecord> records) {
            this.myRecords = records;
        }

        @Override
        @NotNull
        public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
            if (inVar == null) {
                Or.$$$reportNull$$$0(0);
            }
            return new ChainVariable(inVar.getType());
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull String newName, @NotNull OptionalToIfContext context) {
            if (oldName == null) {
                Or.$$$reportNull$$$0(1);
            }
            if (newName == null) {
                Or.$$$reportNull$$$0(2);
            }
            if (context == null) {
                Or.$$$reportNull$$$0(3);
            }
            this.myRecords.forEach(r -> r.myOperation.rename(oldName, newName, context));
        }

        @Override
        @NotNull
        public StreamEx<OptionalToIfInspection.OperationRecord> nestedOperations() {
            StreamEx streamEx = StreamEx.of(this.myRecords).flatMap(or -> (StreamEx)StreamEx.of((Object)or).append(or.myOperation.nestedOperations()));
            if (streamEx == null) {
                Or.$$$reportNull$$$0(4);
            }
            return streamEx;
        }

        @Nullable
        static Or create(@NotNull FunctionHelper fn) {
            List records;
            if (fn == null) {
                Or.$$$reportNull$$$0(5);
            }
            return (records = IntermediateOperation.extractRecords(fn)) == null ? null : new Or(records);
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                Or.$$$reportNull$$$0(6);
            }
            if (outVar == null) {
                Or.$$$reportNull$$$0(7);
            }
            if (code == null) {
                Or.$$$reportNull$$$0(8);
            }
            if (context == null) {
                Or.$$$reportNull$$$0(9);
            }
            String orResult = this.myRecords.get((int)(this.myRecords.size() - 1)).myOutVar.getName();
            String orCode = OptionalToIfInspection.wrapCode(context, this.myRecords, outVar.getName() + " = " + orResult + ";");
            if (orCode == null) {
                return null;
            }
            return "if (" + outVar.getName() + " == null) {\n" + orCode + "\n}" + context.generateNotNullCondition(outVar.getName(), code);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inVar";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/optionalToIf/IntermediateOperation$Or";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fn";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outVar";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/optionalToIf/IntermediateOperation$Or";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nestedOperations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getOutVar";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "rename";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class Map
    extends IntermediateOperation {
        private final FunctionHelper myFn;

        @Contract(pure=true)
        Map(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                Map.$$$reportNull$$$0(0);
            }
            if (outVar == null) {
                Map.$$$reportNull$$$0(1);
            }
            if (context == null) {
                Map.$$$reportNull$$$0(2);
            }
            this.myFn.preprocessVariable(context, inVar, 0);
            this.myFn.suggestOutputNames(context, outVar);
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull String newName, @NotNull OptionalToIfContext context) {
            if (oldName == null) {
                Map.$$$reportNull$$$0(3);
            }
            if (newName == null) {
                Map.$$$reportNull$$$0(4);
            }
            if (context == null) {
                Map.$$$reportNull$$$0(5);
            }
            this.myFn.rename(oldName, newName, context);
        }

        @Override
        @NotNull
        public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
            if (inVar == null) {
                Map.$$$reportNull$$$0(6);
            }
            return new ChainVariable(this.myFn.getResultType());
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                Map.$$$reportNull$$$0(7);
            }
            if (outVar == null) {
                Map.$$$reportNull$$$0(8);
            }
            if (code == null) {
                Map.$$$reportNull$$$0(9);
            }
            if (context == null) {
                Map.$$$reportNull$$$0(10);
            }
            this.myFn.transform(context, inVar.getName());
            return outVar.getDeclaration(this.myFn.getText()) + context.generateNotNullCondition(outVar.getName(), code);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inVar";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outVar";
                    break;
                }
                case 2: 
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/optionalToIf/IntermediateOperation$Map";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preprocessVariables";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rename";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOutVar";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Filter
    extends IntermediateOperation {
        private final FunctionHelper myFn;

        @Contract(pure=true)
        Filter(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        @NotNull
        public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
            if (inVar == null) {
                Filter.$$$reportNull$$$0(0);
            }
            ChainVariable chainVariable = inVar;
            if (chainVariable == null) {
                Filter.$$$reportNull$$$0(1);
            }
            return chainVariable;
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull String newName, @NotNull OptionalToIfContext context) {
            if (oldName == null) {
                Filter.$$$reportNull$$$0(2);
            }
            if (newName == null) {
                Filter.$$$reportNull$$$0(3);
            }
            if (context == null) {
                Filter.$$$reportNull$$$0(4);
            }
            this.myFn.rename(oldName, newName, context);
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                Filter.$$$reportNull$$$0(5);
            }
            if (outVar == null) {
                Filter.$$$reportNull$$$0(6);
            }
            if (context == null) {
                Filter.$$$reportNull$$$0(7);
            }
            this.myFn.preprocessVariable(context, inVar, 0);
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                Filter.$$$reportNull$$$0(8);
            }
            if (outVar == null) {
                Filter.$$$reportNull$$$0(9);
            }
            if (code == null) {
                Filter.$$$reportNull$$$0(10);
            }
            if (context == null) {
                Filter.$$$reportNull$$$0(11);
            }
            this.myFn.transform(context, outVar.getName());
            return context.generateCondition(this.myFn.getExpression(), code);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inVar";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/optionalToIf/IntermediateOperation$Filter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outVar";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/optionalToIf/IntermediateOperation$Filter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutVar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getOutVar";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "rename";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "preprocessVariables";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

