/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddVariableInitializerFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInsight.daemon.impl.quickfix.InitializeFinalFieldInConstructorFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotNullFieldNotInitializedInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String IGNORE_IMPLICITLY_WRITTEN_FIELDS_NAME = "IGNORE_IMPLICITLY_WRITTEN_FIELDS";
    private static final String IGNORE_FIELDS_WRITTEN_IN_SETUP_NAME = "IGNORE_FIELDS_WRITTEN_IN_SETUP";
    public boolean IGNORE_IMPLICITLY_WRITTEN_FIELDS = true;
    public boolean IGNORE_FIELDS_WRITTEN_IN_SETUP = true;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(JavaBundle.message((String)"inspection.notnull.field.not.initialized.option.implicit", (Object[])new Object[0]), IGNORE_IMPLICITLY_WRITTEN_FIELDS_NAME);
        panel2.addCheckbox(JavaBundle.message((String)"inspection.notnull.field.not.initialized.option.setup", (Object[])new Object[0]), IGNORE_FIELDS_WRITTEN_IN_SETUP_NAME);
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            NotNullFieldNotInitializedInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitField(PsiField field) {
                boolean writtenInSetup;
                boolean implicitWrite;
                NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)holder.getProject());
                NullabilityAnnotationInfo info = manager.findEffectiveNullabilityInfo((PsiModifierListOwner)field);
                if (info == null || info.getNullability() != Nullability.NOT_NULL || HighlightControlFlowUtil.isFieldInitializedAfterObjectConstruction(field)) {
                    return;
                }
                boolean bl = implicitWrite = (NotNullFieldNotInitializedInspection.this.IGNORE_IMPLICITLY_WRITTEN_FIELDS || isOnTheFly) && UnusedSymbolUtil.isImplicitWrite((PsiVariable)field);
                if (NotNullFieldNotInitializedInspection.this.IGNORE_IMPLICITLY_WRITTEN_FIELDS && implicitWrite) {
                    return;
                }
                boolean bl2 = writtenInSetup = (NotNullFieldNotInitializedInspection.this.IGNORE_FIELDS_WRITTEN_IN_SETUP || isOnTheFly) && NotNullFieldNotInitializedInspection.isWrittenInSetup(field);
                if (NotNullFieldNotInitializedInspection.this.IGNORE_FIELDS_WRITTEN_IN_SETUP && writtenInSetup) {
                    return;
                }
                boolean byDefault = info.isContainer();
                PsiAnnotation annotation = info.getAnnotation();
                PsiJavaCodeReferenceElement name2 = annotation.getNameReferenceElement();
                boolean ownAnnotation = annotation.isPhysical() && !byDefault;
                PsiAnnotation anchor = ownAnnotation ? annotation : field.getNameIdentifier();
                String message2 = (byDefault && name2 != null ? "@" + name2.getReferenceName() : "Not-null") + " fields must be initialized";
                ArrayList<Object> fixes = new ArrayList<Object>();
                if (implicitWrite) {
                    fixes.add(new SetInspectionOptionFix((LocalInspectionTool)NotNullFieldNotInitializedInspection.this, NotNullFieldNotInitializedInspection.IGNORE_IMPLICITLY_WRITTEN_FIELDS_NAME, JavaBundle.message((String)"inspection.notnull.field.not.initialized.option.implicit", (Object[])new Object[0]), true));
                }
                if (writtenInSetup) {
                    fixes.add(new SetInspectionOptionFix((LocalInspectionTool)NotNullFieldNotInitializedInspection.this, NotNullFieldNotInitializedInspection.IGNORE_FIELDS_WRITTEN_IN_SETUP_NAME, JavaBundle.message((String)"inspection.notnull.field.not.initialized.option.setup", (Object[])new Object[0]), true));
                }
                if (ownAnnotation) {
                    fixes.add((Object)new DeleteElementFix((PsiElement)annotation, JavaBundle.message((String)"quickfix.text.remove.not.null.annotation", (Object[])new Object[0])));
                }
                if (isOnTheFly) {
                    fixes.add((Object)new InitializeFinalFieldInConstructorFix(field));
                    fixes.add((Object)new AddVariableInitializerFix((PsiVariable)field));
                }
                holder.registerProblem((PsiElement)anchor, message2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        };
    }

    private static boolean isWrittenInSetup(PsiField field) {
        PsiCodeBlock body2;
        PsiMethod method = TestFrameworks.getInstance().findSetUpMethod(field.getContainingClass());
        return method != null && (body2 = method.getBody()) != null && HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)body2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NotNullFieldNotInitializedInspection", "buildVisitor"));
    }
}

