/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

class ClassPatternsPanel
extends JPanel {
    private final List<EntryPointsManagerBase.ClassPattern> myModifiedPatterns;
    private final JBTable myTable;

    ClassPatternsPanel(List<EntryPointsManagerBase.ClassPattern> patterns) {
        super(new BorderLayout());
        this.myModifiedPatterns = patterns;
        this.myTable = this.createTableForPatterns();
        String addClassMessage = "Add Class";
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(button -> {
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myTable));
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createWithInnerClassesScopeChooser("Add Class", GlobalSearchScope.allScope((Project)project), ClassFilter.ALL, null);
            chooser.showDialog();
            PsiClass selected = chooser.getSelected();
            if (selected != null) {
                this.insertRow(selected.getQualifiedName());
            }
        }).setAddActionName("Add Class").setRemoveAction(button -> {
            TableUtil.removeSelectedItems((JTable)this.myTable);
            this.myTable.repaint();
        }).setRemoveActionUpdater(e -> this.myTable.getSelectedRow() >= 0);
        this.add((Component)SeparatorFactory.createSeparator((String)"Mark code as entry point if qualified name matches", null), "North");
        this.add((Component)toolbarDecorator.createPanel(), "Center");
        this.add((Component)new MultiLineLabel("Leave method blank to represent constructors\nAny * will match against one or more characters in the qualified name (including dots)"), "South");
        this.setPreferredSize((Dimension)new JBDimension(-1, 250));
    }

    private void insertRow(String pattern) {
        EntryPointsManagerBase.ClassPattern classPattern = new EntryPointsManagerBase.ClassPattern();
        classPattern.pattern = pattern;
        this.myModifiedPatterns.add(classPattern);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        int row = this.myModifiedPatterns.size() - 1;
        model.fireTableRowsInserted(row, row);
        this.myTable.setRowSelectionInterval(row, row);
    }

    private JBTable createTableForPatterns() {
        MyTableModel dataModel = new MyTableModel();
        JBTable result = new JBTable((TableModel)dataModel);
        result.getSelectionModel().setSelectionMode(0);
        result.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                if (value2 instanceof String && ((String)value2).isEmpty()) {
                    this.setText(JavaBundle.message((String)"table.cell.constructors", (Object[])new Object[0]));
                    this.setForeground(UIUtil.getInactiveTextColor());
                } else if (value2 instanceof String) {
                    this.setText((String)value2);
                    this.setForeground(UIUtil.getTableForeground((boolean)isSelected));
                }
                return component;
            }
        });
        TableCellEditor editor = result.getDefaultEditor(String.class);
        if (editor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(1);
        }
        TableColumn column = result.getTableHeader().getColumnModel().getColumn(0);
        column.setResizable(false);
        int width = 15 + result.getTableHeader().getFontMetrics(result.getTableHeader().getFont()).stringWidth(result.getColumnName(0));
        column.setMaxWidth(width);
        column.setMinWidth(width);
        return result;
    }

    public String getValidationError(Project project) {
        TableUtil.stopEditing((JTable)this.myTable);
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)project);
        ClassPatternValidator validator2 = new ClassPatternValidator(nameHelper);
        for (EntryPointsManagerBase.ClassPattern pattern : this.myModifiedPatterns) {
            String errorText = validator2.getErrorText(pattern.pattern);
            if (errorText != null) {
                return errorText;
            }
            String subst = pattern.method.replace("*", "");
            if (subst.isEmpty() || nameHelper.isIdentifier(subst)) continue;
            return "Method pattern '" + pattern.method + "' must be a valid java identifier, only '*' are accepted as placeholders";
        }
        return null;
    }

    private class MyTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        private final String[] myNames = new String[]{"With Subclasses", "Class", "Method"};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ClassPatternsPanel.this.myModifiedPatterns.size();
        }

        @Override
        @Nullable
        public Object getValueAt(int row, int col) {
            if (row < 0 || row > ClassPatternsPanel.this.myModifiedPatterns.size() - 1) {
                return null;
            }
            EntryPointsManagerBase.ClassPattern classPattern = (EntryPointsManagerBase.ClassPattern)ClassPatternsPanel.this.myModifiedPatterns.get(row);
            if (classPattern == null) {
                return null;
            }
            if (col == 0) {
                return classPattern.hierarchically;
            }
            if (col == 1) {
                return classPattern.pattern;
            }
            return classPattern.method;
        }

        @Override
        public String getColumnName(int column) {
            return this.myNames[column];
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            if (col == 1) {
                return String.class;
            }
            if (col == 2) {
                return String.class;
            }
            throw new IllegalArgumentException(String.valueOf(col));
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            EntryPointsManagerBase.ClassPattern classPattern = (EntryPointsManagerBase.ClassPattern)ClassPatternsPanel.this.myModifiedPatterns.get(row);
            if (classPattern == null) {
                return;
            }
            if (col == 0) {
                classPattern.hierarchically = (Boolean)aValue;
            } else if (col == 1) {
                classPattern.pattern = (String)aValue;
            } else {
                classPattern.method = (String)aValue;
            }
            this.fireTableRowsUpdated(row, row);
        }

        public void removeRow(int idx) {
            ClassPatternsPanel.this.myModifiedPatterns.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }
    }

    private static class ClassPatternValidator
    implements InputValidatorEx {
        public static final String ERROR_MESSAGE = "Pattern must be a valid java qualified name, only '*' are accepted as placeholders";
        private final PsiNameHelper myNameHelper;

        ClassPatternValidator(PsiNameHelper nameHelper) {
            this.myNameHelper = nameHelper;
        }

        @Nullable
        public String getErrorText(String inputString) {
            if (inputString.startsWith(".")) {
                return ERROR_MESSAGE;
            }
            String qName = inputString.replace("*", "").replace(".", "");
            return !StringUtil.isEmpty((String)qName) && !this.myNameHelper.isQualifiedName(qName) ? ERROR_MESSAGE : null;
        }

        public boolean checkInput(String inputString) {
            return this.getErrorText(inputString) == null;
        }

        public boolean canClose(String inputString) {
            return this.getErrorText(inputString) == null;
        }
    }
}

