/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateExpressions;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ComplexityCalculator {
    private static final int IDENTIFIER = 10;
    private static final int QUALIFIER = 6;
    private static final int CONSTANT = 1;
    private static final int OPERATOR = 10;
    private static final int SIMPLE_OPERATOR = 2;
    private static final int TERNARY_OPERATOR = 20;
    private static final int METHOD_CALL = 20;
    private static final int SLICE = 10;
    private static final int LAMBDA = 20;
    private static final int REFERENCE = 20;
    private static final int NEW_EXPR = 20;
    private static final int PARAMETER = 1;
    private static final int UNKNOWN = 15;
    private static final TokenSet NEGATIONS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.EXCL, JavaTokenType.MINUS, JavaTokenType.TILDE});
    private final ObjectIntHashMap<PsiExpression> myCache = new ObjectIntHashMap();

    ComplexityCalculator() {
    }

    int getComplexity(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return 0;
        }
        int complexity = this.myCache.get((Object)expression2);
        if (complexity < 0) {
            complexity = this.calculateComplexity(expression2);
            this.myCache.put((Object)expression2, complexity);
        }
        return complexity;
    }

    private int calculateComplexity(@NotNull PsiExpression e) {
        if (e == null) {
            ComplexityCalculator.$$$reportNull$$$0(0);
        }
        if (e instanceof PsiLiteralExpression) {
            return 1;
        }
        if (e instanceof PsiInstanceOfExpression || e instanceof PsiTypeCastExpression) {
            return 10;
        }
        if (e instanceof PsiClassObjectAccessExpression) {
            return 6;
        }
        if (e instanceof PsiQualifiedExpression) {
            return ((PsiQualifiedExpression)e).getQualifier() != null ? 6 : 0;
        }
        if (e instanceof PsiParenthesizedExpression) {
            return this.getComplexity(((PsiParenthesizedExpression)e).getExpression());
        }
        if (e instanceof PsiUnaryExpression) {
            PsiUnaryExpression unary = (PsiUnaryExpression)e;
            int c = NEGATIONS.contains(unary.getOperationTokenType()) ? 2 : 10;
            return this.getComplexity(unary.getOperand()) + c;
        }
        if (e instanceof PsiBinaryExpression) {
            PsiBinaryExpression binary = (PsiBinaryExpression)e;
            IElementType token = binary.getOperationTokenType();
            PsiExpression left = binary.getLOperand();
            PsiExpression right = binary.getROperand();
            int c = PsiBinaryExpression.BOOLEAN_OPERATION_TOKENS.contains(token) || JavaTokenType.PLUS.equals(token) && (ComplexityCalculator.isLiteral(left, "1") || ComplexityCalculator.isLiteral(right, "1")) || JavaTokenType.MINUS.equals(token) && ComplexityCalculator.isLiteral(right, "1") || JavaTokenType.ASTERISK.equals(token) && (ComplexityCalculator.isLiteral(left, "2") || ComplexityCalculator.isLiteral(right, "2")) || JavaTokenType.DIV.equals(token) && ComplexityCalculator.isLiteral(right, "2") ? 2 : 10;
            return c + this.getComplexity(left) + this.getComplexity(right);
        }
        if (e instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)e;
            int c = PsiBinaryExpression.BOOLEAN_OPERATION_TOKENS.contains(polyadic.getOperationTokenType()) ? 2 : 10;
            for (PsiExpression operand2 : polyadic.getOperands()) {
                c += this.getComplexity(operand2);
            }
            return c;
        }
        if (e instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)e;
            return 20 + this.getComplexity(conditional.getCondition()) + this.getComplexity(conditional.getThenExpression()) + this.getComplexity(conditional.getElseExpression());
        }
        if (e instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)e;
            PsiReferenceExpression ref = call.getMethodExpression();
            return 20 + this.getComplexity(ref.getQualifierExpression()) + this.calculateArgumentsComplexity(call.getArgumentList());
        }
        if (e instanceof PsiReferenceExpression) {
            PsiField field;
            PsiReferenceExpression ref = (PsiReferenceExpression)e;
            PsiElement resolved = ref.resolve();
            if (resolved instanceof PsiClass) {
                return 6;
            }
            int w = 20;
            if (PsiUtil.isJvmLocalVariable((PsiElement)resolved)) {
                w = 10;
            } else if (resolved instanceof PsiField && (field = (PsiField)resolved).hasModifierProperty("final")) {
                w = field.hasModifierProperty("static") ? 1 : 10;
            }
            return this.getComplexity(ref.getQualifierExpression()) + w;
        }
        if (e instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression access = (PsiArrayAccessExpression)e;
            return 10 + this.getComplexity(access.getArrayExpression()) + this.getComplexity(access.getIndexExpression());
        }
        if (e instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)e;
            PsiElement body2 = lambda2.getBody();
            int c = 20 + 1 * lambda2.getParameterList().getParametersCount();
            PsiExpression bodyExpr = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2);
            if (bodyExpr != null) {
                return c + this.getComplexity(bodyExpr);
            }
            if (body2 instanceof PsiCodeBlock) {
                return c + 15 * ((PsiCodeBlock)body2).getStatementCount();
            }
            return c + 15;
        }
        if (e instanceof PsiArrayInitializerExpression) {
            PsiExpression[] initializers = ((PsiArrayInitializerExpression)e).getInitializers();
            int c = 0;
            for (PsiExpression initializer : initializers) {
                c += 1 + this.getComplexity(initializer);
            }
            return c;
        }
        if (e instanceof PsiNewExpression) {
            PsiNewExpression newExpr = (PsiNewExpression)e;
            return 20 + this.getComplexity(newExpr.getQualifier()) + this.getComplexity((PsiExpression)newExpr.getArrayInitializer()) + this.calculateArgumentsComplexity(newExpr.getArgumentList()) + (newExpr.getAnonymousClass() != null ? 15 : 0);
        }
        return 15;
    }

    private int calculateArgumentsComplexity(@Nullable PsiExpressionList arguments) {
        if (arguments == null) {
            return 0;
        }
        int c = 0;
        for (PsiExpression argument : arguments.getExpressions()) {
            c += 1 + this.getComplexity(argument);
        }
        return c;
    }

    private static boolean isLiteral(@Nullable PsiExpression expression2, @NotNull String withText) {
        if (withText == null) {
            ComplexityCalculator.$$$reportNull$$$0(1);
        }
        return (expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiLiteral && expression2.textMatches((CharSequence)withText);
    }

    static boolean isDefinitelySimple(@Nullable PsiExpression expression2) {
        PsiElement qualifier;
        if (expression2 instanceof PsiLiteral) {
            return true;
        }
        if (expression2 instanceof PsiReferenceExpression && ((qualifier = ((PsiReferenceExpression)expression2).getQualifier()) instanceof PsiQualifiedExpression || !(qualifier instanceof PsiExpression))) {
            PsiElement resolved = ((PsiReferenceExpression)expression2).resolve();
            return resolved instanceof PsiVariable || resolved instanceof PsiClass;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/duplicateExpressions/ComplexityCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateComplexity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isLiteral";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

