/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.TransferTarget;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.FactoryMap;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaValueFactory {
    @NotNull
    private final List<DfaValue> myValues;
    private final boolean myUnknownMembersAreNullable;
    @NotNull
    private final FieldChecker myFieldChecker;
    @NotNull
    private final Project myProject;
    private static final ElementPattern<? extends PsiModifierListOwner> MEMBER_OR_METHOD_PARAMETER = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiMember(), PsiJavaPatterns.psiParameter().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiMember())});
    private final Map<Pair<TransferTarget, FList<Trap>>, DfaControlTransferValue> myControlTransfers;
    private final DfaVariableValue.Factory myVarFactory;
    private final DfaBoxedValue.Factory myBoxedFactory;
    private final DfaBinOpValue.Factory myBinOpFactory;
    private final DfaExpressionFactory myExpressionFactory;
    private final DfaTypeValue.Factory myTypeValueFactory;
    private final DfaValue mySentinelValue;

    public DfaValueFactory(@NotNull Project project, @Nullable PsiElement context, boolean unknownMembersAreNullable) {
        if (project == null) {
            DfaValueFactory.$$$reportNull$$$0(0);
        }
        this.myValues = new ArrayList<DfaValue>();
        this.myControlTransfers = FactoryMap.create(p -> new DfaControlTransferValue(this, (TransferTarget)p.first, (FList<Trap>)((FList)p.second)));
        this.mySentinelValue = new DfaValue(this){

            public String toString() {
                return "SENTINEL";
            }
        };
        this.myProject = project;
        this.myFieldChecker = new FieldChecker(context);
        this.myUnknownMembersAreNullable = unknownMembersAreNullable;
        this.myValues.add(null);
        this.myVarFactory = new DfaVariableValue.Factory(this);
        this.myBoxedFactory = new DfaBoxedValue.Factory(this);
        this.myExpressionFactory = new DfaExpressionFactory(this);
        this.myBinOpFactory = new DfaBinOpValue.Factory(this);
        this.myTypeValueFactory = new DfaTypeValue.Factory(this);
    }

    public boolean canTrustFieldInitializer(PsiField field) {
        return this.myFieldChecker.canTrustFieldInitializer(field);
    }

    @NotNull
    public Nullability suggestNullabilityForNonAnnotatedMember(@NotNull PsiModifierListOwner member) {
        if (member == null) {
            DfaValueFactory.$$$reportNull$$$0(1);
        }
        if (this.myUnknownMembersAreNullable && MEMBER_OR_METHOD_PARAMETER.accepts((Object)member) && AnnotationUtil.getSuperAnnotationOwners((PsiModifierListOwner)member).isEmpty()) {
            Nullability nullability = Nullability.NULLABLE;
            if (nullability == null) {
                DfaValueFactory.$$$reportNull$$$0(2);
            }
            return nullability;
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            DfaValueFactory.$$$reportNull$$$0(3);
        }
        return nullability;
    }

    @NotNull
    public DfaTypeValue getObjectType(@Nullable PsiType type2, @NotNull Nullability nullability) {
        if (nullability == null) {
            DfaValueFactory.$$$reportNull$$$0(4);
        }
        DfaTypeValue dfaTypeValue = this.fromDfType(DfTypes.typedObject(type2, nullability));
        if (dfaTypeValue == null) {
            DfaValueFactory.$$$reportNull$$$0(5);
        }
        return dfaTypeValue;
    }

    int registerValue(DfaValue value2) {
        this.myValues.add(value2);
        return this.myValues.size() - 1;
    }

    public DfaValue getValue(int id) {
        return this.myValues.get(id);
    }

    @Nullable
    @Contract(value="null -> null")
    public DfaValue createValue(PsiExpression psiExpression) {
        return this.myExpressionFactory.getExpressionDfaValue(psiExpression);
    }

    @NotNull
    public DfaTypeValue getInt(int value2) {
        DfaTypeValue dfaTypeValue = this.fromDfType(DfTypes.intValue(value2));
        if (dfaTypeValue == null) {
            DfaValueFactory.$$$reportNull$$$0(6);
        }
        return dfaTypeValue;
    }

    @NotNull
    public DfaTypeValue getUnknown() {
        DfaTypeValue dfaTypeValue = this.fromDfType(DfTypes.TOP);
        if (dfaTypeValue == null) {
            DfaValueFactory.$$$reportNull$$$0(7);
        }
        return dfaTypeValue;
    }

    @NotNull
    public DfaValue getSentinel() {
        DfaValue dfaValue = this.mySentinelValue;
        if (dfaValue == null) {
            DfaValueFactory.$$$reportNull$$$0(8);
        }
        return dfaValue;
    }

    @NotNull
    public DfaTypeValue getBoolean(boolean value2) {
        DfaTypeValue dfaTypeValue = this.fromDfType(DfTypes.booleanValue(value2));
        if (dfaTypeValue == null) {
            DfaValueFactory.$$$reportNull$$$0(9);
        }
        return dfaTypeValue;
    }

    @NotNull
    public DfaTypeValue getNull() {
        DfaTypeValue dfaTypeValue = this.fromDfType(DfTypes.NULL);
        if (dfaTypeValue == null) {
            DfaValueFactory.$$$reportNull$$$0(10);
        }
        return dfaTypeValue;
    }

    public DfaTypeValue getConstant(Object value2, @NotNull PsiType type2) {
        if (type2 == null) {
            DfaValueFactory.$$$reportNull$$$0(11);
        }
        return this.fromDfType(DfTypes.constant(value2, type2));
    }

    @Nullable
    public DfaValue getConstantFromVariable(PsiVariable variable) {
        if (!variable.hasModifierProperty("final") || DfaUtil.ignoreInitializer(variable)) {
            return null;
        }
        Object value2 = variable.computeConstantValue();
        PsiType type2 = variable.getType();
        if (value2 == null) {
            Boolean boo = DfaValueFactory.computeJavaLangBooleanFieldReference(variable);
            if (boo != null) {
                DfaTypeValue unboxed = this.getConstant(boo, (PsiType)PsiType.BOOLEAN);
                return this.getBoxedFactory().createBoxed(unboxed, (PsiType)PsiType.BOOLEAN.getBoxedType((PsiElement)variable));
            }
            if (DfaUtil.isEmptyCollectionConstantField(variable)) {
                return this.getConstant(variable, type2);
            }
            PsiExpression initializer = variable instanceof PsiFieldImpl ? ((PsiFieldImpl)variable).getDetachedInitializer() : variable.getInitializer();
            if ((initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer)) instanceof PsiLiteralExpression && initializer.textMatches((CharSequence)"null")) {
                return this.getNull();
            }
            if (variable instanceof PsiField && variable.hasModifierProperty("static") && ExpressionUtils.isNewObject(initializer)) {
                return this.getConstant(variable, type2);
            }
            return null;
        }
        return this.getConstant(value2, type2);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DfaValueFactory.$$$reportNull$$$0(12);
        }
        return project;
    }

    @Nullable
    private static Boolean computeJavaLangBooleanFieldReference(PsiVariable variable) {
        if (!(variable instanceof PsiField)) {
            return null;
        }
        PsiClass psiClass = ((PsiField)variable).getContainingClass();
        if (psiClass == null || !"java.lang.Boolean".equals(psiClass.getQualifiedName())) {
            return null;
        }
        String name2 = variable.getName();
        return "TRUE".equals(name2) ? Boolean.TRUE : ("FALSE".equals(name2) ? Boolean.FALSE : null);
    }

    @NotNull
    public DfaTypeValue fromDfType(@NotNull DfType dfType) {
        if (dfType == null) {
            DfaValueFactory.$$$reportNull$$$0(13);
        }
        DfaTypeValue dfaTypeValue = this.myTypeValueFactory.create(dfType);
        if (dfaTypeValue == null) {
            DfaValueFactory.$$$reportNull$$$0(14);
        }
        return dfaTypeValue;
    }

    public Collection<DfaValue> getValues() {
        return Collections.unmodifiableCollection(this.myValues);
    }

    @NotNull
    public DfaControlTransferValue controlTransfer(TransferTarget kind2, FList<Trap> traps) {
        DfaControlTransferValue dfaControlTransferValue = this.myControlTransfers.get(Pair.create((Object)kind2, traps));
        if (dfaControlTransferValue == null) {
            DfaValueFactory.$$$reportNull$$$0(15);
        }
        return dfaControlTransferValue;
    }

    @NotNull
    public DfaVariableValue.Factory getVarFactory() {
        DfaVariableValue.Factory factory = this.myVarFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(16);
        }
        return factory;
    }

    @NotNull
    public DfaBoxedValue.Factory getBoxedFactory() {
        DfaBoxedValue.Factory factory = this.myBoxedFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(17);
        }
        return factory;
    }

    @NotNull
    public DfaExpressionFactory getExpressionFactory() {
        DfaExpressionFactory dfaExpressionFactory = this.myExpressionFactory;
        if (dfaExpressionFactory == null) {
            DfaValueFactory.$$$reportNull$$$0(18);
        }
        return dfaExpressionFactory;
    }

    @NotNull
    public DfaBinOpValue.Factory getBinOpFactory() {
        DfaBinOpValue.Factory factory = this.myBinOpFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(19);
        }
        return factory;
    }

    @NotNull
    public DfaValue createCommonValue(PsiExpression @NotNull [] expressions2, PsiType targetType) {
        if (expressions2 == null) {
            DfaValueFactory.$$$reportNull$$$0(20);
        }
        DfaValue loopElement = null;
        for (PsiExpression expression2 : expressions2) {
            DfaValue expressionValue = this.createValue(expression2);
            if (expressionValue == null) {
                expressionValue = this.getObjectType(expression2.getType(), NullabilityUtil.getExpressionNullability(expression2));
            }
            DfaValue dfaValue = loopElement = loopElement == null ? expressionValue : loopElement.unite(expressionValue);
            if (DfaTypeValue.isUnknown(loopElement)) break;
        }
        DfaValue dfaValue = loopElement == null ? this.getUnknown() : DfaUtil.boxUnbox(loopElement, targetType);
        if (dfaValue == null) {
            DfaValueFactory.$$$reportNull$$$0(21);
        }
        return dfaValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNullabilityForNonAnnotatedMember";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInt";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknown";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSentinel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoolean";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNull";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDfType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "controlTransfer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarFactory";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoxedFactory";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionFactory";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinOpFactory";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommonValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "suggestNullabilityForNonAnnotatedMember";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getObjectType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getConstant";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fromDfType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createCommonValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FieldChecker {
        private final boolean myTrustDirectFieldInitializers;
        private final boolean myTrustFieldInitializersInConstructors;
        private final boolean myCanInstantiateItself;
        private final PsiClass myClass;

        FieldChecker(PsiElement context) {
            PsiClass contextClass;
            PsiMethod method;
            PsiMethod psiMethod = method = context instanceof PsiClass ? null : (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class);
            this.myClass = contextClass = method != null ? method.getContainingClass() : (context instanceof PsiClass ? (PsiClass)context : null);
            if (method == null || this.myClass == null) {
                this.myCanInstantiateItself = false;
                this.myTrustFieldInitializersInConstructors = false;
                this.myTrustDirectFieldInitializers = false;
                return;
            }
            ClassInitializationInfo info = (ClassInitializationInfo)CachedValuesManager.getCachedValue((PsiElement)contextClass, () -> CachedValueProvider.Result.create((Object)new ClassInitializationInfo(contextClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            this.myCanInstantiateItself = info.myCanInstantiateItself;
            if (method.hasModifierProperty("static") || method.isConstructor()) {
                this.myTrustDirectFieldInitializers = true;
                this.myTrustFieldInitializersInConstructors = false;
                return;
            }
            this.myTrustFieldInitializersInConstructors = !info.mySuperCtorsCallMethods && !info.myCtorsCallMethods;
            this.myTrustDirectFieldInitializers = !info.mySuperCtorsCallMethods;
        }

        boolean canTrustFieldInitializer(PsiField field) {
            if (field.hasInitializer()) {
                boolean staticField = field.hasModifierProperty("static");
                if (staticField && this.myClass != null && field.getContainingClass() != this.myClass) {
                    return true;
                }
                return this.myTrustDirectFieldInitializers && (!this.myCanInstantiateItself || !staticField);
            }
            return this.myTrustFieldInitializersInConstructors;
        }
    }

    private static class ClassInitializationInfo {
        private static final CallMatcher SAFE_CALLS = CallMatcher.staticCall("java.util.Objects", "requireNonNull");
        final boolean myCanInstantiateItself;
        final boolean myCtorsCallMethods;
        final boolean mySuperCtorsCallMethods;

        ClassInitializationInfo(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                ClassInitializationInfo.$$$reportNull$$$0(0);
            }
            boolean canInstantiateItself = false;
            for (PsiElement child = psiClass.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof PsiMember) || !((PsiMember)child).hasModifierProperty("static") || SyntaxTraverser.psiTraverser((PsiElement)child).filter(PsiNewExpression.class).filterMap(PsiNewExpression::getClassReference).find(classRef -> classRef.isReferenceTo((PsiElement)psiClass)) == null) continue;
                canInstantiateItself = true;
                break;
            }
            this.myCanInstantiateItself = canInstantiateItself;
            this.mySuperCtorsCallMethods = !InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)false, superClass -> !ClassInitializationInfo.canCallMethodsInConstructors(superClass, true));
            this.myCtorsCallMethods = ClassInitializationInfo.canCallMethodsInConstructors(psiClass, false);
        }

        private static boolean canCallMethodsInConstructors(@NotNull PsiClass aClass, boolean virtual) {
            if (aClass == null) {
                ClassInitializationInfo.$$$reportNull$$$0(1);
            }
            boolean inByteCode = false;
            if (aClass instanceof PsiCompiledElement) {
                inByteCode = true;
                PsiElement navigationElement = aClass.getNavigationElement();
                if (navigationElement instanceof PsiClass) {
                    aClass = (PsiClass)navigationElement;
                }
            }
            for (PsiMethod constructor : aClass.getConstructors()) {
                if (inByteCode && JavaMethodContractUtil.isPure(constructor) && !JavaMethodContractUtil.hasExplicitContractAnnotation(constructor)) continue;
                if (!constructor.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
                    return true;
                }
                PsiCodeBlock body2 = constructor.getBody();
                if (body2 == null) continue;
                for (PsiMethodCallExpression call : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)body2)).filter(PsiMethodCallExpression.class)) {
                    PsiReferenceExpression methodExpression = call.getMethodExpression();
                    if (methodExpression.textMatches((CharSequence)"this") || methodExpression.textMatches((CharSequence)"super") || SAFE_CALLS.test(call)) continue;
                    if (!virtual) {
                        return true;
                    }
                    PsiMethod target = call.resolveMethod();
                    if (target == null || !PsiUtil.canBeOverridden((PsiMethod)target)) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory$ClassInitializationInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canCallMethodsInConstructors";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

