/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;

public class BoxingInliner
implements CallInliner {
    private static final CallMatcher BOXING_CALL = CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Integer", "valueOf").parameterTypes("int"), CallMatcher.staticCall("java.lang.Long", "valueOf").parameterTypes("long"), CallMatcher.staticCall("java.lang.Short", "valueOf").parameterTypes("short"), CallMatcher.staticCall("java.lang.Byte", "valueOf").parameterTypes("byte"), CallMatcher.staticCall("java.lang.Character", "valueOf").parameterTypes("char"), CallMatcher.staticCall("java.lang.Boolean", "valueOf").parameterTypes("boolean"), CallMatcher.staticCall("java.lang.Float", "valueOf").parameterTypes("float"), CallMatcher.staticCall("java.lang.Double", "valueOf").parameterTypes("double"));

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (builder == null) {
            BoxingInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            BoxingInliner.$$$reportNull$$$0(1);
        }
        if (BOXING_CALL.test(call)) {
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            PsiPrimitiveType type2 = PsiPrimitiveType.getUnboxedType((PsiType)call.getType());
            builder.pushExpression(arg).boxUnbox(arg, arg.getType(), (PsiType)type2).boxUnbox((PsiExpression)call, (PsiType)type2, call.getType());
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/dataFlow/inliner/BoxingInliner";
        objectArray[2] = "tryInlineCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

