/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.StateMerger;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class StateQueue {
    private static final int FORCE_MERGE_THRESHOLD = 100;
    private boolean myWasForciblyMerged;
    private final PriorityQueue<DfaInstructionState> myQueue = new PriorityQueue();
    private final Set<Pair<Instruction, DfaMemoryState>> mySet = new HashSet<Pair<Instruction, DfaMemoryState>>();

    StateQueue() {
    }

    void offer(DfaInstructionState state) {
        if (this.mySet.add((Pair<Instruction, DfaMemoryState>)Pair.create((Object)state.getInstruction(), (Object)state.getMemoryState()))) {
            this.myQueue.offer(state);
        }
    }

    boolean isEmpty() {
        return this.myQueue.isEmpty();
    }

    boolean processAll(@NotNull Processor<? super DfaInstructionState> processor) {
        if (processor == null) {
            StateQueue.$$$reportNull$$$0(0);
        }
        for (DfaInstructionState state : this.myQueue) {
            if (processor.process((Object)state)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    List<DfaInstructionState> getNextInstructionStates(Set<Instruction> joinInstructions) {
        DfaInstructionState state = (DfaInstructionState)this.myQueue.remove();
        Instruction instruction = state.getInstruction();
        this.mySet.remove(Pair.create((Object)instruction, (Object)state.getMemoryState()));
        DfaInstructionState next = this.myQueue.peek();
        if (next == null || next.compareTo(state) != 0) {
            List<DfaInstructionState> list = Collections.singletonList(state);
            if (list == null) {
                StateQueue.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<DfaMemoryStateImpl> memoryStates = new ArrayList<DfaMemoryStateImpl>();
        memoryStates.add((DfaMemoryStateImpl)state.getMemoryState());
        while (!this.myQueue.isEmpty() && this.myQueue.peek().compareTo(state) == 0) {
            DfaMemoryState anotherState = this.myQueue.poll().getMemoryState();
            this.mySet.remove(Pair.create((Object)instruction, (Object)anotherState));
            memoryStates.add((DfaMemoryStateImpl)anotherState);
        }
        if (memoryStates.size() > 1 && joinInstructions.contains(instruction)) {
            memoryStates = StateQueue.squash(memoryStates);
        }
        if (memoryStates.size() > 1 && joinInstructions.contains(instruction)) {
            int beforeSize;
            do {
                beforeSize = memoryStates.size();
                MultiMap groups = MultiMap.create();
                for (DfaMemoryStateImpl memoryState : memoryStates) {
                    groups.putValue(memoryState.getSuperficialKey(), (Object)memoryState);
                }
                memoryStates = new ArrayList();
                for (Map.Entry entry : groups.entrySet()) {
                    memoryStates.addAll(StateQueue.mergeGroup((List)entry.getValue()));
                }
            } while (memoryStates.size() != beforeSize && (beforeSize = memoryStates.size()) != 1 && (memoryStates = StateQueue.squash(memoryStates)).size() != beforeSize && memoryStates.size() != 1);
        }
        memoryStates = this.forceMerge(memoryStates);
        List list = ContainerUtil.map(memoryStates, state1 -> new DfaInstructionState(instruction, (DfaMemoryState)state1));
        if (list == null) {
            StateQueue.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static List<DfaMemoryStateImpl> squash(List<DfaMemoryStateImpl> states) {
        ArrayList<DfaMemoryStateImpl> result = new ArrayList<DfaMemoryStateImpl>(states);
        Iterator iterator = result.iterator();
        block0: while (iterator.hasNext()) {
            DfaMemoryStateImpl left = (DfaMemoryStateImpl)iterator.next();
            for (DfaMemoryStateImpl right : result) {
                ProgressManager.checkCanceled();
                if (right == left || !right.isSuperStateOf(left)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return result;
    }

    static List<DfaMemoryStateImpl> mergeGroup(List<DfaMemoryStateImpl> group) {
        if (group.size() < 2) {
            return group;
        }
        StateMerger merger = new StateMerger();
        while (group.size() > 1) {
            List<DfaMemoryStateImpl> nextStates = merger.mergeByRanges(group);
            if (nextStates == null) {
                nextStates = merger.mergeByFacts(group);
            }
            if (nextStates == null) break;
            group = nextStates;
        }
        return group;
    }

    private List<DfaMemoryStateImpl> forceMerge(List<DfaMemoryStateImpl> states) {
        if (states.size() < 100) {
            return states;
        }
        this.myWasForciblyMerged = true;
        Collection groups = StreamEx.of(states).groupingBy(DfaMemoryStateImpl::getMergeabilityKey).values();
        return (List)((StreamEx)StreamEx.of(groups).flatMap(group -> StreamEx.ofSubLists((List)group, (int)2).map(pair2 -> {
            if (pair2.size() == 2) {
                ((DfaMemoryStateImpl)pair2.get(0)).merge((DfaMemoryStateImpl)pair2.get(1));
            }
            return (DfaMemoryStateImpl)pair2.get(0);
        })).distinct()).toListAndThen(StateQueue::squash);
    }

    boolean wasForciblyMerged() {
        return this.myWasForciblyMerged;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StateQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StateQueue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextInstructionStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

