/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.DefaultInferredAnnotationProvider;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodContractUtil {
    public static final String ORG_JETBRAINS_ANNOTATIONS_CONTRACT = Contract.class.getName();

    private JavaMethodContractUtil() {
    }

    @NotNull
    public static List<? extends MethodContract> getMethodCallContracts(@NotNull PsiCallExpression call) {
        PsiMethod method;
        if (call == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(0);
        }
        return (method = call.resolveMethod()) == null ? Collections.emptyList() : JavaMethodContractUtil.getMethodCallContracts(method, call);
    }

    @NotNull
    public static List<? extends MethodContract> getMethodCallContracts(@NotNull PsiMethod method, @Nullable PsiCallExpression call) {
        List<MethodContract> hardcoded;
        if (method == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(1);
        }
        if (!(hardcoded = HardcodedContracts.getHardcodedContracts(method, (PsiMethodCallExpression)ObjectUtils.tryCast((Object)call, PsiMethodCallExpression.class))).isEmpty()) {
            NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)method.getProject()).findEffectiveNullabilityInfo((PsiModifierListOwner)method);
            if (info == null || info.isExternal() || info.getNullability() != Nullability.NOT_NULL) {
                List<MethodContract> list = hardcoded;
                if (list == null) {
                    JavaMethodContractUtil.$$$reportNull$$$0(2);
                }
                return list;
            }
            if (HardcodedContracts.getHardcodedContracts(method, null).isEmpty()) {
                List<MethodContract> list = hardcoded;
                if (list == null) {
                    JavaMethodContractUtil.$$$reportNull$$$0(3);
                }
                return list;
            }
        }
        return JavaMethodContractUtil.getMethodContracts(method);
    }

    @NotNull
    public static List<StandardMethodContract> getMethodContracts(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(4);
        }
        List<StandardMethodContract> list = JavaMethodContractUtil.getContractInfo(method).getContracts();
        if (list == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    public static boolean hasExplicitContractAnnotation(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(6);
        }
        return JavaMethodContractUtil.getContractInfo(method).isExplicit();
    }

    @Nullable
    public static PsiAnnotation updateContract(PsiAnnotation annotation, List<StandardMethodContract> contracts2) {
        boolean pure = Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"pure"));
        String mutates = StringUtil.notNullize((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"mutates"));
        String resultValue = StreamEx.of(contracts2).joining((CharSequence)"; ");
        Project project = annotation.getProject();
        return DefaultInferredAnnotationProvider.createContractAnnotation(project, pure, resultValue, mutates);
    }

    @NotNull
    static ContractInfo getContractInfo(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(7);
        }
        ContractInfo contractInfo = (ContractInfo)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            PsiAnnotation contractAnno = JavaMethodContractUtil.findContractAnnotation(method);
            ContractInfo info = ContractInfo.EMPTY;
            if (contractAnno != null) {
                List<StandardMethodContract> contracts2 = JavaMethodContractUtil.parseContracts(method, contractAnno);
                boolean pure = Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)contractAnno, (String)"pure"));
                MutationSignature mutationSignature = MutationSignature.UNKNOWN;
                if (pure) {
                    mutationSignature = MutationSignature.PURE;
                } else {
                    String mutationText = AnnotationUtil.getStringAttributeValue((PsiAnnotation)contractAnno, (String)"mutates");
                    if (mutationText != null) {
                        try {
                            mutationSignature = MutationSignature.parse(mutationText);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                boolean explicit = !AnnotationUtil.isInferredAnnotation((PsiAnnotation)contractAnno);
                info = new ContractInfo(contracts2, pure, explicit, mutationSignature);
            }
            return CachedValueProvider.Result.create((Object)info, (Object[])new Object[]{method, PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (contractInfo == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(8);
        }
        return contractInfo;
    }

    @NotNull
    public static List<StandardMethodContract> parseContracts(@NotNull PsiMethod method, @Nullable PsiAnnotation contractAnno) {
        block8: {
            if (method == null) {
                JavaMethodContractUtil.$$$reportNull$$$0(9);
            }
            if (contractAnno == null) {
                List<StandardMethodContract> list = Collections.emptyList();
                if (list == null) {
                    JavaMethodContractUtil.$$$reportNull$$$0(10);
                }
                return list;
            }
            String text2 = AnnotationUtil.getStringAttributeValue((PsiAnnotation)contractAnno, null);
            if (text2 != null) {
                List<StandardMethodContract> list;
                try {
                    int paramCount = method.getParameterList().getParametersCount();
                    List<StandardMethodContract> parsed = StandardMethodContract.parseContract(text2);
                    if (!parsed.stream().allMatch(c -> c.getParameterCount() == paramCount)) break block8;
                    list = parsed;
                }
                catch (StandardMethodContract.ParseException parseException) {
                    // empty catch block
                }
                if (list == null) {
                    JavaMethodContractUtil.$$$reportNull$$$0(11);
                }
                return list;
            }
        }
        List<StandardMethodContract> list = Collections.emptyList();
        if (list == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public static PsiAnnotation findContractAnnotation(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(13);
        }
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton(ORG_JETBRAINS_ANNOTATIONS_CONTRACT));
    }

    public static boolean isPure(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(14);
        }
        return JavaMethodContractUtil.getContractInfo(method).isPure();
    }

    @Nullable
    public static ContractReturnValue getNonFailingReturnValue(List<? extends MethodContract> contracts2) {
        ArrayList<ContractValue> failConditions = new ArrayList<ContractValue>();
        for (MethodContract methodContract : contracts2) {
            List<ContractValue> conditions = methodContract.getConditions();
            if (conditions.isEmpty() || conditions.stream().allMatch(c -> failConditions.stream().anyMatch(c::isExclusive))) {
                return methodContract.getReturnValue();
            }
            if (!methodContract.getReturnValue().isFail()) break;
            if (conditions.size() != 1) continue;
            failConditions.add(conditions.get(0));
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiExpression findReturnedValue(@Nullable PsiMethodCallExpression call) {
        if (call == null) {
            return null;
        }
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call);
        ContractReturnValue returnValue = JavaMethodContractUtil.getNonFailingReturnValue(contracts2);
        if (returnValue == null) {
            return null;
        }
        if (returnValue.equals(ContractReturnValue.returnThis())) {
            return ExpressionUtils.getEffectiveQualifier(call.getMethodExpression());
        }
        if (returnValue instanceof ContractReturnValue.ParameterReturnValue) {
            int number = ((ContractReturnValue.ParameterReturnValue)returnValue).getParameterNumber();
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length <= number) {
                return null;
            }
            if (args.length == number + 1 && MethodCallUtils.isVarArgCall((PsiCall)call)) {
                return null;
            }
            return args[number];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/JavaMethodContractUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/JavaMethodContractUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodCallContracts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodContracts";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContractInfo";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContracts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCallContracts";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMethodContracts";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitContractAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContractInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseContracts";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findContractAnnotation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ContractInfo {
        static final ContractInfo EMPTY = new ContractInfo(Collections.emptyList(), false, false, MutationSignature.UNKNOWN);
        @NotNull
        private final List<StandardMethodContract> myContracts;
        private final boolean myPure;
        private final boolean myExplicit;
        @NotNull
        private final MutationSignature myMutationSignature;

        ContractInfo(@NotNull List<StandardMethodContract> contracts2, boolean pure, boolean explicit, @NotNull MutationSignature signature) {
            if (contracts2 == null) {
                ContractInfo.$$$reportNull$$$0(0);
            }
            if (signature == null) {
                ContractInfo.$$$reportNull$$$0(1);
            }
            this.myContracts = contracts2;
            this.myPure = pure;
            this.myExplicit = explicit;
            this.myMutationSignature = signature;
        }

        @NotNull
        List<StandardMethodContract> getContracts() {
            List<StandardMethodContract> list = this.myContracts;
            if (list == null) {
                ContractInfo.$$$reportNull$$$0(2);
            }
            return list;
        }

        boolean isPure() {
            return this.myPure;
        }

        boolean isExplicit() {
            return this.myExplicit;
        }

        @NotNull
        MutationSignature getMutationSignature() {
            MutationSignature mutationSignature = this.myMutationSignature;
            if (mutationSignature == null) {
                ContractInfo.$$$reportNull$$$0(3);
            }
            return mutationSignature;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contracts";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/JavaMethodContractUtil$ContractInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/JavaMethodContractUtil$ContractInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContracts";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMutationSignature";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

