/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.TypeUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CustomMethodHandlers {
    private static final CallMatcher CONSTANT_CALLS = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.lang.String", "contains", "indexOf", "startsWith", "endsWith", "lastIndexOf", "length", "trim", "substring", "equals", "equalsIgnoreCase", "charAt", "codePointAt", "compareTo", "replace"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterCount(1), CallMatcher.staticCall("java.lang.Math", "abs", "sqrt", "min", "max"), CallMatcher.staticCall("java.lang.Integer", "toString", "toBinaryString", "toHexString", "toOctalString", "toUnsignedString").parameterTypes("int"), CallMatcher.staticCall("java.lang.Long", "toString", "toBinaryString", "toHexString", "toOctalString", "toUnsignedString").parameterTypes("long"), CallMatcher.staticCall("java.lang.Double", "toString", "toHexString").parameterTypes("double"), CallMatcher.staticCall("java.lang.Float", "toString", "toHexString").parameterTypes("float"), CallMatcher.staticCall("java.lang.Byte", "toString").parameterTypes("byte"), CallMatcher.staticCall("java.lang.Short", "toString").parameterTypes("short"), CallMatcher.staticCall("java.lang.Boolean", "parseBoolean").parameterTypes("java.lang.String"), CallMatcher.exactInstanceCall("java.lang.Integer", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Long", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Double", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Float", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Byte", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Short", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Character", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Boolean", "toString").parameterCount(0));
    static final int MAX_STRING_CONSTANT_LENGTH_TO_TRACK = 256;
    private static final CallMapper<CustomMethodHandler> CUSTOM_METHOD_HANDLERS = new CallMapper<CustomMethodHandler>().register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "indexOf", "lastIndexOf"), (args, memState, factory, method) -> CustomMethodHandlers.indexOf(args.myQualifier, memState, factory, SpecialField.STRING_LENGTH)).register((CallMatcher)CallMatcher.instanceCall("java.util.List", "indexOf", "lastIndexOf"), (args, memState, factory, method) -> CustomMethodHandlers.indexOf(args.myQualifier, memState, factory, SpecialField.COLLECTION_SIZE)).register((CallMatcher)CallMatcher.staticCall("java.lang.Math", "abs").parameterTypes("int"), (args, memState, factory, method) -> CustomMethodHandlers.mathAbs(args.myArguments, memState, false)).register((CallMatcher)CallMatcher.staticCall("java.lang.Math", "abs").parameterTypes("long"), (args, memState, factory, method) -> CustomMethodHandlers.mathAbs(args.myArguments, memState, true)).register((CallMatcher)CallMatcher.exactInstanceCall("java.lang.String", "substring"), (args, memState, factory, method) -> CustomMethodHandlers.substring(args, memState, factory, method.getReturnType())).register(OptionalUtil.OPTIONAL_OF_NULLABLE, (args, memState, factory, method) -> SpecialField.OPTIONAL_VALUE.asDfType(memState.getDfType(args.myArguments[0]), method.getReturnType())).register((CallMatcher)CallMatcher.instanceCall("java.util.Calendar", "get").parameterTypes("int"), (args, memState, factory, method) -> CustomMethodHandlers.calendarGet(args.myArguments, memState)).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.io.InputStream", "skip").parameterTypes("long"), CallMatcher.instanceCall("java.io.Reader", "skip").parameterTypes("long")), (args, memState, factory, method) -> CustomMethodHandlers.skip(args.myArguments, memState)).register((CallMatcher)CallMatcher.staticCall("java.lang.Integer", "toHexString").parameterCount(1), (args, memState, factory, method) -> CustomMethodHandlers.numberAsString(args, memState, 4, 32)).register((CallMatcher)CallMatcher.staticCall("java.lang.Integer", "toOctalString").parameterCount(1), (args, memState, factory, method) -> CustomMethodHandlers.numberAsString(args, memState, 3, 32)).register((CallMatcher)CallMatcher.staticCall("java.lang.Integer", "toBinaryString").parameterCount(1), (args, memState, factory, method) -> CustomMethodHandlers.numberAsString(args, memState, 1, 32)).register((CallMatcher)CallMatcher.staticCall("java.lang.Long", "toHexString").parameterCount(1), (args, memState, factory, method) -> CustomMethodHandlers.numberAsString(args, memState, 4, 64)).register((CallMatcher)CallMatcher.staticCall("java.lang.Long", "toOctalString").parameterCount(1), (args, memState, factory, method) -> CustomMethodHandlers.numberAsString(args, memState, 3, 64)).register((CallMatcher)CallMatcher.staticCall("java.lang.Long", "toBinaryString").parameterCount(1), (args, memState, factory, method) -> CustomMethodHandlers.numberAsString(args, memState, 1, 64)).register((CallMatcher)CallMatcher.instanceCall("java.lang.Enum", "name").parameterCount(0), (args, memState, factory, method) -> CustomMethodHandlers.enumName(args.myQualifier, memState, method.getReturnType())).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "emptyList", "emptySet", "emptyMap").parameterCount(0), (args, memState, factory, method) -> CustomMethodHandlers.getEmptyCollectionConstant(method)).register(CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "singleton", "singletonList", "singletonMap"), CallMatcher.staticCall("java.util.List", "of"), CallMatcher.staticCall("java.util.Set", "of"), CallMatcher.staticCall("java.util.Map", "of", "ofEntries"), CallMatcher.staticCall("java.util.Arrays", "asList")), CustomMethodHandlers::collectionFactory);

    CustomMethodHandlers() {
    }

    public static CustomMethodHandler find(PsiMethod method) {
        CustomMethodHandler handler = null;
        if (CustomMethodHandlers.isConstantCall(method)) {
            handler = (arguments, state, factory, m) -> CustomMethodHandlers.handleConstantCall(arguments, state, m);
        }
        CustomMethodHandler handler2 = CUSTOM_METHOD_HANDLERS.mapFirst(method);
        return handler == null ? handler2 : handler.compose(handler2);
    }

    @Contract(value="null -> false")
    private static boolean isConstantCall(PsiMethod method) {
        return CONSTANT_CALLS.methodMatches(method);
    }

    @NotNull
    private static DfType handleConstantCall(DfaCallArguments arguments, DfaMemoryState state, PsiMethod method) {
        Object result;
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(0);
            }
            return dfType;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        Object qualifierValue = null;
        if (!method.hasModifierProperty("static") && (qualifierValue = CustomMethodHandlers.getConstantValue(state, arguments.myQualifier)) == null) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(1);
            }
            return dfType;
        }
        for (DfaValue argument : arguments.myArguments) {
            long longValue;
            Object argumentValue = CustomMethodHandlers.getConstantValue(state, argument);
            if (argumentValue == null) {
                DfType dfType = DfTypes.TOP;
                if (dfType == null) {
                    CustomMethodHandlers.$$$reportNull$$$0(2);
                }
                return dfType;
            }
            if (argumentValue instanceof Long && (longValue = ((Long)argumentValue).longValue()) >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                argumentValue = (int)longValue;
            }
            args.add(argumentValue);
        }
        Method jvmMethod = CustomMethodHandlers.toJvmMethod(method);
        if (jvmMethod == null) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(3);
            }
            return dfType;
        }
        try {
            result = jvmMethod.invoke(qualifierValue, args.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(4);
            }
            return dfType;
        }
        DfConstantType<?> dfConstantType = DfTypes.constant(result, returnType);
        if (dfConstantType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(5);
        }
        return dfConstantType;
    }

    private static Method toJvmMethod(final PsiMethod method) {
        return (Method)CachedValuesManager.getCachedValue((PsiElement)method, (CachedValueProvider)new CachedValueProvider<Method>(){

            @NotNull
            public CachedValueProvider.Result<Method> compute() {
                Method reflection = this.getMethod();
                CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)reflection, (Object[])new Object[]{method});
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                return result;
            }

            private Class<?> toJvmType(PsiType type2) {
                if (TypeUtils.isJavaLangString(type2)) {
                    return String.class;
                }
                if (TypeUtils.isJavaLangObject(type2)) {
                    return Object.class;
                }
                if (TypeUtils.typeEquals("java.lang.CharSequence", type2)) {
                    return CharSequence.class;
                }
                if (PsiType.INT.equals((Object)type2)) {
                    return Integer.TYPE;
                }
                if (PsiType.BOOLEAN.equals((Object)type2)) {
                    return Boolean.TYPE;
                }
                if (PsiType.CHAR.equals((Object)type2)) {
                    return Character.TYPE;
                }
                if (PsiType.LONG.equals((Object)type2)) {
                    return Long.TYPE;
                }
                if (PsiType.FLOAT.equals((Object)type2)) {
                    return Float.TYPE;
                }
                if (PsiType.DOUBLE.equals((Object)type2)) {
                    return Double.TYPE;
                }
                return null;
            }

            @Nullable
            private Method getMethod() {
                Class<?> containingClass;
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return null;
                }
                try {
                    containingClass = Class.forName(aClass.getQualifiedName());
                }
                catch (ClassNotFoundException ignored) {
                    return null;
                }
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                Class[] parameterTypes = new Class[parameters2.length];
                for (int i = 0; i < parameters2.length; ++i) {
                    PsiParameter parameter2 = parameters2[i];
                    PsiType type2 = parameter2.getType();
                    Class<?> jvmType = this.toJvmType(type2);
                    if (jvmType == null) {
                        return null;
                    }
                    parameterTypes[i] = jvmType;
                }
                return ReflectionUtil.getMethod(containingClass, (String)method.getName(), (Class[])parameterTypes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/CustomMethodHandlers$1", "compute"));
            }
        });
    }

    @NotNull
    private static DfType indexOf(DfaValue qualifier, DfaMemoryState memState, DfaValueFactory factory, SpecialField specialField) {
        DfaValue length = specialField.createValue(factory, qualifier);
        LongRangeSet range = DfIntType.extractRange(memState.getDfType(length));
        DfType dfType = DfTypes.intRange(LongRangeSet.range(-1L, range.max() - 1L));
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(6);
        }
        return dfType;
    }

    @NotNull
    private static DfType collectionFactory(DfaCallArguments args, DfaMemoryState memState, DfaValueFactory factory, PsiMethod method) {
        PsiType type2 = method.getReturnType();
        if (!(type2 instanceof PsiClassType)) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(7);
            }
            return dfType;
        }
        int factor = ((PsiClassType)type2).rawType().equalsToText("java.util.Map") ? 2 : 1;
        DfType size = method.isVarArgs() ? memState.getDfType(SpecialField.ARRAY_LENGTH.createValue(factory, args.myArguments[0])) : DfTypes.intValue(args.myArguments.length / factor);
        boolean asList = method.getName().equals("asList");
        Mutability mutability = asList ? Mutability.MUTABLE : Mutability.UNMODIFIABLE;
        DfType result = DfTypes.typedObject(type2, Nullability.NOT_NULL).meet(SpecialField.COLLECTION_SIZE.asDfType(size)).meet(mutability.asDfType());
        DfType dfType = asList ? result.meet(DfTypes.LOCAL_OBJECT) : result;
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(8);
        }
        return dfType;
    }

    private static DfType getEmptyCollectionConstant(PsiMethod method) {
        String fieldName = "EMPTY_" + method.getName().substring("empty".length()).toUpperCase(Locale.ROOT);
        PsiClass collectionsClass = method.getContainingClass();
        if (collectionsClass == null) {
            return DfTypes.TOP;
        }
        PsiField field = collectionsClass.findFieldByName(fieldName, false);
        if (field == null) {
            return DfTypes.TOP;
        }
        return DfTypes.constant(field, field.getType());
    }

    @NotNull
    private static DfType substring(DfaCallArguments args, DfaMemoryState state, DfaValueFactory factory, PsiType stringType) {
        if (stringType == null || !stringType.equalsToText("java.lang.String")) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(9);
            }
            return dfType;
        }
        DfaValue qualifier = args.myQualifier;
        DfaValue[] arguments = args.myArguments;
        if (arguments.length < 1 || arguments.length > 2 || arguments[0] == null) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(10);
            }
            return dfType;
        }
        DfaValue from = arguments[0];
        DfaValue lenVal = SpecialField.STRING_LENGTH.createValue(factory, qualifier);
        DfaValue to = arguments.length == 1 ? lenVal : arguments[1];
        DfaValue resultLenVal = factory.getBinOpFactory().create(to, from, state, false, JavaTokenType.MINUS);
        DfType resultLen = state.getDfType(resultLenVal);
        if (!(resultLen instanceof DfIntType)) {
            DfType dfType = DfTypes.FAIL;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(11);
            }
            return dfType;
        }
        if (!((resultLen = ((DfIntType)resultLen).meetRelation(RelationType.GE, DfTypes.intValue(0))) instanceof DfIntType)) {
            DfType dfType = DfTypes.FAIL;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(12);
            }
            return dfType;
        }
        resultLen = ((DfIntType)resultLen).meetRelation(RelationType.LE, state.getDfType(lenVal));
        DfType dfType = SpecialField.STRING_LENGTH.asDfType(resultLen, stringType);
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(13);
        }
        return dfType;
    }

    @NotNull
    private static DfType mathAbs(DfaValue[] args, DfaMemoryState memState, boolean isLong) {
        DfaValue arg = (DfaValue)ArrayUtil.getFirstElement((Object[])args);
        if (arg == null) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(14);
            }
            return dfType;
        }
        DfType type2 = memState.getDfType(arg);
        LongRangeSet range = isLong ? DfLongType.extractRange(type2) : DfIntType.extractRange(type2);
        DfType dfType = isLong ? DfTypes.longRange(range.abs(true)) : DfTypes.intRange(range.abs(false));
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(15);
        }
        return dfType;
    }

    @NotNull
    private static DfType calendarGet(DfaValue[] arguments, DfaMemoryState state) {
        if (arguments.length != 1) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(16);
            }
            return dfType;
        }
        Integer val = DfConstantType.getConstantOfType(state.getDfType(arguments[0]), Integer.class);
        if (val == null) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(17);
            }
            return dfType;
        }
        LongRangeSet range = null;
        switch (val) {
            case 5: {
                range = LongRangeSet.range(1L, 31L);
                break;
            }
            case 2: {
                range = LongRangeSet.range(0L, 12L);
                break;
            }
            case 9: {
                range = LongRangeSet.range(0L, 1L);
                break;
            }
            case 6: {
                range = LongRangeSet.range(1L, 366L);
                break;
            }
            case 10: {
                range = LongRangeSet.range(0L, 11L);
                break;
            }
            case 11: {
                range = LongRangeSet.range(0L, 23L);
                break;
            }
            case 12: 
            case 13: {
                range = LongRangeSet.range(0L, 59L);
                break;
            }
            case 14: {
                range = LongRangeSet.range(0L, 999L);
            }
        }
        DfType dfType = range == null ? DfTypes.TOP : DfTypes.intRange(range);
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(18);
        }
        return dfType;
    }

    @NotNull
    private static DfType skip(DfaValue[] arguments, DfaMemoryState state) {
        if (arguments.length != 1) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(19);
            }
            return dfType;
        }
        LongRangeSet range = DfLongType.extractRange(state.getDfType(arguments[0]));
        DfType dfType = DfTypes.longRange(LongRangeSet.range(0L, Math.max(0L, range.max())));
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(20);
        }
        return dfType;
    }

    @NotNull
    private static DfType numberAsString(DfaCallArguments args, DfaMemoryState state, int bitsPerChar, int maxBits) {
        DfaValue arg = args.myArguments[0];
        if (arg == null) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(21);
            }
            return dfType;
        }
        LongRangeSet range = DfLongType.extractRange(state.getDfType(arg));
        int usedBits = range.min() >= 0L ? 64 - Long.numberOfLeadingZeros(range.max()) : maxBits;
        int max = Math.max(1, (usedBits - 1) / bitsPerChar + 1);
        DfType dfType = SpecialField.STRING_LENGTH.asDfType(DfTypes.intRange(LongRangeSet.range(1L, max)));
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(22);
        }
        return dfType;
    }

    @NotNull
    private static DfType enumName(DfaValue qualifier, DfaMemoryState state, PsiType type2) {
        DfType dfType = state.getDfType(qualifier);
        PsiEnumConstant value2 = DfConstantType.getConstantOfType(dfType, PsiEnumConstant.class);
        if (value2 != null) {
            DfConstantType<?> dfConstantType = DfTypes.constant(value2.getName(), type2);
            if (dfConstantType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(23);
            }
            return dfConstantType;
        }
        DfType dfType2 = DfTypes.TOP;
        if (dfType2 == null) {
            CustomMethodHandlers.$$$reportNull$$$0(24);
        }
        return dfType2;
    }

    private static Object getConstantValue(DfaMemoryState memoryState, DfaValue value2) {
        DfType type2 = memoryState.getUnboxedDfType(value2);
        Object constant = DfConstantType.getConstantOfType(type2, Object.class);
        if (constant instanceof String && ((String)constant).length() > 256) {
            return null;
        }
        return constant;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/dataFlow/CustomMethodHandlers";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "handleConstantCall";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "indexOf";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectionFactory";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "substring";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "mathAbs";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calendarGet";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "skip";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "numberAsString";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "enumName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static interface CustomMethodHandler {
        @NotNull
        public DfType getMethodResult(DfaCallArguments var1, DfaMemoryState var2, DfaValueFactory var3, PsiMethod var4);

        default public CustomMethodHandler compose(CustomMethodHandler other) {
            if (other == null) {
                return this;
            }
            return (args, memState, factory, method) -> {
                DfType result = this.getMethodResult(args, memState, factory, method);
                return result == DfTypes.TOP ? other.getMethodResult(args, memState, factory, method) : result;
            };
        }
    }
}

