/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ConcurrencyAnnotationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JCiPUtil {
    private JCiPUtil() {
    }

    static boolean isJCiPAnnotation(String ref) {
        return "Immutable".equals(ref) || "GuardedBy".equals(ref) || "ThreadSafe".equals(ref) || "NotThreadSafe".equals(ref);
    }

    public static boolean isImmutable(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JCiPUtil.$$$reportNull$$$0(0);
        }
        return JCiPUtil.isImmutable(aClass, true);
    }

    public static boolean isImmutable(@NotNull PsiClass aClass, boolean checkDocComment) {
        PsiAnnotation annotation;
        if (aClass == null) {
            JCiPUtil.$$$reportNull$$$0(1);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (Collection)ConcurrencyAnnotationsManager.getInstance((Project)aClass.getProject()).getImmutableAnnotations())) != null) {
            return true;
        }
        if (checkDocComment && JCiPUtil.containsImmutableWord(aClass.getContainingFile())) {
            PsiDocComment comment = aClass.getDocComment();
            return comment != null && comment.findTagByName("@Immutable") != null;
        }
        return false;
    }

    private static boolean containsImmutableWord(PsiFile file) {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)IdIndex.hasIdentifierInFile((PsiFile)file, (String)"Immutable"), (Object[])new Object[]{file}));
    }

    @Nullable
    public static String findGuardForMember(@NotNull PsiMember member) {
        PsiDocCommentOwner commentOwner;
        PsiDocComment comment;
        List annotations;
        PsiAnnotation annotation;
        if (member == null) {
            JCiPUtil.$$$reportNull$$$0(2);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (Collection)(annotations = ConcurrencyAnnotationsManager.getInstance((Project)member.getProject()).getGuardedByAnnotations()))) != null) {
            return JCiPUtil.getGuardValue(annotation);
        }
        if (member instanceof PsiDocCommentOwner && (comment = (commentOwner = (PsiDocCommentOwner)member).getDocComment()) != null) {
            PsiDocTag[] tags = comment.getTags();
            for (int i = tags.length - 1; i >= 0; --i) {
                String value2 = JCiPUtil.getGuardValue(tags[i]);
                if (value2 == null) continue;
                return value2;
            }
        }
        return null;
    }

    static boolean isGuardedBy(@NotNull PsiMember member, @NotNull String guard) {
        List annotations;
        PsiAnnotation annotation;
        if (member == null) {
            JCiPUtil.$$$reportNull$$$0(3);
        }
        if (guard == null) {
            JCiPUtil.$$$reportNull$$$0(4);
        }
        return (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (Collection)(annotations = ConcurrencyAnnotationsManager.getInstance((Project)member.getProject()).getGuardedByAnnotations()))) != null && guard.equals(JCiPUtil.getGuardValue(annotation));
    }

    static boolean isGuardedByAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            JCiPUtil.$$$reportNull$$$0(5);
        }
        return ConcurrencyAnnotationsManager.getInstance((Project)annotation.getProject()).getGuardedByAnnotations().contains(annotation.getQualifiedName());
    }

    static boolean isGuardedByTag(PsiDocTag tag) {
        return tag.getText().startsWith("@GuardedBy");
    }

    @Nullable
    static String getGuardValue(PsiAnnotation annotation) {
        Object value2;
        PsiAnnotationMemberValue psiAnnotationMemberValue = annotation.findAttributeValue("value");
        if (psiAnnotationMemberValue instanceof PsiLiteralExpression && (value2 = ((PsiLiteralExpression)psiAnnotationMemberValue).getValue()) instanceof String) {
            return JCiPUtil.resolveItself((String)value2, (PsiElement)annotation);
        }
        return null;
    }

    @Nullable
    static String getGuardValue(PsiDocTag tag) {
        int end;
        if ("GuardedBy".equals(tag.getName())) {
            PsiDocTagValue value2 = tag.getValueElement();
            if (value2 == null) {
                return "";
            }
            return JCiPUtil.resolveItself(value2.getText(), (PsiElement)tag);
        }
        String text2 = tag.getText();
        if (!text2.startsWith("@GuardedBy")) {
            return null;
        }
        int start = text2.indexOf(40);
        if (start >= (end = text2.indexOf(41)) || start < 0) {
            return "";
        }
        return JCiPUtil.resolveItself(text2.substring(start + 1, end), (PsiElement)tag);
    }

    private static String resolveItself(String value2, PsiElement context) {
        if ("itself".equals(value2)) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMember.class);
            if (!(member instanceof PsiField)) {
                return "itself";
            }
            return member.getName();
        }
        return value2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guard";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/concurrencyAnnotations/JCiPUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImmutable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findGuardForMember";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isGuardedBy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isGuardedByAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

