/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytecodeAnalysisConverter {
    @Nullable
    public static EKey psiKey(@NotNull PsiMember psiMethod, @NotNull Direction direction) {
        PsiClass psiClass;
        if (psiMethod == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(0);
        }
        if (direction == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(1);
        }
        if ((psiClass = psiMethod.getContainingClass()) != null) {
            String sig;
            String className2 = BytecodeAnalysisConverter.descriptor(psiClass, 0, false);
            String name2 = psiMethod.getName();
            if (psiMethod instanceof PsiMethod) {
                sig = BytecodeAnalysisConverter.methodSignature((PsiMethod)psiMethod, psiClass);
                if (((PsiMethod)psiMethod).isConstructor()) {
                    name2 = "<init>";
                }
            } else if (psiMethod instanceof PsiField) {
                sig = BytecodeAnalysisConverter.descriptor(((PsiField)psiMethod).getType());
            } else {
                return null;
            }
            if (className2 != null && sig != null && name2 != null) {
                return new EKey((MemberDescriptor)new Member(className2, name2, sig), direction, true, false);
            }
        }
        return null;
    }

    @Nullable
    private static String methodSignature(@NotNull PsiMethod psiMethod, @NotNull PsiClass psiClass) {
        PsiClass outerClass;
        if (psiMethod == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(2);
        }
        if (psiClass == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(3);
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        if (psiMethod.isConstructor() && !psiClass.hasModifierProperty("static") && (outerClass = psiClass.getContainingClass()) != null) {
            String desc = BytecodeAnalysisConverter.descriptor(outerClass, 0, true);
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        for (PsiClass parameter2 : psiMethod.getParameterList().getParameters()) {
            String desc = BytecodeAnalysisConverter.descriptor(parameter2.getType());
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        sb.append(')');
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null) {
            sb.append('V');
        } else {
            String desc = BytecodeAnalysisConverter.descriptor(returnType);
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        return sb.toString();
    }

    @Nullable
    private static String descriptor(@NotNull PsiClass psiClass, int dimensions, boolean full) {
        PsiFile containingFile;
        if (psiClass == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(4);
        }
        if (!((containingFile = psiClass.getContainingFile()) instanceof PsiClassOwner)) {
            ProjectBytecodeAnalysis.LOG.debug("containingFile was not resolved for " + psiClass.getQualifiedName());
            return null;
        }
        PsiClassOwner psiFile = (PsiClassOwner)containingFile;
        String packageName = psiFile.getPackageName();
        String qname = psiClass.getQualifiedName();
        if (qname == null) {
            return null;
        }
        String className2 = packageName.length() > 0 ? qname.substring(packageName.length() + 1).replace('.', '$') : qname.replace('.', '$');
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dimensions; ++i) {
            sb.append('[');
        }
        if (full) {
            sb.append('L');
        }
        if (packageName.length() > 0) {
            sb.append(packageName.replace('.', '/'));
            sb.append('/');
        }
        sb.append(className2);
        if (full) {
            sb.append(';');
        }
        return sb.toString();
    }

    @Nullable
    private static String descriptor(@NotNull PsiType psiType) {
        if (psiType == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(5);
        }
        int dimensions = 0;
        if ((psiType = TypeConversionUtil.erasure((PsiType)psiType)) instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)psiType;
            psiType = arrayType.getDeepComponentType();
            dimensions = arrayType.getArrayDimensions();
        }
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass != null) {
                return BytecodeAnalysisConverter.descriptor(psiClass, dimensions, true);
            }
            ProjectBytecodeAnalysis.LOG.debug("resolve was null for " + psiType.getCanonicalText());
            return null;
        }
        if (psiType instanceof PsiPrimitiveType) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < dimensions; ++i) {
                sb.append('[');
            }
            if (PsiType.VOID.equals((Object)psiType)) {
                sb.append('V');
            } else if (PsiType.BOOLEAN.equals((Object)psiType)) {
                sb.append('Z');
            } else if (PsiType.CHAR.equals((Object)psiType)) {
                sb.append('C');
            } else if (PsiType.BYTE.equals((Object)psiType)) {
                sb.append('B');
            } else if (PsiType.SHORT.equals((Object)psiType)) {
                sb.append('S');
            } else if (PsiType.INT.equals((Object)psiType)) {
                sb.append('I');
            } else if (PsiType.FLOAT.equals((Object)psiType)) {
                sb.append('F');
            } else if (PsiType.LONG.equals((Object)psiType)) {
                sb.append('J');
            } else if (PsiType.DOUBLE.equals((Object)psiType)) {
                sb.append('D');
            }
            return sb.toString();
        }
        return null;
    }

    @NotNull
    public static ArrayList<EKey> mkInOutKeys(@NotNull PsiMethod psiMethod, @NotNull EKey primaryKey) {
        if (psiMethod == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(6);
        }
        if (primaryKey == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(7);
        }
        PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
        ArrayList<EKey> keys = new ArrayList<EKey>(parameters2.length * 2 + 2);
        keys.add(primaryKey);
        for (int i = 0; i < parameters2.length; ++i) {
            if (!(parameters2[i].getType() instanceof PsiPrimitiveType)) {
                keys.add(primaryKey.withDirection(new Direction.InOut(i, Value.NotNull)));
                keys.add(primaryKey.withDirection(new Direction.InOut(i, Value.Null)));
                keys.add(primaryKey.withDirection(new Direction.InThrow(i, Value.NotNull)));
                keys.add(primaryKey.withDirection(new Direction.InThrow(i, Value.Null)));
                continue;
            }
            if (!PsiType.BOOLEAN.equals((Object)parameters2[i].getType())) continue;
            keys.add(primaryKey.withDirection(new Direction.InOut(i, Value.True)));
            keys.add(primaryKey.withDirection(new Direction.InOut(i, Value.False)));
            keys.add(primaryKey.withDirection(new Direction.InThrow(i, Value.True)));
            keys.add(primaryKey.withDirection(new Direction.InThrow(i, Value.False)));
        }
        ArrayList<EKey> arrayList = keys;
        if (arrayList == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static void addEffectAnnotations(Map<EKey, Effects> puritySolutions, MethodAnnotations result, EKey methodKey, boolean constructor) {
        for (Map.Entry<EKey, Effects> entry : puritySolutions.entrySet()) {
            EKey key2 = entry.getKey().mkStable();
            EKey baseKey = key2.mkBase();
            if (!methodKey.equals(baseKey)) continue;
            result.returnValue = entry.getValue().returnValue;
            Set<EffectQuantum> effects = entry.getValue().effects;
            if (!effects.isEmpty() && (!constructor || effects.size() != 1 || !effects.contains(EffectQuantum.ThisChangeQuantum))) continue;
            result.pures.add(methodKey);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryKey";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mkInOutKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "psiKey";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "methodSignature";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "descriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mkInOutKeys";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

