/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AnnotatedApiUsageUtil;
import com.intellij.codeInspection.AnnotatedContainingDeclaration;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PropertyUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInspection/UnstableTypeUsedInSignatureVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "unstableApiAnnotations", "", "", "(Lcom/intellij/codeInspection/ProblemsHolder;Ljava/util/List;)V", "isAccessibleDeclaration", "", "node", "Lorg/jetbrains/uast/UDeclaration;", "isInsideUnstableDeclaration", "visitDeclaration", "intellij.jvm.analysis.impl"})
final class UnstableTypeUsedInSignatureVisitor
extends AbstractUastNonRecursiveVisitor {
    private final ProblemsHolder problemsHolder;
    private final List<String> unstableApiAnnotations;

    public boolean visitDeclaration(@NotNull UDeclaration node) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (!(node instanceof UClass || node instanceof UMethod || node instanceof UField)) {
            return false;
        }
        if (!this.isAccessibleDeclaration(node) || this.isInsideUnstableDeclaration(node)) {
            return true;
        }
        AnnotatedContainingDeclaration annotatedContainingDeclaration = AnnotatedApiUsageUtil.INSTANCE.findAnnotatedTypeUsedInDeclarationSignature(node, (Collection<String>)this.unstableApiAnnotations);
        if (annotatedContainingDeclaration == null) {
            return true;
        }
        AnnotatedContainingDeclaration annotatedTypeUsedInSignature = annotatedContainingDeclaration;
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)node.getUastAnchor());
        if (psiElement == null) {
            return true;
        }
        PsiElement elementToHighlight = psiElement;
        PsiModifierListOwner psiModifierListOwner = annotatedTypeUsedInSignature.getTarget();
        if (!(psiModifierListOwner instanceof PsiClass)) {
            psiModifierListOwner = null;
        }
        if ((object = (PsiClass)psiModifierListOwner) == null || (object = object.getQualifiedName()) == null) {
            return true;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"(annotatedTypeUsedInSign\u2026lifiedName ?: return true");
        Object typeName = object;
        String string = annotatedTypeUsedInSignature.getPsiAnnotation().getQualifiedName();
        if (string == null) {
            return true;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"annotatedTypeUsedInSigna\u2026lifiedName ?: return true");
        String annotationName = string;
        UDeclaration uDeclaration = node;
        String message2 = uDeclaration instanceof UMethod ? JvmAnalysisBundle.message("jvm.inspections.unstable.type.used.in.method.signature.description", annotationName, typeName) : (uDeclaration instanceof UField ? JvmAnalysisBundle.message("jvm.inspections.unstable.type.used.in.field.signature.description", annotationName, typeName) : JvmAnalysisBundle.message("jvm.inspections.unstable.type.used.in.class.signature.description", annotationName, typeName));
        this.problemsHolder.registerProblem(elementToHighlight, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        return true;
    }

    private final boolean isAccessibleDeclaration(UDeclaration node) {
        if (node.getVisibility() == UastVisibility.PRIVATE || node.getVisibility() == UastVisibility.PACKAGE_LOCAL) {
            PsiElement psiField;
            if (node instanceof UField && (psiField = node.getJavaPsi()) instanceof PsiField) {
                PsiMethod psiMethod = PropertyUtil.findGetterForField((PsiField)((PsiField)psiField));
                UMethod getter = psiMethod != null ? (UMethod)UastContextKt.toUElement((PsiElement)((PsiElement)psiMethod), UMethod.class) : null;
                PsiMethod psiMethod2 = PropertyUtil.findSetterForField((PsiField)((PsiField)psiField));
                UMethod setter = psiMethod2 != null ? (UMethod)UastContextKt.toUElement((PsiElement)((PsiElement)psiMethod2), UMethod.class) : null;
                return getter != null && this.isAccessibleDeclaration((UDeclaration)getter) || setter != null && this.isAccessibleDeclaration((UDeclaration)setter);
            }
            return false;
        }
        UElement $this$getParentOfType$iv = (UElement)node;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UDeclaration containingDeclaration = (UDeclaration)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UDeclaration.class, (boolean)strict$iv);
        if (containingDeclaration != null) {
            return this.isAccessibleDeclaration(containingDeclaration);
        }
        return true;
    }

    private final boolean isInsideUnstableDeclaration(UDeclaration node) {
        boolean bl;
        block10: {
            Iterable $this$any$iv = node.getUAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UAnnotation it = (UAnnotation)element$iv;
                    boolean bl2 = false;
                    if (!CollectionsKt.contains((Iterable)this.unstableApiAnnotations, (Object)it.getQualifiedName())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        UClass containingClass = UastUtils.getContainingUClass((UElement)((UElement)node));
        if (containingClass != null) {
            return this.isInsideUnstableDeclaration((UDeclaration)containingClass);
        }
        UFile containingUFile = UastUtils.getContainingUFile((UElement)((UElement)node));
        if (containingUFile != null) {
            String packageName = containingUFile.getPackageName();
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.problemsHolder.getProject()).findPackage(packageName);
            if (psiPackage != null) {
                boolean bl3;
                block11: {
                    Iterable $this$any$iv = this.unstableApiAnnotations;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl4 = false;
                            if (!psiPackage.hasAnnotation(it)) continue;
                            bl3 = true;
                            break block11;
                        }
                        bl3 = false;
                    }
                }
                return bl3;
            }
        }
        return false;
    }

    public UnstableTypeUsedInSignatureVisitor(@NotNull ProblemsHolder problemsHolder, @NotNull List<String> unstableApiAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)problemsHolder, (String)"problemsHolder");
        Intrinsics.checkParameterIsNotNull(unstableApiAnnotations, (String)"unstableApiAnnotations");
        this.problemsHolder = problemsHolder;
        this.unstableApiAnnotations = unstableApiAnnotations;
    }
}

