/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AnnotatedApiUsageUtil;
import com.intellij.codeInspection.AnnotatedContainingDeclaration;
import com.intellij.codeInspection.DefaultUnstableApiUsageMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UnstableApiUsageMessageProvider;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J,\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\"H\u0016J\"\u0010*\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010+\u001a\u0004\u0018\u00010,H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/codeInspection/UnstableApiUsageProcessor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "ignoreInsideImports", "", "unstableApiAnnotations", "", "", "knownAnnotationMessageProviders", "", "Lcom/intellij/codeInspection/UnstableApiUsageMessageProvider;", "(Lcom/intellij/codeInspection/ProblemsHolder;ZLjava/util/List;Ljava/util/Map;)V", "arePsiElementsFromTheSameFile", "one", "Lcom/intellij/psi/PsiElement;", "two", "checkTargetIsUnstableItself", "target", "Lcom/intellij/psi/PsiModifierListOwner;", "sourceNode", "Lorg/jetbrains/uast/UElement;", "isMethodOverriding", "checkTargetReferencesUnstableTypeInSignature", "", "checkUnstableApiUsage", "getElementToHighlight", "getMessageProvider", "psiAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "processConstructorInvocation", "instantiatedClass", "Lcom/intellij/psi/PsiClass;", "constructor", "Lcom/intellij/psi/PsiMethod;", "subclassDeclaration", "Lorg/jetbrains/uast/UClass;", "processImportReference", "processMethodOverriding", "method", "Lorg/jetbrains/uast/UMethod;", "overriddenMethod", "processReference", "qualifier", "Lorg/jetbrains/uast/UExpression;", "Companion", "intellij.jvm.analysis.impl"})
final class UnstableApiUsageProcessor
implements ApiUsageProcessor {
    private final ProblemsHolder problemsHolder;
    private final boolean ignoreInsideImports;
    private final List<String> unstableApiAnnotations;
    private final Map<String, UnstableApiUsageMessageProvider> knownAnnotationMessageProviders;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    @Override
    public void processImportReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target) {
        Intrinsics.checkParameterIsNotNull((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (!this.ignoreInsideImports) {
            this.checkUnstableApiUsage(target, sourceNode, false);
        }
    }

    @Override
    public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
        Intrinsics.checkParameterIsNotNull((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.checkUnstableApiUsage(target, sourceNode, false);
    }

    @Override
    public void processConstructorInvocation(@NotNull UElement sourceNode, @NotNull PsiClass instantiatedClass, @Nullable PsiMethod constructor, @Nullable UClass subclassDeclaration) {
        Intrinsics.checkParameterIsNotNull((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkParameterIsNotNull((Object)instantiatedClass, (String)"instantiatedClass");
        if (constructor != null) {
            this.checkUnstableApiUsage((PsiModifierListOwner)constructor, sourceNode, false);
        }
    }

    @Override
    public void processMethodOverriding(@NotNull UMethod method, @NotNull PsiMethod overriddenMethod) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)overriddenMethod, (String)"overriddenMethod");
        this.checkUnstableApiUsage((PsiModifierListOwner)overriddenMethod, (UElement)method, true);
    }

    private final UnstableApiUsageMessageProvider getMessageProvider(PsiAnnotation psiAnnotation) {
        String string = psiAnnotation.getQualifiedName();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"psiAnnotation.qualifiedName ?: return null");
        String annotationName = string;
        UnstableApiUsageMessageProvider unstableApiUsageMessageProvider = this.knownAnnotationMessageProviders.get(annotationName);
        if (unstableApiUsageMessageProvider == null) {
            unstableApiUsageMessageProvider = DefaultUnstableApiUsageMessageProvider.INSTANCE;
        }
        return unstableApiUsageMessageProvider;
    }

    private final PsiElement getElementToHighlight(UElement sourceNode) {
        UElement uElement = sourceNode;
        if (!(uElement instanceof UDeclaration)) {
            uElement = null;
        }
        UDeclaration uDeclaration = (UDeclaration)uElement;
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)(uDeclaration != null ? uDeclaration.getUastAnchor() : null));
        if (psiElement == null) {
            psiElement = sourceNode.getSourcePsi();
        }
        return psiElement;
    }

    private final void checkUnstableApiUsage(PsiModifierListOwner target, UElement sourceNode, boolean isMethodOverriding) {
        if (!Companion.isLibraryElement((PsiElement)target)) {
            return;
        }
        if (this.checkTargetIsUnstableItself(target, sourceNode, isMethodOverriding)) {
            return;
        }
        this.checkTargetReferencesUnstableTypeInSignature(target, sourceNode, isMethodOverriding);
    }

    private final boolean checkTargetIsUnstableItself(PsiModifierListOwner target, UElement sourceNode, boolean isMethodOverriding) {
        AnnotatedContainingDeclaration annotatedContainingDeclaration = AnnotatedApiUsageUtil.findAnnotatedContainingDeclaration$default(AnnotatedApiUsageUtil.INSTANCE, target, this.unstableApiAnnotations, true, null, 8, null);
        if (annotatedContainingDeclaration != null) {
            UnstableApiUsageMessageProvider unstableApiUsageMessageProvider = this.getMessageProvider(annotatedContainingDeclaration.getPsiAnnotation());
            if (unstableApiUsageMessageProvider == null) {
                return false;
            }
            UnstableApiUsageMessageProvider messageProvider = unstableApiUsageMessageProvider;
            String message2 = isMethodOverriding ? messageProvider.buildMessageUnstableMethodOverridden(annotatedContainingDeclaration) : messageProvider.buildMessage(annotatedContainingDeclaration);
            PsiElement psiElement = this.getElementToHighlight(sourceNode);
            if (psiElement == null) {
                return false;
            }
            PsiElement elementToHighlight = psiElement;
            this.problemsHolder.registerProblem(elementToHighlight, message2, messageProvider.getProblemHighlightType(), new LocalQuickFix[0]);
            return true;
        }
        return false;
    }

    private final void checkTargetReferencesUnstableTypeInSignature(PsiModifierListOwner target, UElement sourceNode, boolean isMethodOverriding) {
        if (!isMethodOverriding && !this.arePsiElementsFromTheSameFile(sourceNode.getSourcePsi(), (PsiElement)target.getContainingFile())) {
            UDeclaration declaration2 = (UDeclaration)UastContextKt.toUElement((PsiElement)((PsiElement)target), UDeclaration.class);
            if (!(declaration2 instanceof UClass || declaration2 instanceof UMethod || declaration2 instanceof UField)) {
                return;
            }
            AnnotatedContainingDeclaration unstableTypeUsedInSignature = AnnotatedApiUsageUtil.INSTANCE.findAnnotatedTypeUsedInDeclarationSignature(declaration2, (Collection<String>)this.unstableApiAnnotations);
            if (unstableTypeUsedInSignature != null) {
                UnstableApiUsageMessageProvider unstableApiUsageMessageProvider = this.getMessageProvider(unstableTypeUsedInSignature.getPsiAnnotation());
                if (unstableApiUsageMessageProvider == null) {
                    return;
                }
                UnstableApiUsageMessageProvider messageProvider = unstableApiUsageMessageProvider;
                String message2 = messageProvider.buildMessageUnstableTypeIsUsedInSignatureOfReferencedApi(target, unstableTypeUsedInSignature);
                PsiElement psiElement = this.getElementToHighlight(sourceNode);
                if (psiElement == null) {
                    return;
                }
                PsiElement elementToHighlight = psiElement;
                this.problemsHolder.registerProblem(elementToHighlight, message2, messageProvider.getProblemHighlightType(), new LocalQuickFix[0]);
            }
        }
    }

    private final boolean arePsiElementsFromTheSameFile(PsiElement one, PsiElement two) {
        PsiElement psiElement;
        PsiElement psiElement2 = one;
        return Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getContainingFile()) != null ? psiElement2.getVirtualFile() : null), (psiElement = two) != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null);
    }

    public UnstableApiUsageProcessor(@NotNull ProblemsHolder problemsHolder, boolean ignoreInsideImports, @NotNull List<String> unstableApiAnnotations, @NotNull Map<String, ? extends UnstableApiUsageMessageProvider> knownAnnotationMessageProviders) {
        Intrinsics.checkParameterIsNotNull((Object)problemsHolder, (String)"problemsHolder");
        Intrinsics.checkParameterIsNotNull(unstableApiAnnotations, (String)"unstableApiAnnotations");
        Intrinsics.checkParameterIsNotNull(knownAnnotationMessageProviders, (String)"knownAnnotationMessageProviders");
        this.problemsHolder = problemsHolder;
        this.ignoreInsideImports = ignoreInsideImports;
        this.unstableApiAnnotations = unstableApiAnnotations;
        this.knownAnnotationMessageProviders = knownAnnotationMessageProviders;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInspection/UnstableApiUsageProcessor$Companion;", "", "()V", "isLibraryElement", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.jvm.analysis.impl"})
    private static final class Companion {
        public final boolean isLibraryElement(@NotNull PsiElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                return true;
            }
            VirtualFile containingVirtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            return containingVirtualFile != null && ProjectFileIndex.getInstance((Project)element.getProject()).isInLibraryClasses(containingVirtualFile);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

