/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PatternVariableCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PatternVariableCanBeUsedInspection.$$$reportNull$$$0(0);
        }
        if (!HighlightUtil.Feature.PATTERNS.isAvailable((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PatternVariableCanBeUsedInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitLocalVariable(PsiLocalVariable variable) {
                PsiIdentifier identifier = variable.getNameIdentifier();
                if (identifier == null) {
                    return;
                }
                PsiTypeCastExpression cast = (PsiTypeCastExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()), PsiTypeCastExpression.class);
                if (cast == null || cast.getOperand() == null || cast.getCastType() == null) {
                    return;
                }
                PsiType castType = cast.getCastType().getType();
                if (castType instanceof PsiPrimitiveType) {
                    return;
                }
                if (!variable.getType().equals(castType)) {
                    return;
                }
                PsiElement scope = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
                if (scope == null) {
                    return;
                }
                PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)variable.getParent(), PsiDeclarationStatement.class);
                if (declaration2 == null) {
                    return;
                }
                if (!variable.hasModifierProperty("final") && !HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, scope, null)) {
                    return;
                }
                PsiInstanceOfExpression instanceOf = InstanceOfUtils.findPatternCandidate(cast);
                if (instanceOf != null) {
                    String name2 = identifier.getText();
                    holder.registerProblem((PsiElement)identifier, InspectionGadgetsBundle.message("inspection.pattern.variable.can.be.used.message", name2), new LocalQuickFix[]{new PatternVariableCanBeUsedFix(name2, instanceOf)});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PatternVariableCanBeUsedFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiInstanceOfExpression> myInstanceOfPointer;
        private final String myName;

        public PatternVariableCanBeUsedFix(@NotNull String name2, @NotNull PsiInstanceOfExpression instanceOf) {
            if (name2 == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(0);
            }
            if (instanceOf == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(1);
            }
            this.myName = name2;
            this.myInstanceOfPointer = SmartPointerManager.createPointer((PsiElement)instanceOf);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("inspection.pattern.variable.can.be.used.fix.name", this.myName);
            if (string == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.pattern.variable.can.be.used.fix.family.name", new Object[0]);
            if (string == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiLocalVariable variable;
            if (project == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(5);
            }
            if ((variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiLocalVariable.class)) == null) {
                return;
            }
            PsiTypeCastExpression cast = (PsiTypeCastExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()), PsiTypeCastExpression.class);
            if (cast == null) {
                return;
            }
            PsiTypeElement typeElement = cast.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)this.myInstanceOfPointer.getElement();
            if (instanceOf == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            ct.replace((PsiElement)instanceOf, ct.text((PsiElement)instanceOf.getOperand()) + " instanceof " + typeElement.getText() + " " + variable.getName());
            ct.deleteAndRestoreComments((PsiElement)variable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instanceOf";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection$PatternVariableCanBeUsedFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection$PatternVariableCanBeUsedFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

