/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInspection/OverrideOnlyInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "OverrideOnlyProcessor", "intellij.jvm.analysis.impl"})
public final class OverrideOnlyInspection
extends LocalInspectionTool {
    @NotNull
    private static final String ANNOTATION_NAME;
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)holder.getProject());
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"holder.file");
        if (javaPsiFacade.findClass(ANNOTATION_NAME, psiFile.getResolveScope()) != null) {
            psiElementVisitor = ApiUsageUastVisitor.Companion.createPsiElementVisitor(new OverrideOnlyProcessor(holder));
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            psiElementVisitor = psiElementVisitor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementVisitor2, (String)"PsiElementVisitor.EMPTY_VISITOR");
        }
        return psiElementVisitor;
    }

    static {
        Companion = new Companion(null);
        String string = ApiStatus.OverrideOnly.class.getCanonicalName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        ANNOTATION_NAME = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInspection/OverrideOnlyInspection$OverrideOnlyProcessor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "isLibraryElement", "", "element", "Lcom/intellij/psi/PsiElement;", "isOverrideOnlyMethod", "method", "Lcom/intellij/psi/PsiMethod;", "processReference", "", "sourceNode", "Lorg/jetbrains/uast/UElement;", "target", "Lcom/intellij/psi/PsiModifierListOwner;", "qualifier", "Lorg/jetbrains/uast/UExpression;", "intellij.jvm.analysis.impl"})
    private static final class OverrideOnlyProcessor
    implements ApiUsageProcessor {
        private final ProblemsHolder problemsHolder;

        private final boolean isLibraryElement(PsiElement element) {
            VirtualFile containingVirtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            return containingVirtualFile != null && ProjectFileIndex.getInstance((Project)element.getProject()).isInLibraryClasses(containingVirtualFile);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isOverrideOnlyMethod(PsiMethod method) {
            if (method.hasAnnotation(Companion.getANNOTATION_NAME())) return true;
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) return false;
            if (!psiClass.hasAnnotation(Companion.getANNOTATION_NAME())) return false;
            return true;
        }

        @Override
        public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
            Intrinsics.checkParameterIsNotNull((Object)sourceNode, (String)"sourceNode");
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            if (target instanceof PsiMethod && this.isOverrideOnlyMethod((PsiMethod)target) && this.isLibraryElement((PsiElement)target)) {
                PsiElement psiElement = sourceNode.getSourcePsi();
                if (psiElement == null) {
                    return;
                }
                PsiElement elementToHighlight = psiElement;
                String string = HighlightMessageUtil.getSymbolName((PsiElement)target);
                if (string == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HighlightMessageUtil.get\u2026bolName(target) ?: return");
                String methodName = string;
                String description = JvmAnalysisBundle.message("jvm.inspections.api.override.only.description", methodName);
                this.problemsHolder.registerProblem(elementToHighlight, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }

        public OverrideOnlyProcessor(@NotNull ProblemsHolder problemsHolder) {
            Intrinsics.checkParameterIsNotNull((Object)problemsHolder, (String)"problemsHolder");
            this.problemsHolder = problemsHolder;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInspection/OverrideOnlyInspection$Companion;", "", "()V", "ANNOTATION_NAME", "", "getANNOTATION_NAME", "()Ljava/lang/String;", "intellij.jvm.analysis.impl"})
    private static final class Companion {
        @NotNull
        public final String getANNOTATION_NAME() {
            return ANNOTATION_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

