/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.CommandLineInspectionProgressReporter;
import com.intellij.codeInspection.CommandLineInspectionProjectConfigurator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaCommandLineInspectionProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    public boolean isApplicable(@NotNull Path projectPath, @NotNull CommandLineInspectionProgressReporter logger) {
        if (projectPath == null) {
            JavaCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            JavaCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(1);
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List sdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        if (!sdks.isEmpty()) {
            return false;
        }
        try {
            boolean hasAnyJavaFiles = Files.walk(projectPath, new FileVisitOption[0]).anyMatch(f -> f.toString().endsWith(".java") || f.toString().endsWith(".kt"));
            if (!hasAnyJavaFiles) {
                logger.reportMessage(3, "Skipping JDK autodetection because the project doesn't contain any Java files");
            }
            return hasAnyJavaFiles;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void configureEnvironment(@NotNull Path projectPath, @NotNull CommandLineInspectionProgressReporter logger) {
        if (projectPath == null) {
            JavaCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(2);
        }
        if (logger == null) {
            JavaCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(3);
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List sdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        if (!sdks.isEmpty()) {
            return;
        }
        Collection homePaths = javaSdk.suggestHomePaths();
        EnumSet<JavaSdkVersion> existingVersions = EnumSet.noneOf(JavaSdkVersion.class);
        for (String path : homePaths) {
            JavaSdkVersion version;
            String jdkVersion = javaSdk.getVersionString(path);
            if (jdkVersion == null || existingVersions.contains(version = JavaSdkVersion.fromVersionString((String)jdkVersion))) continue;
            existingVersions.add(version);
            String name2 = javaSdk.suggestSdkName(null, path);
            logger.reportMessage(2, "Detected JDK with name " + name2 + " at " + path);
            Sdk jdk = javaSdk.createJdk(name2, path, false);
            ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(jdk));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/JavaCommandLineInspectionProjectConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "configureEnvironment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

