/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.IndexedContainer;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExplicitArrayFillingInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ExplicitArrayFillingInspection.class);
    public boolean mySuggestSetAll = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaBundle.message((String)"inspection.explicit.array.filling.suggest.set.all", (Object[])new Object[0]), (InspectionProfileEntry)this, "mySuggestSetAll");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ExplicitArrayFillingInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitForStatement(PsiForStatement statement) {
                super.visitForStatement(statement);
                CountingLoop loop = CountingLoop.from(statement);
                if (loop == null || loop.isIncluding() || loop.isDescending()) {
                    return;
                }
                if (!ExpressionUtils.isZero(loop.getInitializer())) {
                    return;
                }
                IndexedContainer container = IndexedContainer.fromLengthExpression(loop.getBound());
                if (container == null || !(container.getQualifier().getType() instanceof PsiArrayType)) {
                    return;
                }
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)ControlFlowUtils.stripBraces(statement.getBody()));
                if (assignment == null) {
                    return;
                }
                PsiExpression index = container.extractIndexFromGetExpression(assignment.getLExpression());
                if (!ExpressionUtils.isReferenceTo(index, (PsiVariable)loop.getCounter())) {
                    return;
                }
                PsiExpression rValue = assignment.getRExpression();
                if (rValue == null) {
                    return;
                }
                if (!this.isChangedInLoop(loop, rValue)) {
                    PsiType lType = container.getElementType();
                    Object defaultValue = PsiTypesUtil.getDefaultValue((PsiType)lType);
                    if (this.isDefaultValue(rValue, defaultValue, lType) && this.isFilledWithDefaultValues(container.getQualifier(), statement, defaultValue)) {
                        holder.registerProblem((PsiElement)statement, this.getRange(statement, ProblemHighlightType.WARNING), JavaBundle.message((String)"inspection.explicit.array.filling.redundant.loop.description", (Object[])new Object[0]), new LocalQuickFix[]{QuickFixFactory.getInstance().createDeleteFix((PsiElement)statement, CommonQuickFixBundle.message((String)"fix.remove.statement", (Object[])new Object[]{"for"}))});
                        return;
                    }
                    this.registerProblem(statement, false);
                    return;
                }
                if (!JavaFeature.ADVANCED_COLLECTIONS_API.isFeatureSupported(holder.getFile())) {
                    return;
                }
                if (!StreamApiUtil.isSupportedStreamElement(container.getElementType())) {
                    return;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)rValue, Predicate.isEqual(loop.getCounter()))) {
                    return;
                }
                this.registerProblem(statement, true);
            }

            private boolean isChangedInLoop(@NotNull CountingLoop loop, @NotNull PsiExpression rValue) {
                if (loop == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rValue == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (VariableAccessUtils.collectUsedVariables((PsiElement)rValue).contains(loop.getCounter()) || SideEffectChecker.mayHaveSideEffects(rValue)) {
                    return true;
                }
                return ExpressionUtils.nonStructuralChildren(rValue).filter(c -> c instanceof PsiCallExpression).anyMatch(call -> !ClassUtils.isImmutable(call.getType()) && !ConstructionUtils.isEmptyArrayInitializer(call));
            }

            private boolean isDefaultValue(@NotNull PsiExpression expression2, @Nullable Object defaultValue, @Nullable PsiType lType) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (ExpressionUtils.isNullLiteral(expression2) && defaultValue == null) {
                    return true;
                }
                Object constantValue = ExpressionUtils.computeConstantExpression(expression2);
                PsiType rType = expression2.getType();
                if (rType instanceof PsiPrimitiveType && lType instanceof PsiPrimitiveType && defaultValue instanceof Number && constantValue instanceof Number) {
                    return ((Number)defaultValue).doubleValue() == ((Number)constantValue).doubleValue();
                }
                return constantValue != null && constantValue.equals(defaultValue);
            }

            private boolean isFilledWithDefaultValues(@NotNull PsiExpression expression2, @NotNull PsiForStatement statement, @Nullable Object defaultValue) {
                PsiReferenceExpression arrayRef;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (statement == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((arrayRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiReferenceExpression.class)) == null) {
                    return false;
                }
                PsiVariable arrayVar = (PsiVariable)ObjectUtils.tryCast((Object)arrayRef.resolve(), PsiVariable.class);
                if (arrayVar == null) {
                    return false;
                }
                PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)PsiUtil.getVariableCodeBlock((PsiVariable)arrayVar, null), PsiCodeBlock.class);
                if (block == null) {
                    return false;
                }
                ControlFlow flow = this.createControlFlow(block);
                if (flow == null) {
                    return false;
                }
                int statementStart = flow.getStartOffset((PsiElement)statement);
                if (statementStart == -1) {
                    return false;
                }
                int statementEnd = flow.getEndOffset((PsiElement)statement);
                if (statementEnd == -1) {
                    return false;
                }
                PsiElement[] defs = this.getDefs(block, arrayVar, arrayRef, defaultValue);
                if (defs == null) {
                    return false;
                }
                Set<Integer> exclude = this.getDefsOffsets(flow, defs);
                if (exclude == null) {
                    return false;
                }
                for (int i = statementStart; i < statementEnd; ++i) {
                    exclude.add(i);
                }
                return Arrays.stream(defs).map(def -> flow.getEndOffset((PsiElement)def)).noneMatch(offset -> ControlFlowUtils.isVariableReferencedBeforeStatementEntry(flow, offset + 1, (PsiStatement)statement, arrayVar, exclude));
            }

            @Nullable
            private ControlFlow createControlFlow(@NotNull PsiCodeBlock block) {
                if (block == null) {
                    1.$$$reportNull$$$0(5);
                }
                try {
                    return ControlFlowFactory.getInstance(block.getProject()).getControlFlow((PsiElement)block, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                }
                catch (AnalysisCanceledException ignored) {
                    return null;
                }
            }

            private PsiElement @Nullable [] getDefs(@NotNull PsiCodeBlock block, @NotNull PsiVariable arrayVar, @NotNull PsiReferenceExpression arrayRef, @Nullable Object defaultValue) {
                if (block == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (arrayVar == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (arrayRef == null) {
                    1.$$$reportNull$$$0(8);
                }
                PsiElement[] defs = DefUseUtil.getDefs(block, arrayVar, (PsiElement)arrayRef);
                PsiExpression[] expressions2 = new PsiExpression[defs.length];
                for (int i = 0; i < defs.length; ++i) {
                    PsiElement def = defs[i];
                    PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)def, PsiVariable.class);
                    if (variable != null) {
                        PsiExpression initializer = variable.getInitializer();
                        if (!this.isNewArrayCreation(initializer, defaultValue)) {
                            return null;
                        }
                        expressions2[i] = initializer;
                        continue;
                    }
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)def, PsiAssignmentExpression.class);
                    if (assignment != null) {
                        if (!this.isNewArrayCreation(assignment.getRExpression(), defaultValue)) {
                            return null;
                        }
                        expressions2[i] = assignment;
                        continue;
                    }
                    return null;
                }
                return expressions2;
            }

            private boolean isNewArrayCreation(@Nullable PsiExpression expression2, @Nullable Object defaultValue) {
                PsiArrayInitializerExpression initializer;
                PsiExpression arrInitExpr = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
                PsiNewExpression newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)arrInitExpr, PsiNewExpression.class);
                PsiArrayInitializerExpression psiArrayInitializerExpression = initializer = newExpression == null ? (PsiArrayInitializerExpression)ObjectUtils.tryCast((Object)arrInitExpr, PsiArrayInitializerExpression.class) : newExpression.getArrayInitializer();
                if (initializer == null) {
                    return true;
                }
                return Arrays.stream(initializer.getInitializers()).allMatch(init2 -> this.isDefaultValue((PsiExpression)init2, defaultValue, init2.getType()));
            }

            @Nullable
            private Set<Integer> getDefsOffsets(@NotNull ControlFlow flow, PsiElement @NotNull [] defs) {
                if (flow == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (defs == null) {
                    1.$$$reportNull$$$0(10);
                }
                HashSet<Integer> set = new HashSet<Integer>();
                for (PsiElement def : defs) {
                    int start = flow.getStartOffset(def);
                    if (start == -1) {
                        return null;
                    }
                    int end = flow.getEndOffset(def);
                    if (end == -1) {
                        return null;
                    }
                    for (int i = start; i < end; ++i) {
                        set.add(i);
                    }
                }
                return set;
            }

            private void registerProblem(@NotNull PsiForStatement statement, boolean isSetAll) {
                if (statement == null) {
                    1.$$$reportNull$$$0(11);
                }
                String message2 = JavaBundle.message((String)"inspection.explicit.array.filling.description", (Object[])new Object[]{isSetAll ? "setAll" : "fill"});
                ReplaceWithArraysCallFix fix2 = new ReplaceWithArraysCallFix(!isSetAll);
                ProblemHighlightType type2 = ProblemHighlightType.WARNING;
                if (isSetAll && !ExplicitArrayFillingInspection.this.mySuggestSetAll) {
                    if (!isOnTheFly) {
                        return;
                    }
                    type2 = ProblemHighlightType.INFORMATION;
                }
                TextRange range = this.getRange(statement, type2);
                if (isSetAll && ExplicitArrayFillingInspection.this.mySuggestSetAll && isOnTheFly) {
                    SetInspectionOptionFix disableForSetAllFix = new SetInspectionOptionFix((LocalInspectionTool)ExplicitArrayFillingInspection.this, "mySuggestSetAll", JavaBundle.message((String)"inspection.explicit.array.filling.no.suggestion.for.set.all", (Object[])new Object[0]), false);
                    holder.registerProblem((PsiElement)statement, message2, type2, range, new LocalQuickFix[]{fix2, disableForSetAllFix});
                    return;
                }
                holder.registerProblem((PsiElement)statement, message2, type2, range, new LocalQuickFix[]{fix2});
            }

            @NotNull
            private TextRange getRange(@NotNull PsiForStatement statement, @NotNull ProblemHighlightType type2) {
                if (statement == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (type2 == null) {
                    1.$$$reportNull$$$0(13);
                }
                PsiStatement initialization = statement.getInitialization();
                LOG.assertTrue(initialization != null);
                TextRange range = TextRange.from((int)initialization.getStartOffsetInParent(), (int)initialization.getTextLength());
                boolean wholeStatement = isOnTheFly && (InspectionProjectProfileManager.isInformationLevel((String)ExplicitArrayFillingInspection.this.getShortName(), (PsiElement)statement) || type2 == ProblemHighlightType.INFORMATION);
                PsiJavaToken rParenth = statement.getRParenth();
                if (wholeStatement && rParenth != null) {
                    range = new TextRange(0, rParenth.getStartOffsetInParent() + 1);
                }
                TextRange textRange = range;
                if (textRange == null) {
                    1.$$$reportNull$$$0(14);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 14: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 14: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "loop";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rValue";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 4: 
                    case 11: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "block";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayVar";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayRef";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flow";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "defs";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/ExplicitArrayFillingInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/ExplicitArrayFillingInspection$1";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRange";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isChangedInLoop";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isDefaultValue";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "isFilledWithDefaultValues";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createControlFlow";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "getDefs";
                        break;
                    }
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "getDefsOffsets";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "registerProblem";
                        break;
                    }
                    case 12: 
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "getRange";
                        break;
                    }
                    case 14: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 14: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/ExplicitArrayFillingInspection", "buildVisitor"));
    }

    private static class ReplaceWithArraysCallFix
    implements LocalQuickFix {
        private final boolean myIsRhsConstant;

        private ReplaceWithArraysCallFix(boolean isRhsConstant) {
            this.myIsRhsConstant = isRhsConstant;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.explicit.array.filling.fix.family.name", (Object[])new Object[]{this.myIsRhsConstant ? "fill" : "setAll"});
            if (string == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement result;
            PsiForStatement statement;
            if (project == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(2);
            }
            if ((statement = (PsiForStatement)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiForStatement.class)) == null) {
                return;
            }
            CountingLoop loop = CountingLoop.from(statement);
            if (loop == null) {
                return;
            }
            IndexedContainer container = IndexedContainer.fromLengthExpression(loop.getBound());
            if (container == null) {
                return;
            }
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)ControlFlowUtils.stripBraces(statement.getBody()));
            if (assignment == null) {
                return;
            }
            PsiExpression rValue = assignment.getRExpression();
            if (rValue == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            if (this.myIsRhsConstant) {
                String cast = ReplaceWithArraysCallFix.getCast((PsiElement)statement, container.getElementType(), rValue.getType());
                String replacement = "java.util.Arrays.fill(" + ct.text((PsiElement)container.getQualifier()) + ", " + cast + ct.text((PsiElement)rValue) + ");";
                result = ct.replaceAndRestoreComments((PsiElement)statement, replacement);
            } else {
                String replacement = "java.util.Arrays.setAll(" + ct.text((PsiElement)container.getQualifier()) + ", " + loop.getCounter().getName() + "->" + ct.text((PsiElement)rValue) + ");";
                result = ct.replaceAndRestoreComments((PsiElement)statement, replacement);
                LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            }
            result = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        @NotNull
        private static String getCast(@NotNull PsiElement context, @Nullable PsiType elementType, @Nullable PsiType rType) {
            if (context == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(3);
            }
            if (elementType == null || rType == null) {
                return "";
            }
            PsiType assignTo = (PsiType)ObjectUtils.tryCast((Object)elementType, PsiPrimitiveType.class);
            if (assignTo == null) {
                assignTo = TypeUtils.getObjectType(context);
            }
            String string = TypeConversionUtil.isAssignable((PsiType)assignTo, (PsiType)rType) ? "" : "(" + elementType.getCanonicalText() + ")";
            if (string == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ExplicitArrayFillingInspection$ReplaceWithArraysCallFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ExplicitArrayFillingInspection$ReplaceWithArraysCallFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCast";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCast";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

