/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.IOUtil;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TIntObjectHashMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToBasicLatinAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"intention.convert.to.basic.latin", (Object[])new Object[0]);
        if (string == null) {
            ConvertToBasicLatinAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ConvertToBasicLatinAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        Pair<PsiElement, Handler> pair2;
        if (project == null) {
            ConvertToBasicLatinAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ConvertToBasicLatinAction.$$$reportNull$$$0(3);
        }
        if (element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && (pair2 = ConvertToBasicLatinAction.findHandler(element)) != null) {
            return !IOUtil.isAscii((String)((PsiElement)pair2.first).getText());
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Pair<PsiElement, Handler> pair2;
        if (project == null) {
            ConvertToBasicLatinAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ConvertToBasicLatinAction.$$$reportNull$$$0(5);
        }
        if ((pair2 = ConvertToBasicLatinAction.findHandler(element)) == null) {
            return;
        }
        PsiElement toReplace = (PsiElement)pair2.first;
        PsiElement newElement = ((Handler)pair2.second).getSubstitution(toReplace);
        toReplace.replace(newElement);
    }

    @Nullable
    private static Pair<PsiElement, Handler> findHandler(PsiElement element) {
        for (Handler handler : Lazy.ourHandlers) {
            PsiElement applicable = handler.findApplicable(element);
            if (applicable == null) continue;
            return Pair.pair((Object)applicable, (Object)handler);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ConvertToBasicLatinAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ConvertToBasicLatinAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CommentHandler
    extends DocCommentHandler {
        private CommentHandler() {
        }

        @Override
        PsiElement findApplicable(PsiElement element) {
            return element instanceof PsiComment ? element : null;
        }
    }

    private static class DocCommentHandler
    extends Handler {
        private static TIntObjectHashMap<String> ourEntities;

        private DocCommentHandler() {
        }

        @Override
        PsiElement findApplicable(PsiElement element) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocComment.class, (boolean)false);
        }

        @Override
        PsiElement getSubstitution(PsiElement element) {
            DocCommentHandler.loadEntities(element.getProject());
            return ourEntities != null ? super.getSubstitution(element) : element;
        }

        @Override
        protected void convert(StringBuilder sb, char ch) {
            String entity = (String)ourEntities.get((int)ch);
            if (entity != null) {
                sb.append('&').append(entity).append(';');
            } else {
                sb.append("&#x").append(Integer.toHexString(ch).toUpperCase(Locale.ENGLISH)).append(';');
            }
        }

        @Override
        protected PsiElement getSubstitution(PsiElementFactory factory, PsiElement element, String newText) {
            return factory.createCommentFromText(newText, element.getParent());
        }

        private static void loadEntities(Project project) {
            XmlFile file;
            if (ourEntities != null) {
                return;
            }
            try {
                String url = ExternalResourceManager.getInstance().getResourceLocation("http://www.w3.org/TR/html4/loose.dtd", project);
                if (url == null) {
                    Logger.getInstance(ConvertToBasicLatinAction.class).error("Namespace not found: http://www.w3.org/TR/html4/loose.dtd");
                    return;
                }
                VirtualFile vFile = VfsUtil.findFileByURL((URL)new URL(url));
                if (vFile == null) {
                    Logger.getInstance(ConvertToBasicLatinAction.class).error("Resource not found: " + url);
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
                if (!(psiFile instanceof XmlFile)) {
                    Logger.getInstance(ConvertToBasicLatinAction.class).error("Unexpected resource: " + psiFile);
                    return;
                }
                file = (XmlFile)psiFile;
            }
            catch (MalformedURLException e) {
                Logger.getInstance(ConvertToBasicLatinAction.class).error((Throwable)e);
                return;
            }
            TIntObjectHashMap entities = new TIntObjectHashMap();
            Pattern pattern = Pattern.compile("&#(\\d+);");
            XmlUtil.processXmlElements((XmlElement)file, element -> {
                char i;
                XmlEntityDecl entity;
                Matcher m;
                if (element instanceof XmlEntityDecl && (m = pattern.matcher((entity = (XmlEntityDecl)element).getValueElement().getValue())).matches() && !DocCommentHandler.isBasicLatin(i = (char)Integer.parseInt(m.group(1)))) {
                    entities.put((int)i, (Object)entity.getName());
                }
                return true;
            }, (boolean)true);
            ourEntities = entities;
        }
    }

    private static class LiteralHandler
    extends Handler {
        private static final TokenSet LITERALS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.CHARACTER_LITERAL, JavaTokenType.STRING_LITERAL});

        private LiteralHandler() {
        }

        @Override
        PsiElement findApplicable(PsiElement element) {
            PsiElement parent;
            if (element instanceof PsiJavaToken && LITERALS.contains(((PsiJavaToken)element).getTokenType()) && (parent = element.getParent()) instanceof PsiLiteralExpression) {
                return parent;
            }
            return null;
        }

        @Override
        protected PsiElement getSubstitution(PsiElementFactory factory, PsiElement element, String newText) {
            return factory.createExpressionFromText(newText, element.getParent());
        }

        @Override
        protected void convert(StringBuilder sb, char ch) {
            sb.append(String.format("\\u%04X", ch));
        }
    }

    private static abstract class Handler {
        private Handler() {
        }

        @Nullable
        abstract PsiElement findApplicable(PsiElement var1);

        PsiElement getSubstitution(PsiElement element) {
            String text2 = element.getText();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < text2.length(); ++i) {
                char ch = text2.charAt(i);
                if (Handler.isBasicLatin(ch)) {
                    sb.append(ch);
                    continue;
                }
                this.convert(sb, ch);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
            return this.getSubstitution(factory, element, sb.toString());
        }

        protected static boolean isBasicLatin(char ch) {
            return Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.BASIC_LATIN;
        }

        protected abstract void convert(StringBuilder var1, char var2);

        protected abstract PsiElement getSubstitution(PsiElementFactory var1, PsiElement var2, String var3);
    }

    private static class Lazy {
        private static final Handler[] ourHandlers = new Handler[]{new LiteralHandler(), new DocCommentHandler(), new CommentHandler()};

        private Lazy() {
        }
    }
}

