/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.RecordConstructorMember;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.PsiClass;
import com.intellij.ui.components.JBRadioButton;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

final class RecordConstructorChooserDialog
extends DialogWrapper {
    @NotNull
    private final JBRadioButton myCompact;
    @NotNull
    private final JBRadioButton myCanonical;
    @NotNull
    private final JBRadioButton myCustom;
    @NotNull
    private final PsiClass myRecordClass;

    RecordConstructorChooserDialog(@NotNull PsiClass recordClass) {
        if (recordClass == null) {
            RecordConstructorChooserDialog.$$$reportNull$$$0(0);
        }
        super(recordClass.getProject());
        this.myRecordClass = recordClass;
        this.setTitle(JavaBundle.message((String)"generate.record.constructor.title", (Object[])new Object[0]));
        this.setOKButtonText(JavaBundle.message((String)"generate.button.title", (Object[])new Object[0]));
        this.myCompact = new JBRadioButton(JavaErrorBundle.message("record.compact.constructor", new Object[0]), true);
        this.myCanonical = new JBRadioButton(JavaErrorBundle.message("record.canonical.constructor", new Object[0]), false);
        this.myCustom = new JBRadioButton(ApplicationBundle.message((String)"custom.option", (Object[])new Object[0]), false);
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCompact;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.myCompact);
        group.add((AbstractButton)this.myCanonical);
        group.add((AbstractButton)this.myCustom);
        panel2.add((Component)this.myCompact);
        panel2.add((Component)this.myCanonical);
        panel2.add((Component)this.myCustom);
        return panel2;
    }

    ClassMember getClassMember() {
        if (this.myCompact.isSelected()) {
            return new RecordConstructorMember(this.myRecordClass, true);
        }
        if (this.myCanonical.isSelected()) {
            return new RecordConstructorMember(this.myRecordClass, false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordClass", "com/intellij/codeInsight/generation/RecordConstructorChooserDialog", "<init>"));
    }
}

