/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;

public class EnumFieldFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof PsiEnumConstant) {
            int insertionOffset = psiElement.getTextRange().getEndOffset();
            Document doc = editor.getDocument();
            CharSequence text2 = doc.getCharsSequence();
            int probableCommaOffset = CharArrayUtil.shiftForward((CharSequence)text2, (int)insertionOffset, (String)" \t");
            if (probableCommaOffset >= text2.length() || text2.charAt(probableCommaOffset) != ',') {
                doc.insertString(insertionOffset, (CharSequence)",");
            }
        }
    }
}

