/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocCommentFixer;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspection;
import com.intellij.codeInspection.javaDoc.JavaDocReferenceInspection;
import com.intellij.javadoc.JavadocNavigationDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaDocCommentFixer
implements DocCommentFixer {
    private static final String PARAM_TAG = "@param";
    private static final String PARAM_TAG_NAME = "param";
    private static final Set<String> CARET_ANCHOR_TAGS = ContainerUtil.newHashSet((Object[])new String[]{"@param", "@throws", "@return"});
    private static final Comparator<PsiElement> COMPARATOR = (e1, e2) -> e2.getTextRange().getEndOffset() - e1.getTextRange().getEndOffset();

    public void fixComment(@NotNull Project project, @NotNull Editor editor, @NotNull PsiComment comment) {
        if (project == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(1);
        }
        if (comment == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(2);
        }
        if (!(comment instanceof PsiDocComment)) {
            return;
        }
        PsiDocComment docComment = (PsiDocComment)comment;
        PsiJavaDocumentedElement owner2 = docComment.getOwner();
        if (owner2 == null) {
            return;
        }
        PsiFile file = owner2.getContainingFile();
        if (file == null) {
            return;
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
        ProblemsHolder referenceProblems = new ProblemsHolder(inspectionManager, file, false);
        owner2.accept(new JavaDocReferenceInspection().buildVisitor(referenceProblems, referenceProblems.isOnTheFly()));
        ProblemsHolder commonProblems = new ProblemsHolder(inspectionManager, file, false);
        owner2.accept(JavaDocCommentFixer.getDocLocalInspection().buildVisitor(commonProblems, commonProblems.isOnTheFly()));
        if (referenceProblems.getResultCount() > 0) {
            JavaDocCommentFixer.fixReferenceProblems(referenceProblems.getResults(), project);
        }
        if (commonProblems.getResultCount() > 0) {
            JavaDocCommentFixer.fixCommonProblems(commonProblems.getResults(), comment, editor.getDocument(), project);
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        JavaDocCommentFixer.ensureContentOrdered(docComment, editor.getDocument());
        JavaDocCommentFixer.locateCaret(docComment, editor, file);
    }

    @NotNull
    private static JavaDocLocalInspection getDocLocalInspection() {
        JavaDocLocalInspection localInspection = new JavaDocLocalInspection();
        localInspection.TOP_LEVEL_CLASS_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = "private";
        localInspection.INNER_CLASS_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = "private";
        localInspection.FIELD_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = "private";
        localInspection.METHOD_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = "private";
        localInspection.setIgnoreEmptyDescriptions(true);
        if (!localInspection.TOP_LEVEL_CLASS_OPTIONS.REQUIRED_TAGS.contains(PARAM_TAG)) {
            localInspection.TOP_LEVEL_CLASS_OPTIONS.REQUIRED_TAGS = localInspection.TOP_LEVEL_CLASS_OPTIONS.REQUIRED_TAGS + PARAM_TAG;
        }
        if (!localInspection.INNER_CLASS_OPTIONS.REQUIRED_TAGS.contains(PARAM_TAG)) {
            localInspection.INNER_CLASS_OPTIONS.REQUIRED_TAGS = localInspection.INNER_CLASS_OPTIONS.REQUIRED_TAGS + PARAM_TAG;
        }
        JavaDocLocalInspection javaDocLocalInspection = localInspection;
        if (javaDocLocalInspection == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(3);
        }
        return javaDocLocalInspection;
    }

    private static void fixReferenceProblems(@NotNull List<? extends ProblemDescriptor> problems2, @NotNull Project project) {
        if (problems2 == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(5);
        }
        for (ProblemDescriptor problemDescriptor : problems2) {
            QuickFix[] fixes = problemDescriptor.getFixes();
            if (fixes == null) continue;
            fixes[0].applyFix(project, (CommonProblemDescriptor)problemDescriptor);
        }
    }

    private static void fixCommonProblems(@NotNull List<? extends ProblemDescriptor> problems2, @NotNull PsiComment comment, @NotNull Document document, @NotNull Project project) {
        if (problems2 == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(6);
        }
        if (comment == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(7);
        }
        if (document == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(8);
        }
        if (project == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(9);
        }
        ArrayList<PsiElement> toRemove2 = new ArrayList<PsiElement>();
        block0: for (ProblemDescriptor problemDescriptor : problems2) {
            PsiElement element = problemDescriptor.getPsiElement();
            if (element == null) continue;
            if (!(element instanceof PsiDocToken && JavaDocTokenType.DOC_COMMENT_START.equals(((PsiDocToken)element).getTokenType()) || !comment.getTextRange().contains(element.getTextRange()))) {
                for (PsiElement e = element; e != null; e = e.getParent()) {
                    if (!(e instanceof PsiDocTag)) continue;
                    toRemove2.add(e);
                    continue block0;
                }
                continue;
            }
            QuickFix[] fixes = problemDescriptor.getFixes();
            if (fixes == null || fixes.length <= 0) continue;
            fixes[0].applyFix(project, (CommonProblemDescriptor)problemDescriptor);
        }
        if (toRemove2.isEmpty()) {
            return;
        }
        if (toRemove2.size() > 1) {
            Collections.sort(toRemove2, COMPARATOR);
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        CharSequence charSequence = document.getCharsSequence();
        for (PsiElement element : toRemove2) {
            int endOffset;
            char c;
            int startOffset = element.getTextRange().getStartOffset();
            int startLine = document.getLineNumber(startOffset);
            int i = CharArrayUtil.shiftBackward((CharSequence)charSequence, (int)(startOffset - 1), (String)" \t");
            if (i >= 0 && (c = charSequence.charAt(i)) == '*') {
                i = CharArrayUtil.shiftBackward((CharSequence)charSequence, (int)(i - 1), (String)" \t");
            }
            if (i >= 0 && charSequence.charAt(i) == '\n') {
                startOffset = Math.max(i, document.getLineStartOffset(startLine) - 1);
            }
            if ((i = CharArrayUtil.shiftBackward((CharSequence)charSequence, (int)((endOffset = element.getTextRange().getEndOffset()) - 1), (String)" \t*")) > 0 && charSequence.charAt(i) == '\n') {
                endOffset = i;
            }
            document.deleteString(startOffset, endOffset);
        }
        psiDocumentManager.commitDocument(document);
    }

    /*
     * WARNING - void declaration
     */
    private static void ensureContentOrdered(@NotNull PsiDocComment comment, @NotNull Document document) {
        void var7_16;
        if (comment == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(10);
        }
        if (document == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(11);
        }
        ArrayList<String> current = new ArrayList<String>();
        HashMap<String, Pair<TextRange, String>> tagInfoByName = new HashMap<String, Pair<TextRange, String>>();
        for (PsiDocTag psiDocTag : comment.getTags()) {
            String paramName;
            PsiDocTagValue valueElement;
            if (!PARAM_TAG_NAME.equals(psiDocTag.getName()) || (valueElement = psiDocTag.getValueElement()) == null || (paramName = valueElement.getText()) == null) continue;
            current.add(paramName);
            tagInfoByName.put(paramName, JavaDocCommentFixer.parseTagValue(psiDocTag, document));
        }
        ArrayList<String> ordered = new ArrayList<String>();
        PsiJavaDocumentedElement owner2 = comment.getOwner();
        if (owner2 instanceof PsiMethod) {
            PsiParameter[] parameters2;
            for (PsiParameter psiParameter : parameters2 = ((PsiMethod)owner2).getParameterList().getParameters()) {
                ordered.add(psiParameter.getName());
            }
        }
        if (owner2 instanceof PsiTypeParameterListOwner) {
            PsiTypeParameter[] typeParameters;
            for (PsiTypeParameter psiTypeParameter : typeParameters = ((PsiTypeParameterListOwner)owner2).getTypeParameters()) {
                ordered.add(String.format("<%s>", psiTypeParameter.getName()));
            }
        }
        if (current.size() != ordered.size()) {
            return;
        }
        boolean changed = false;
        int n = current.size() - 1;
        while (var7_16 >= 0) {
            String oldTag;
            String newTag = (String)ordered.get((int)var7_16);
            if (!newTag.equals(oldTag = (String)current.get((int)var7_16))) {
                TextRange textRange = (TextRange)((Pair)tagInfoByName.get((Object)oldTag)).first;
                document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)((Pair)tagInfoByName.get((Object)newTag)).second);
                changed = true;
            }
            --var7_16;
        }
        if (changed) {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)comment.getProject());
            psiDocumentManager.commitDocument(document);
        }
    }

    @NotNull
    private static Pair<TextRange, String> parseTagValue(@NotNull PsiDocTag tag, @NotNull Document document) {
        if (tag == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(12);
        }
        if (document == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(13);
        }
        PsiDocTagValue valueElement = tag.getValueElement();
        assert (valueElement != null);
        int startOffset = valueElement.getTextRange().getStartOffset();
        int endOffset = tag.getTextRange().getEndOffset();
        CharSequence text2 = document.getCharsSequence();
        int i = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(endOffset - 1), (String)" \t*");
        if (i > 0 && text2.charAt(i) == '\n') {
            endOffset = i;
        }
        Pair pair2 = Pair.create((Object)TextRange.create((int)startOffset, (int)endOffset), (Object)text2.subSequence(startOffset, endOffset).toString());
        if (pair2 == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(14);
        }
        return pair2;
    }

    private static void locateCaret(@NotNull PsiDocComment comment, @NotNull Editor editor, @NotNull PsiFile file) {
        if (comment == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(16);
        }
        if (file == null) {
            JavaDocCommentFixer.$$$reportNull$$$0(17);
        }
        Document document = editor.getDocument();
        int lineToNavigate = -1;
        for (PsiDocTag tag : comment.getTags()) {
            PsiElement nameElement = tag.getNameElement();
            if (nameElement == null || !CARET_ANCHOR_TAGS.contains(nameElement.getText())) continue;
            boolean good = false;
            PsiElement[] dataElements = tag.getDataElements();
            PsiDocTagValue valueElement = tag.getValueElement();
            for (PsiElement element : dataElements) {
                if (element == valueElement || StringUtil.isEmptyOrSpaces((String)element.getText())) continue;
                good = true;
                break;
            }
            if (good) continue;
            int offset = tag.getTextRange().getEndOffset();
            CharSequence text2 = document.getCharsSequence();
            int i = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(offset - 1), (String)" \t*");
            if (i > 0 && text2.charAt(i) == '\n') {
                offset = i - 1;
            }
            lineToNavigate = document.getLineNumber(offset);
            break;
        }
        if (lineToNavigate >= 0) {
            editor.getCaretModel().moveToOffset(document.getLineEndOffset(lineToNavigate));
            JavadocNavigationDelegate.navigateToLineEnd(editor, file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/JavaDocCommentFixer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/JavaDocCommentFixer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocLocalInspection";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTagValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fixComment";
                break;
            }
            case 3: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fixReferenceProblems";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fixCommonProblems";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "ensureContentOrdered";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseTagValue";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "locateCaret";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

