/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassKind;
import com.intellij.psi.util.CreateClassUtil;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateClassOrPackageFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(CreateClassOrPackageFix.class);
    private final List<? extends PsiDirectory> myWritableDirectoryList;
    private final String myPresentation;
    @Nullable
    private final ClassKind myClassKind;
    @Nullable
    private final String mySuperClass;
    private final String myRedPart;
    @Nullable
    private final String myTemplateName;

    @Nullable
    public static CreateClassOrPackageFix createFix(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope, @NotNull PsiElement context, @Nullable PsiPackage basePackage, @Nullable ClassKind kind2, @Nullable String superClass, @Nullable String templateName) {
        List<PsiDirectory> directories;
        if (qualifiedName == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(1);
        }
        if (context == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(2);
        }
        if ((directories = CreateClassOrPackageFix.getWritableDirectoryListDefault(basePackage, scope, context.getManager())).isEmpty()) {
            return null;
        }
        String redPart = basePackage == null ? qualifiedName : qualifiedName.substring(basePackage.getQualifiedName().length() + 1);
        int dot = redPart.indexOf(46);
        boolean fixPath = dot >= 0;
        String firstRedName = fixPath ? redPart.substring(0, dot) : redPart;
        directories.removeIf(directory -> !CreateClassOrPackageFix.checkCreateClassOrPackage(kind2 != null && !fixPath, directory, firstRedName));
        return new CreateClassOrPackageFix(directories, context, fixPath ? qualifiedName : redPart, redPart, kind2, superClass, templateName);
    }

    @Nullable
    public static CreateClassOrPackageFix createFix(@NotNull String qualifiedName, @NotNull PsiElement context, @Nullable ClassKind kind2, String superClass) {
        if (qualifiedName == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(3);
        }
        if (context == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(4);
        }
        return CreateClassOrPackageFix.createFix(qualifiedName, context.getResolveScope(), context, null, kind2, superClass, null);
    }

    private CreateClassOrPackageFix(@NotNull List<? extends PsiDirectory> writableDirectoryList, @NotNull PsiElement context, @NotNull String presentation, @NotNull String redPart, @Nullable ClassKind kind2, @Nullable String superClass, @Nullable String templateName) {
        if (writableDirectoryList == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(5);
        }
        if (context == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(6);
        }
        if (presentation == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(7);
        }
        if (redPart == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(8);
        }
        super(context);
        this.myRedPart = redPart;
        this.myTemplateName = templateName;
        this.myWritableDirectoryList = writableDirectoryList;
        this.myClassKind = kind2;
        this.mySuperClass = superClass;
        this.myPresentation = presentation;
    }

    @NotNull
    public String getText() {
        String string = CommonQuickFixBundle.message((String)"fix.create.title.x", (Object[])new Object[]{(this.myClassKind == null ? JavaElementKind.PACKAGE : this.myClassKind.getElementKind()).object(), this.myPresentation});
        if (string == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(11);
        }
        if (file == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(12);
        }
        if (startElement == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(13);
        }
        if (endElement == null) {
            CreateClassOrPackageFix.$$$reportNull$$$0(14);
        }
        if (this.isAvailable(project, null, file)) {
            PsiDirectory directory = this.chooseDirectory(project, file);
            if (directory == null) {
                return;
            }
            WriteAction.run(() -> this.doCreate(directory, startElement));
        }
    }

    private static boolean checkCreateClassOrPackage(boolean createJavaClass, PsiDirectory directory, String name2) {
        try {
            if (createJavaClass) {
                JavaDirectoryService.getInstance().checkCreateClass(directory, name2);
            } else {
                directory.checkCreateSubdirectory(name2);
            }
            return true;
        }
        catch (IncorrectOperationException ex) {
            return false;
        }
    }

    @Nullable
    private PsiDirectory chooseDirectory(Project project, PsiFile file) {
        PsiDirectory preferredDirectory = this.myWritableDirectoryList.isEmpty() ? null : this.myWritableDirectoryList.get(0);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile virtualFile = file.getVirtualFile();
        assert (virtualFile != null);
        Module moduleForFile = fileIndex.getModuleForFile(virtualFile);
        if (this.myWritableDirectoryList.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            if (moduleForFile != null) {
                for (PsiDirectory psiDirectory : this.myWritableDirectoryList) {
                    if (fileIndex.getModuleForFile(psiDirectory.getVirtualFile()) != moduleForFile) continue;
                    preferredDirectory = psiDirectory;
                    break;
                }
            }
            return DirectoryChooserUtil.chooseDirectory((PsiDirectory[])this.myWritableDirectoryList.toArray(PsiDirectory.EMPTY_ARRAY), (PsiDirectory)preferredDirectory, (Project)project, new HashMap());
        }
        return preferredDirectory;
    }

    private void doCreate(PsiDirectory baseDirectory, PsiElement myContext) {
        String lastName;
        PsiManager manager = baseDirectory.getManager();
        PsiDirectory directory = baseDirectory;
        StringTokenizer st = new StringTokenizer(this.myRedPart, ".");
        while (true) {
            lastName = st.nextToken();
            if (!st.hasMoreTokens()) break;
            try {
                PsiDirectory subdirectory = directory.findSubdirectory(lastName);
                directory = subdirectory != null ? subdirectory : directory.createSubdirectory(lastName);
            }
            catch (IncorrectOperationException e) {
                CreateFromUsageUtils.scheduleFileOrPackageCreationFailedMessageBox(e, lastName, directory, true);
                return;
            }
        }
        if (this.myClassKind != null) {
            PsiClass createdClass = this.myTemplateName != null ? CreateClassUtil.createClassFromCustomTemplate(directory, null, lastName, this.myTemplateName) : CreateFromUsageUtils.createClass(this.myClassKind == ClassKind.INTERFACE ? CreateClassKind.INTERFACE : CreateClassKind.CLASS, directory, lastName, manager, myContext, null, this.mySuperClass);
            if (createdClass != null) {
                createdClass.navigate(true);
            }
        } else {
            try {
                directory.createSubdirectory(lastName);
            }
            catch (IncorrectOperationException e) {
                CreateFromUsageUtils.scheduleFileOrPackageCreationFailedMessageBox(e, lastName, directory, true);
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static List<PsiDirectory> getWritableDirectoryListDefault(@Nullable PsiPackage context, GlobalSearchScope scope, PsiManager psiManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting writable directory list for package '" + (context == null ? null : context.getQualifiedName()) + "', scope=" + scope);
        }
        ArrayList<PsiDirectory> writableDirectoryList = new ArrayList<PsiDirectory>();
        if (context != null) {
            for (PsiDirectory directory : context.getDirectories()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Package directory: " + directory);
                }
                VirtualFile virtualFile = directory.getVirtualFile();
                if (!directory.isWritable() || !scope.contains(virtualFile) || JavaProjectRootsUtil.isInGeneratedCode(virtualFile, psiManager.getProject())) continue;
                writableDirectoryList.add(directory);
            }
        } else {
            for (VirtualFile root : JavaProjectRootsUtil.getSuitableDestinationSourceRoots(psiManager.getProject())) {
                PsiDirectory directory = psiManager.findDirectory(root);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Root: " + root + ", directory: " + directory);
                }
                if (directory == null || !directory.isWritable() || !scope.contains(directory.getVirtualFile())) continue;
                writableDirectoryList.add(directory);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Result " + writableDirectoryList);
        }
        return writableDirectoryList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writableDirectoryList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "redPart";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

