/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.problems;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightVisitorImpl;
import com.intellij.codeInsight.daemon.problems.Problem;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/intellij/codeInsight/daemon/problems/ProblemMatcher;", "", "()V", "Companion", "ProblemSearcher", "intellij.java.impl"})
public final class ProblemMatcher {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006,"}, d2={"Lcom/intellij/codeInsight/daemon/problems/ProblemMatcher$ProblemSearcher;", "Lcom/intellij/psi/JavaElementVisitor;", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "problems", "", "Lcom/intellij/pom/Navigatable;", "", "getProblems", "()Ljava/util/Map;", "findProblem", "", "element", "Lcom/intellij/psi/PsiElement;", "visitAnnotation", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "visitAnonymousClass", "aClass", "Lcom/intellij/psi/PsiAnonymousClass;", "visitCallExpression", "callExpression", "Lcom/intellij/psi/PsiCallExpression;", "visitClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "visitElement", "visitMethod", "method", "Lcom/intellij/psi/PsiMethod;", "visitParameter", "parameter", "Lcom/intellij/psi/PsiParameter;", "visitReferenceExpression", "expression", "Lcom/intellij/psi/PsiReferenceExpression;", "visitStatement", "statement", "Lcom/intellij/psi/PsiStatement;", "visitVariable", "variable", "Lcom/intellij/psi/PsiVariable;", "ProblemHolder", "intellij.java.impl"})
    private static final class ProblemSearcher
    extends JavaElementVisitor {
        @NotNull
        private final Map<Navigatable, String> problems;
        private final PsiFile file;

        @NotNull
        public final Map<Navigatable, String> getProblems() {
            return this.problems;
        }

        public void visitElement(@NotNull PsiElement element) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                this.findProblem(element);
                PsiElement psiElement = element.getParent();
                if (psiElement == null) break block0;
                psiElement.accept((PsiElementVisitor)this);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.visitElement((PsiElement)expression2);
        }

        public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
            Intrinsics.checkParameterIsNotNull((Object)callExpression, (String)"callExpression");
            PsiExpressionList args = callExpression.getArgumentList();
            if (args != null) {
                this.findProblem((PsiElement)args);
            }
            this.visitElement((PsiElement)callExpression);
        }

        public void visitAnnotation(@NotNull PsiAnnotation annotation) {
            Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
            PsiAnnotationParameterList psiAnnotationParameterList = annotation.getParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationParameterList, (String)"annotation.parameterList");
            PsiAnnotationParameterList paramsList = psiAnnotationParameterList;
            PsiNameValuePair[] psiNameValuePairArray = paramsList.getAttributes();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiNameValuePairArray, (String)"paramsList.attributes");
            PsiNameValuePair[] $this$forEach$iv = psiNameValuePairArray;
            boolean $i$f$forEach = false;
            PsiNameValuePair[] psiNameValuePairArray2 = $this$forEach$iv;
            int n = psiNameValuePairArray2.length;
            for (int i = 0; i < n; ++i) {
                PsiNameValuePair element$iv;
                PsiNameValuePair it = element$iv = psiNameValuePairArray2[i];
                boolean bl = false;
                PsiNameValuePair psiNameValuePair = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiNameValuePair, (String)"it");
                this.findProblem((PsiElement)psiNameValuePair);
            }
            this.visitElement((PsiElement)annotation);
        }

        public void visitParameter(@NotNull PsiParameter parameter2) {
            Intrinsics.checkParameterIsNotNull((Object)parameter2, (String)"parameter");
            PsiElement parent = parameter2.getParent();
            if (parent instanceof PsiCatchSection) {
                PsiTryStatement psiTryStatement = ((PsiCatchSection)parent).getTryStatement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiTryStatement, (String)"parent.tryStatement");
                this.findProblem((PsiElement)psiTryStatement);
            }
            this.findProblem((PsiElement)parameter2);
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
            this.findProblem((PsiElement)variable);
        }

        public void visitStatement(@NotNull PsiStatement statement) {
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            this.findProblem((PsiElement)statement);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            this.findProblem((PsiElement)method);
            PsiTypeElement typeElement = method.getReturnTypeElement();
            if (typeElement != null) {
                this.findProblem((PsiElement)typeElement);
            }
            PsiParameterList psiParameterList = method.getParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
            PsiParameterList params = psiParameterList;
            this.findProblem((PsiElement)params);
            PsiModifierList psiModifierList = method.getModifierList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"method.modifierList");
            PsiModifierList modifiers = psiModifierList;
            this.findProblem((PsiElement)modifiers);
        }

        public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
            Intrinsics.checkParameterIsNotNull((Object)aClass, (String)"aClass");
            this.visitElement((PsiElement)aClass);
        }

        public void visitClass(@NotNull PsiClass psiClass) {
            Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
            PsiModifierList modifiers = psiClass.getModifierList();
            if (modifiers != null) {
                this.findProblem((PsiElement)modifiers);
            }
            this.findProblem((PsiElement)psiClass);
        }

        private final void findProblem(PsiElement element) {
            if (!(element instanceof Navigatable)) {
                return;
            }
            ProblemHolder problemHolder = new ProblemHolder(this.file);
            HighlightVisitorImpl visitor2 = new HighlightVisitorImpl(problemHolder){
                final /* synthetic */ ProblemHolder $problemHolder;
                {
                    this.$problemHolder = $captured_local_variable$0;
                    this.prepareToRunAsInspection($captured_local_variable$0);
                }
            };
            element.accept((PsiElementVisitor)visitor2);
            this.problems.put((Navigatable)element, problemHolder.getProblem());
        }

        public ProblemSearcher(@NotNull PsiFile file) {
            Map map2;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.file = file;
            ProblemSearcher problemSearcher = this;
            boolean bl = false;
            problemSearcher.problems = map2 = (Map)new LinkedHashMap();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/codeInsight/daemon/problems/ProblemMatcher$ProblemSearcher$ProblemHolder;", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "problem", "", "getProblem", "()Ljava/lang/String;", "setProblem", "(Ljava/lang/String;)V", "add", "", "info", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "findPlace", "Lcom/intellij/psi/PsiElement;", "hasErrorResults", "intellij.java.impl"})
        private static final class ProblemHolder
        extends HighlightInfoHolder {
            @Nullable
            private String problem;
            private final PsiFile file;

            @Nullable
            public final String getProblem() {
                return this.problem;
            }

            public final void setProblem(@Nullable String string) {
                this.problem = string;
            }

            public boolean add(@Nullable HighlightInfo info) {
                if (this.problem != null || info == null || Intrinsics.areEqual((Object)info.getSeverity(), (Object)HighlightSeverity.ERROR) ^ true) {
                    return true;
                }
                PsiElement place = this.findPlace(info);
                if (!(place instanceof Navigatable)) {
                    return true;
                }
                this.problem = info.getDescription();
                return true;
            }

            public boolean hasErrorResults() {
                return false;
            }

            private final PsiElement findPlace(HighlightInfo info) {
                PsiElement psiElement = this.file.findElementAt(info.getActualStartOffset());
                if (psiElement == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"file.findElementAt(info.\u2026artOffset) ?: return null");
                PsiElement startElement = psiElement;
                PsiElement psiElement2 = this.file.findElementAt(info.getActualEndOffset() - 1);
                if (psiElement2 == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"file.findElementAt(info.\u2026ffset - 1) ?: return null");
                PsiElement endElement = psiElement2;
                return PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
            }

            public ProblemHolder(@NotNull PsiFile file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                super(file, new HighlightInfoFilter[0]);
                this.file = file;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/daemon/problems/ProblemMatcher$Companion;", "", "()V", "collectProblems", "", "Lcom/intellij/codeInsight/daemon/problems/Problem;", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "getProblems", "usage", "getProblems$intellij_java_impl", "getSearchStartElement", "intellij.java.impl"})
    public static final class Companion {
        @NotNull
        public final List<Problem> getProblems$intellij_java_impl(@NotNull PsiElement usage) {
            PsiFile psiFile;
            Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
            PsiElement psiElement = this.getSearchStartElement(usage);
            if (psiElement == null) {
                return CollectionsKt.emptyList();
            }
            PsiElement startElement = psiElement;
            PsiFile psiFile2 = psiFile = startElement.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"psiFile");
            return this.collectProblems(psiFile2, startElement);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Problem> collectProblems(PsiFile psiFile, PsiElement startElement) {
            void $this$mapTo$iv$iv;
            ProblemSearcher searcher = new ProblemSearcher(psiFile);
            startElement.accept((PsiElementVisitor)searcher);
            VirtualFile file = psiFile.getVirtualFile();
            Map<Navigatable, String> $this$map$iv = searcher.getProblems();
            boolean $i$f$map = false;
            Map<Navigatable, String> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var10_10 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var10_10.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                VirtualFile virtualFile = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                Problem problem = new Problem(virtualFile, (String)it.getValue(), (Navigatable)it.getKey());
                collection.add(problem);
            }
            return (List)destination$iv$iv;
        }

        private final PsiElement getSearchStartElement(PsiElement usage) {
            PsiElement psiElement;
            PsiElement psiElement2 = usage;
            if (psiElement2 instanceof PsiMethod) {
                PsiAnnotation psiAnnotation = ((PsiMethod)usage).getModifierList().findAnnotation("java.lang.Override");
                psiElement = psiAnnotation != null ? (PsiElement)psiAnnotation : usage;
            } else {
                psiElement = psiElement2 instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)usage).getReferenceNameElement() : usage;
            }
            return psiElement;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

