/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.ReferenceNameExpression;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.function.Function;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RenameWrongRefFix
implements IntentionAction,
HintAction {
    private final PsiReferenceExpression myRefExpr;
    @NonNls
    private static final String INPUT_VARIABLE_NAME = "INPUTVAR";
    @NonNls
    private static final String OTHER_VARIABLE_NAME = "OTHERVAR";
    private final boolean myUnresolvedOnly;

    public RenameWrongRefFix(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr == null) {
            RenameWrongRefFix.$$$reportNull$$$0(0);
        }
        this(refExpr, false);
    }

    public RenameWrongRefFix(@NotNull PsiReferenceExpression refExpr, boolean unresolvedOnly) {
        if (refExpr == null) {
            RenameWrongRefFix.$$$reportNull$$$0(1);
        }
        this.myRefExpr = refExpr;
        this.myUnresolvedOnly = unresolvedOnly;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("rename.wrong.reference.text", new Object[0]);
        if (string == null) {
            RenameWrongRefFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("rename.wrong.reference.family", new Object[0]);
        if (string == null) {
            RenameWrongRefFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            RenameWrongRefFix.$$$reportNull$$$0(4);
        }
        if (!this.myRefExpr.isValid() || !BaseIntentionAction.canModify((PsiElement)this.myRefExpr)) {
            return false;
        }
        PsiElement refName = this.myRefExpr.getReferenceNameElement();
        if (refName == null) {
            return false;
        }
        return !CreateFromUsageUtils.isValidReference((PsiReference)this.myRefExpr, this.myUnresolvedOnly);
    }

    private LookupElement @NotNull [] collectItems() {
        boolean qualified;
        LinkedHashSet<LookupElementBuilder> items = new LinkedHashSet<LookupElementBuilder>();
        boolean bl = qualified = this.myRefExpr.getQualifierExpression() != null;
        if (!qualified && !(this.myRefExpr.getParent() instanceof PsiMethodCallExpression)) {
            PsiVariable[] vars;
            for (PsiVariable var : vars = CreateFromUsageUtils.guessMatchingVariables((PsiExpression)this.myRefExpr)) {
                items.add(RenameWrongRefFix.createLookupElement(var, v -> v.getName()));
            }
        } else {
            PsiElement[] variants;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                items.add(RenameWrongRefFix.createLookupElement(this.myRefExpr, r -> r.getReferenceName()));
            }
            class MyScopeProcessor
            implements PsiScopeProcessor {
                final ArrayList<PsiElement> myResult = new ArrayList();
                final boolean myFilterMethods;
                boolean myFilterStatics;

                MyScopeProcessor(PsiReferenceExpression refExpression) {
                    this.myFilterMethods = refExpression.getParent() instanceof PsiMethodCallExpression;
                    PsiExpression qualifier = refExpression.getQualifierExpression();
                    if (qualifier instanceof PsiReferenceExpression) {
                        PsiElement e = ((PsiReferenceExpression)qualifier).resolve();
                        this.myFilterStatics = e instanceof PsiClass;
                    } else if (qualifier == null) {
                        PsiModifierListOwner scope = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiModifierListOwner.class);
                        this.myFilterStatics = scope != null && scope.hasModifierProperty("static");
                    }
                }

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        MyScopeProcessor.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        MyScopeProcessor.$$$reportNull$$$0(1);
                    }
                    if (element instanceof PsiNamedElement && element instanceof PsiModifierListOwner && this.myFilterMethods == element instanceof PsiMethod && ((PsiModifierListOwner)element).hasModifierProperty("static") == this.myFilterStatics) {
                        this.myResult.add(element);
                    }
                    return true;
                }

                public PsiElement[] getVariants() {
                    return PsiUtilCore.toPsiElementArray(this.myResult);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameWrongRefFix$1MyScopeProcessor";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            MyScopeProcessor processor = new MyScopeProcessor(this.myRefExpr);
            this.myRefExpr.processVariants((PsiScopeProcessor)processor);
            for (PsiElement variant : variants = processor.getVariants()) {
                items.add(RenameWrongRefFix.createLookupElement((PsiNamedElement)variant, v -> v.getName()));
            }
        }
        LookupElement[] lookupElementArray = items.toArray(LookupElement.EMPTY_ARRAY);
        if (lookupElementArray == null) {
            RenameWrongRefFix.$$$reportNull$$$0(5);
        }
        return lookupElementArray;
    }

    @NotNull
    private static <T extends PsiElement> LookupElementBuilder createLookupElement(T variant, Function<T, String> toPresentableElement) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create(variant, (String)toPresentableElement.apply(variant));
        if (lookupElementBuilder == null) {
            RenameWrongRefFix.$$$reportNull$$$0(6);
        }
        return lookupElementBuilder;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            RenameWrongRefFix.$$$reportNull$$$0(7);
        }
        PsiReferenceExpression[] refs = CreateFromUsageUtils.collectExpressions((PsiExpression)this.myRefExpr, PsiMember.class, PsiFile.class);
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)this.myRefExpr, (Class[])new Class[]{PsiMember.class, PsiFile.class});
        LookupElement[] items = this.collectItems();
        ReferenceNameExpression refExpr = new ReferenceNameExpression(items, this.myRefExpr.getReferenceName());
        TemplateBuilderImpl builder = new TemplateBuilderImpl(element);
        for (PsiReferenceExpression expr2 : refs) {
            if (!expr2.equals(this.myRefExpr)) {
                builder.replaceElement(expr2.getReferenceNameElement(), OTHER_VARIABLE_NAME, INPUT_VARIABLE_NAME, false);
                continue;
            }
            builder.replaceElement(expr2.getReferenceNameElement(), INPUT_VARIABLE_NAME, (Expression)refExpr, true);
        }
        float proportion = EditorUtil.calcVerticalScrollProportion((Editor)editor);
        editor.getCaretModel().moveToOffset(element.getTextRange().getStartOffset());
        Template template = builder.buildInlineTemplate();
        editor.getCaretModel().moveToOffset(element.getTextRange().getStartOffset());
        TemplateManager.getInstance((Project)project).startTemplate(editor, template);
        EditorUtil.setVerticalScrollProportion((Editor)editor, (float)proportion);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            RenameWrongRefFix.$$$reportNull$$$0(8);
        }
        if (!Registry.is((String)"editor.show.popup.for.unresolved.references", (boolean)false)) {
            return false;
        }
        LookupElement[] items = this.collectItems();
        if (items.length == 0) {
            return false;
        }
        String hintText = ShowAutoImportPass.getMessage((items.length > 1 ? 1 : 0) != 0, (String)items[0].getLookupString());
        TextRange textRange = this.myRefExpr.getTextRange();
        HintManager.getInstance().showQuestionHint(editor, hintText, textRange.getStartOffset(), textRange.getEndOffset(), (QuestionAction)new RenameWrongRefQuestionAction(items, editor));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameWrongRefFix";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameWrongRefFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectItems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RenameWrongRefQuestionAction
    implements QuestionAction {
        private final LookupElement[] myItems;
        private final Editor myEditor;

        private RenameWrongRefQuestionAction(LookupElement[] items, Editor editor) {
            this.myItems = items;
            this.myEditor = editor;
        }

        public boolean execute() {
            if (this.myItems.length == 1 && RenameWrongRefFix.this.myRefExpr.getTextRange().contains(this.myEditor.getCaretModel().getOffset())) {
                this.doFix(this.myItems[0]);
                return true;
            }
            JBPopupFactory.getInstance().createPopupChooserBuilder(Arrays.asList(this.myItems)).setTitle(QuickFixBundle.message("rename.reference", new Object[0])).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                    Component component = super.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus);
                    if (value2 instanceof LookupElement) {
                        this.setText(((LookupElement)value2).getLookupString());
                    }
                    return component;
                }
            }).setItemChosenCallback(element -> this.doFix((LookupElement)element)).createPopup().showInBestPositionFor(this.myEditor);
            return true;
        }

        private void doFix(LookupElement element) {
            Project project = RenameWrongRefFix.this.myRefExpr.getProject();
            PsiExpression referenceFromText = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(element.getLookupString(), (PsiElement)RenameWrongRefFix.this.myRefExpr);
            PsiReferenceExpression[] refs = CreateFromUsageUtils.collectExpressions((PsiExpression)RenameWrongRefFix.this.myRefExpr, PsiMember.class, PsiFile.class);
            WriteCommandAction.runWriteCommandAction((Project)project, (String)RenameWrongRefFix.this.getText(), null, () -> {
                for (PsiReferenceExpression ref : refs) {
                    ref.replace((PsiElement)referenceFromText);
                }
            }, (PsiFile[])new PsiFile[]{RenameWrongRefFix.this.myRefExpr.getContainingFile()});
        }
    }
}

