/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExportsDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddUsesDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.GoToSymbolFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeModuleStatementsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

class ModuleHighlightUtil {
    ModuleHighlightUtil() {
    }

    static HighlightInfo checkPackageStatement(@NotNull PsiPackageStatement statement, @NotNull PsiFile file, @Nullable PsiJavaModule module) {
        PsiJavaModule origin;
        String packageName;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(1);
        }
        if (PsiUtil.isModuleFile((PsiFile)file)) {
            String message2 = JavaErrorBundle.message("module.no.package", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)statement));
            return info;
        }
        if (module != null && (packageName = statement.getPackageName()) != null && (origin = JavaModuleGraphUtil.findOrigin(module, packageName)) != null) {
            String message3 = JavaErrorBundle.message("module.conflicting.packages", packageName, origin.getName());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message3).create();
        }
        return null;
    }

    static HighlightInfo checkFileName(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        if (element == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(3);
        }
        if (!"module-info.java".equals(file.getName())) {
            String message2 = JavaErrorBundle.message("module.file.wrong.name", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createRenameFileFix("module-info.java"));
            return info;
        }
        return null;
    }

    static HighlightInfo checkFileDuplicates(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        Project project;
        Collection others;
        Module module;
        if (element == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(4);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)file)) != null && (others = FilenameIndex.getVirtualFilesByName((Project)(project = file.getProject()), (String)"module-info.java", (GlobalSearchScope)module.getModuleScope())).size() > 1) {
            String message2 = JavaErrorBundle.message("module.file.duplicate", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message2).create();
            others.stream().map(f -> PsiManager.getInstance((Project)project).findFile(f)).filter(f -> f != file).findFirst().ifPresent(duplicate -> QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new GoToSymbolFix((NavigatablePsiElement)duplicate, JavaErrorBundle.message("module.open.duplicate.text", new Object[0]))));
            return info;
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkDuplicateStatements(@NotNull PsiJavaModule module) {
        if (module == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(6);
        }
        SmartList results = new SmartList();
        ModuleHighlightUtil.checkDuplicateRefs(module.getRequires(), st -> st.getModuleName(), "module.duplicate.requires", (List<? super HighlightInfo>)results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getExports(), st -> st.getPackageName(), "module.duplicate.exports", (List<? super HighlightInfo>)results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getOpens(), st -> st.getPackageName(), "module.duplicate.opens", (List<? super HighlightInfo>)results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getUses(), st -> ModuleHighlightUtil.qName(st.getClassReference()), "module.duplicate.uses", (List<? super HighlightInfo>)results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getProvides(), st -> ModuleHighlightUtil.qName(st.getInterfaceReference()), "module.duplicate.provides", (List<? super HighlightInfo>)results);
        SmartList smartList = results;
        if (smartList == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    private static <T extends PsiStatement> void checkDuplicateRefs(Iterable<? extends T> statements, Function<? super T, String> ref, @PropertyKey(resourceBundle="messages.JavaErrorBundle") String key2, List<? super HighlightInfo> results) {
        THashSet filter = new THashSet();
        for (PsiStatement statement : statements) {
            String refText = ref.apply(statement);
            if (refText == null || filter.add(refText)) continue;
            String message2 = JavaErrorBundle.message(key2, refText);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)statement));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, MergeModuleStatementsFix.createFix((PsiElement)statement));
            results.add((HighlightInfo)info);
        }
    }

    @NotNull
    static List<HighlightInfo> checkUnusedServices(@NotNull PsiJavaModule module, @NotNull PsiFile file) {
        List provides;
        if (module == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(8);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(9);
        }
        SmartList results = new SmartList();
        Module host = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (host != null && !(provides = JBIterable.from((Iterable)module.getProvides()).toList()).isEmpty()) {
            Set exports = JBIterable.from((Iterable)module.getExports()).map(PsiPackageAccessibilityStatement::getPackageName).filter(Objects::nonNull).toSet();
            Set uses = JBIterable.from((Iterable)module.getUses()).map(st -> ModuleHighlightUtil.qName(st.getClassReference())).filter(Objects::nonNull).toSet();
            for (PsiProvidesStatement statement : provides) {
                String className2;
                String packageName;
                PsiElement target;
                PsiJavaCodeReferenceElement ref = statement.getInterfaceReference();
                if (ref == null || !((target = ref.resolve()) instanceof PsiClass) || ModuleUtilCore.findModuleForFile((PsiFile)target.getContainingFile()) != host || exports.contains(packageName = StringUtil.getPackageName((String)(className2 = ModuleHighlightUtil.qName(ref)))) || uses.contains(className2)) continue;
                String message2 = JavaErrorBundle.message("module.service.unused", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(ref)).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new AddExportsDirectiveFix(module, packageName, ""));
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new AddUsesDirectiveFix(module, className2));
                results.add(info);
            }
        }
        SmartList smartList = results;
        if (smartList == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private static String qName(PsiJavaCodeReferenceElement ref) {
        return ref != null ? ref.getQualifiedName() : null;
    }

    static HighlightInfo checkFileLocation(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        VirtualFile root;
        VirtualFile vFile;
        if (element == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(11);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(12);
        }
        if ((vFile = file.getVirtualFile()) != null && (root = ProjectFileIndex.SERVICE.getInstance((Project)file.getProject()).getSourceRootForFile(vFile)) != null && !root.equals(vFile.getParent())) {
            String message2 = JavaErrorBundle.message("module.file.wrong.location", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new MoveFileFix(vFile, root, QuickFixBundle.message("move.file.to.source.root.text", new Object[0])));
            return info;
        }
        return null;
    }

    static HighlightInfo checkModuleReference(@NotNull PsiRequiresStatement statement) {
        PsiJavaModuleReferenceElement refElement;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(13);
        }
        if ((refElement = statement.getReferenceElement()) != null) {
            PsiJavaModuleReference ref = refElement.getReference();
            assert (ref != null) : refElement.getParent();
            PsiJavaModule target = ref.resolve();
            if (target == null) {
                if (ref.multiResolve(true).length == 0) {
                    String message2 = JavaErrorBundle.message("module.not.found", refElement.getReferenceText());
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
                }
                if (ref.multiResolve(false).length > 1) {
                    String message3 = JavaErrorBundle.message("module.ambiguous", refElement.getReferenceText());
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range((PsiElement)refElement).descriptionAndTooltip(message3).create();
                }
                String message4 = JavaErrorBundle.message("module.not.on.path", refElement.getReferenceText());
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range((PsiElement)refElement).descriptionAndTooltip(message4).create();
                ModuleHighlightUtil.factory().registerOrderEntryFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info), (PsiReference)ref);
                return info;
            }
            PsiJavaModule container = (PsiJavaModule)statement.getParent();
            if (target == container) {
                String message5 = JavaErrorBundle.message("module.cyclic.dependence", container.getName());
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)refElement).descriptionAndTooltip(message5).create();
            }
            Collection<PsiJavaModule> cycle = JavaModuleGraphUtil.findCycle(target);
            if (cycle.contains(container)) {
                Stream<String> stream = cycle.stream().map(PsiJavaModule::getName);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    stream = stream.sorted();
                }
                String message6 = JavaErrorBundle.message("module.cyclic.dependence", stream.collect(Collectors.joining(", ")));
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)refElement).descriptionAndTooltip(message6).create();
            }
        }
        return null;
    }

    static HighlightInfo checkHostModuleStrength(@NotNull PsiPackageAccessibilityStatement statement) {
        PsiElement parent;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(14);
        }
        if (statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS && (parent = statement.getParent()) instanceof PsiJavaModule && ((PsiJavaModule)parent).hasModifierProperty("open")) {
            String message2 = JavaErrorBundle.message("module.opens.in.weak.module", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createModifierListFix((PsiModifierListOwner)parent, "open", false, false));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)statement));
            return info;
        }
        return null;
    }

    static HighlightInfo checkPackageReference(@NotNull PsiPackageAccessibilityStatement statement, @NotNull PsiFile file) {
        Module module;
        PsiJavaCodeReferenceElement refElement;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(15);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(16);
        }
        if ((refElement = statement.getPackageReference()) != null && (module = ModuleUtilCore.findModuleForFile((PsiFile)file)) != null) {
            HighlightInfoType type2;
            PsiElement target = refElement.resolve();
            PsiDirectory[] directories = PsiDirectory.EMPTY_ARRAY;
            if (target instanceof PsiPackage) {
                boolean inTests = ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(file.getVirtualFile());
                directories = ((PsiPackage)target).getDirectories(module.getModuleScope(inTests));
            }
            String packageName = statement.getPackageName();
            boolean opens = statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS;
            HighlightInfoType highlightInfoType = type2 = opens ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            if (directories.length == 0) {
                String message2 = JavaErrorBundle.message("package.not.found", packageName);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)type2).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createCreateClassInPackageInModuleFix(module, packageName));
                return info;
            }
            if (packageName != null && ModuleHighlightUtil.isPackageEmpty(directories, packageName, opens)) {
                String message3 = JavaErrorBundle.message("package.is.empty", packageName);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)type2).range((PsiElement)refElement).descriptionAndTooltip(message3).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createCreateClassInPackageInModuleFix(module, packageName));
                return info;
            }
        }
        return null;
    }

    private static boolean isPackageEmpty(PsiDirectory[] directories, String packageName, boolean anyFile) {
        if (anyFile) {
            return Arrays.stream(directories).noneMatch(dir -> dir.getFiles().length > 0);
        }
        return PsiUtil.isPackageEmpty((PsiDirectory[])directories, (String)packageName);
    }

    @NotNull
    static List<HighlightInfo> checkPackageAccessTargets(@NotNull PsiPackageAccessibilityStatement statement) {
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(17);
        }
        SmartList results = new SmartList();
        THashSet targets = new THashSet();
        for (PsiJavaModuleReferenceElement refElement : statement.getModuleReferences()) {
            String refText = refElement.getReferenceText();
            PsiJavaModuleReference ref = refElement.getReference();
            assert (ref != null) : statement;
            if (!targets.add(refText)) {
                boolean exports = statement.getRole() == PsiPackageAccessibilityStatement.Role.EXPORTS;
                String message2 = JavaErrorBundle.message(exports ? "module.duplicate.exports.target" : "module.duplicate.opens.target", refText);
                HighlightInfo info = ModuleHighlightUtil.duplicateReference((PsiElement)refElement, message2);
                results.add(info);
                continue;
            }
            if (ref.multiResolve(true).length != 0) continue;
            String message3 = JavaErrorBundle.message("module.not.found", refElement.getReferenceText());
            results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range((PsiElement)refElement).descriptionAndTooltip(message3).create());
        }
        SmartList smartList = results;
        if (smartList == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    static HighlightInfo checkServiceReference(@Nullable PsiJavaCodeReferenceElement refElement) {
        if (refElement != null) {
            PsiElement target = refElement.resolve();
            if (!(target instanceof PsiClass)) {
                String message2 = JavaErrorBundle.message("cannot.resolve.symbol", refElement.getReferenceName());
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).descriptionAndTooltip(message2).create();
            }
            if (((PsiClass)target).isEnum()) {
                String message3 = JavaErrorBundle.message("module.service.enum", ((PsiClass)target).getName());
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).descriptionAndTooltip(message3).create();
            }
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkServiceImplementations(@NotNull PsiProvidesStatement statement, @NotNull PsiFile file) {
        PsiReferenceList implRefList;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(19);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(20);
        }
        if ((implRefList = statement.getImplementationList()) == null) {
            List<HighlightInfo> list = Collections.emptyList();
            if (list == null) {
                ModuleHighlightUtil.$$$reportNull$$$0(21);
            }
            return list;
        }
        SmartList results = new SmartList();
        PsiJavaCodeReferenceElement intRef = statement.getInterfaceReference();
        PsiElement intTarget = intRef != null ? intRef.resolve() : null;
        THashSet filter = new THashSet();
        for (PsiJavaCodeReferenceElement implRef : implRefList.getReferenceElements()) {
            String message2;
            PsiMethod provider;
            PsiElement implTarget;
            String refText = implRef.getQualifiedName();
            if (!filter.add(refText)) {
                String message3 = JavaErrorBundle.message("module.duplicate.impl", refText);
                HighlightInfo info = ModuleHighlightUtil.duplicateReference((PsiElement)implRef, message3);
                results.add(info);
                continue;
            }
            if (!(intTarget instanceof PsiClass) || !((implTarget = implRef.resolve()) instanceof PsiClass)) continue;
            PsiClass implClass = (PsiClass)implTarget;
            if (ModuleUtilCore.findModuleForFile((PsiFile)file) != ModuleUtilCore.findModuleForFile((PsiFile)implClass.getContainingFile())) {
                String message4 = JavaErrorBundle.message("module.service.alien", new Object[0]);
                results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message4).create());
            }
            if ((provider = (PsiMethod)ContainerUtil.find((Object[])implClass.findMethodsByName("provider", false), m -> m.hasModifierProperty("public") && m.hasModifierProperty("static") && m.getParameterList().isEmpty())) != null) {
                PsiClass typeClass;
                PsiType type2 = provider.getReturnType();
                PsiClass psiClass = typeClass = type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)typeClass, (PsiClass)((PsiClass)intTarget), (boolean)true)) continue;
                String message5 = JavaErrorBundle.message("module.service.provider.type", implClass.getName());
                results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message5).create());
                continue;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)implClass, (PsiClass)((PsiClass)intTarget), (boolean)true)) {
                if (implClass.hasModifierProperty("abstract")) {
                    message2 = JavaErrorBundle.message("module.service.abstract", implClass.getName());
                    results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
                    continue;
                }
                if (!ClassUtil.isTopLevelClass((PsiClass)implClass) && !implClass.hasModifierProperty("static")) {
                    message2 = JavaErrorBundle.message("module.service.inner", implClass.getName());
                    results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
                    continue;
                }
                if (PsiUtil.hasDefaultConstructor((PsiClass)implClass)) continue;
                message2 = JavaErrorBundle.message("module.service.no.ctor", implClass.getName());
                results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
                continue;
            }
            message2 = JavaErrorBundle.message("module.service.impl", new Object[0]);
            results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
        }
        SmartList smartList = results;
        if (smartList == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(22);
        }
        return smartList;
    }

    static HighlightInfo checkClashingReads(@NotNull PsiJavaModule module) {
        Trinity<String, PsiJavaModule, PsiJavaModule> conflict;
        if (module == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(23);
        }
        if ((conflict = JavaModuleGraphUtil.findConflict(module)) != null) {
            String message2 = JavaErrorBundle.message("module.conflicting.reads", module.getName(), conflict.first, ((PsiJavaModule)conflict.second).getName(), ((PsiJavaModule)conflict.third).getName());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(module)).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkModifiers(@NotNull PsiRequiresStatement statement) {
        PsiModifierList modList;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(24);
        }
        if ((modList = statement.getModifierList()) != null && "java.base".equals(statement.getModuleName())) {
            List list = SyntaxTraverser.psiTraverser().children((Object)modList).filter(PsiKeyword.class).map(keyword -> {
                String modifier = keyword.getText();
                String message2 = JavaErrorBundle.message("modifier.not.allowed", modifier);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createModifierListFix(modList, modifier, false, false));
                return info;
            }).toList();
            if (list == null) {
                ModuleHighlightUtil.$$$reportNull$$$0(25);
            }
            return list;
        }
        List<HighlightInfo> list = Collections.emptyList();
        if (list == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(26);
        }
        return list;
    }

    private static QuickFixFactory factory() {
        return QuickFixFactory.getInstance();
    }

    private static TextRange range(PsiJavaModule module) {
        PsiKeyword kw = (PsiKeyword)PsiTreeUtil.getChildOfType((PsiElement)module, PsiKeyword.class);
        return new TextRange(kw != null ? kw.getTextOffset() : module.getTextOffset(), module.getNameIdentifier().getTextRange().getEndOffset());
    }

    private static PsiElement range(PsiJavaCodeReferenceElement refElement) {
        return (PsiElement)ObjectUtils.notNull((Object)refElement.getReferenceNameElement(), (Object)refElement);
    }

    private static HighlightInfo duplicateReference(PsiElement refElement, String message2) {
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(refElement).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix(refElement, QuickFixBundle.message("delete.reference.fix.text", new Object[0])));
        return info;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDuplicateStatements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "checkUnusedServices";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPackageAccessTargets";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "checkServiceImplementations";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "checkModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageStatement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFileName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFileDuplicates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateStatements";
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkUnusedServices";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkFileLocation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkModuleReference";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkHostModuleStrength";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageReference";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageAccessTargets";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceImplementations";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkClashingReads";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkModifiers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

