/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.application.options.editor.AutoImportOptionsConfigurable;
import com.intellij.application.options.editor.JavaAutoImportOptions;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddImportAction
implements QuestionAction {
    private static final Logger LOG = Logger.getInstance(AddImportAction.class);
    private final Project myProject;
    private final PsiReference myReference;
    private final PsiClass[] myTargetClasses;
    private final Editor myEditor;

    public AddImportAction(@NotNull Project project, @NotNull PsiReference ref, @NotNull Editor editor, PsiClass ... targetClasses) {
        if (project == null) {
            AddImportAction.$$$reportNull$$$0(0);
        }
        if (ref == null) {
            AddImportAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            AddImportAction.$$$reportNull$$$0(2);
        }
        if (targetClasses == null) {
            AddImportAction.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myReference = ref;
        this.myTargetClasses = targetClasses;
        this.myEditor = editor;
    }

    public boolean execute() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        if (!this.myReference.getElement().isValid()) {
            return false;
        }
        for (PsiClass myTargetClass : this.myTargetClasses) {
            if (myTargetClass.isValid()) continue;
            return false;
        }
        if (this.myTargetClasses.length == 1) {
            this.addImport(this.myReference, this.myTargetClasses[0]);
        } else {
            this.chooseClassAndImport();
        }
        return true;
    }

    private void chooseClassAndImport() {
        CodeInsightUtil.sortIdenticalShortNamedMembers((PsiMember[])this.myTargetClasses, (PsiReference)this.myReference);
        BaseListPopupStep<PsiClass> step2 = new BaseListPopupStep<PsiClass>(QuickFixBundle.message("class.to.import.chooser.title", new Object[0]), this.myTargetClasses){

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(PsiClass selectedValue, boolean finalChoice) {
                if (selectedValue == null) {
                    return FINAL_CHOICE;
                }
                if (finalChoice) {
                    return this.doFinalStep(() -> {
                        PsiDocumentManager.getInstance((Project)AddImportAction.this.myProject).commitAllDocuments();
                        AddImportAction.this.addImport(AddImportAction.this.myReference, selectedValue);
                    });
                }
                return AddImportAction.getExcludesStep(AddImportAction.this.myProject, selectedValue.getQualifiedName());
            }

            public boolean hasSubstep(PsiClass selectedValue) {
                return true;
            }

            @NotNull
            public String getTextFor(PsiClass value2) {
                String string = Objects.requireNonNull(value2.getQualifiedName());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public Icon getIconFor(PsiClass aValue) {
                return aValue.getIcon(0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AddImportAction$1", "getTextFor"));
            }
        };
        ListPopupImpl popup = new ListPopupImpl(this.myProject, (ListPopupStep)step2){

            protected ListCellRenderer getListElementRenderer() {
                PopupListElementRenderer baseRenderer = (PopupListElementRenderer)super.getListElementRenderer();
                DefaultPsiElementCellRenderer psiRenderer = new DefaultPsiElementCellRenderer();
                return (list, value2, index, isSelected, cellHasFocus) -> {
                    JPanel panel2 = new JPanel(new BorderLayout());
                    baseRenderer.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus);
                    panel2.add((Component)baseRenderer.getNextStepLabel(), "East");
                    panel2.add(psiRenderer.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus));
                    return panel2;
                };
            }
        };
        NavigationUtil.hidePopupIfDumbModeStarts((JBPopup)popup, (Project)this.myProject);
        popup.showInBestPositionFor(this.myEditor);
    }

    @Nullable
    public static PopupStep getExcludesStep(final @NotNull Project project, @Nullable String qname) {
        if (project == null) {
            AddImportAction.$$$reportNull$$$0(4);
        }
        if (qname == null) {
            return PopupStep.FINAL_CHOICE;
        }
        List<String> toExclude = AddImportAction.getAllExcludableStrings(qname);
        return new BaseListPopupStep<String>(null, toExclude){

            @NotNull
            public String getTextFor(String value2) {
                String string = "Exclude '" + value2 + "' from auto-import";
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                if (finalChoice && selectedValue != null) {
                    AddImportAction.excludeFromImport(project, selectedValue);
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AddImportAction$3", "getTextFor"));
            }
        };
    }

    public static void excludeFromImport(@NotNull Project project, @NotNull String prefix) {
        if (project == null) {
            AddImportAction.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            AddImportAction.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project.isDisposed()) {
                return;
            }
            AutoImportOptionsConfigurable configurable = new AutoImportOptionsConfigurable(project);
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
                JavaAutoImportOptions options = (JavaAutoImportOptions)ContainerUtil.findInstance((Iterable)configurable.getConfigurables(), JavaAutoImportOptions.class);
                options.addExcludePackage(prefix);
            });
        });
    }

    @NotNull
    public static List<String> getAllExcludableStrings(@NotNull String qname) {
        if (qname == null) {
            AddImportAction.$$$reportNull$$$0(7);
        }
        ArrayList<String> toExclude = new ArrayList<String>();
        while (true) {
            toExclude.add(qname);
            int i = qname.lastIndexOf(46);
            if (i < 0 || i == qname.indexOf(46)) break;
            qname = qname.substring(0, i);
        }
        ArrayList<String> arrayList = toExclude;
        if (arrayList == null) {
            AddImportAction.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private void addImport(@NotNull PsiReference ref, @NotNull PsiClass targetClass) {
        if (ref == null) {
            AddImportAction.$$$reportNull$$$0(9);
        }
        if (targetClass == null) {
            AddImportAction.$$$reportNull$$$0(10);
        }
        DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(() -> {
            if (!ref.getElement().isValid() || !targetClass.isValid() || ref.resolve() == targetClass) {
                return;
            }
            StatisticsManager.getInstance().incUseCount(JavaStatisticsManager.createInfo(null, (PsiMember)targetClass));
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)QuickFixBundle.message("add.import", new Object[0]), null, () -> this.doAddImport(ref, targetClass), (PsiFile[])new PsiFile[]{ref.getElement().getContainingFile()});
        });
    }

    private void doAddImport(@NotNull PsiReference ref, @NotNull PsiClass targetClass) {
        if (ref == null) {
            AddImportAction.$$$reportNull$$$0(11);
        }
        if (targetClass == null) {
            AddImportAction.$$$reportNull$$$0(12);
        }
        try {
            this.bindReference(ref, targetClass);
            if (CodeInsightWorkspaceSettings.getInstance((Project)this.myProject).optimizeImportsOnTheFly) {
                Document document = this.myEditor.getDocument();
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
                new OptimizeImportsProcessor(this.myProject, psiFile).runWithoutProgress();
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    protected void bindReference(@NotNull PsiReference ref, @NotNull PsiClass targetClass) {
        if (ref == null) {
            AddImportAction.$$$reportNull$$$0(13);
        }
        if (targetClass == null) {
            AddImportAction.$$$reportNull$$$0(14);
        }
        ref.bindToElement((PsiElement)targetClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClasses";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/AddImportAction";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/AddImportAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllExcludableStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExcludesStep";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "excludeFromImport";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllExcludableStrings";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doAddImport";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "bindReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

