/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.impl.JavaLensConfigurable;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaLensSettings;
import com.intellij.codeInsight.daemon.impl.analysis.JavaTelescope;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.BiStatePresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.SequencePresentation;
import com.intellij.codeInsight.hints.presentation.SpacePresentation;
import com.intellij.codeInsight.hints.settings.InlayHintsConfigurable;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.SmartList;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLensProvider
implements InlayHintsProvider<JavaLensSettings> {
    private static final SettingsKey<JavaLensSettings> KEY = new SettingsKey("JavaLens");
    private static final String FUS_GROUP_ID = "java.lens";
    private static final String USAGES_CLICKED_EVENT_ID = "usages.clicked";
    private static final String IMPLEMENTATIONS_CLICKED_EVENT_ID = "implementations.clicked";
    private static final String SETTING_CLICKED_EVENT_ID = "setting.clicked";

    @Nullable
    public InlayHintsCollector getCollectorFor(final @NotNull PsiFile file, @NotNull Editor editor, final @NotNull JavaLensSettings settings, @NotNull InlayHintsSink __) {
        if (file == null) {
            JavaLensProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaLensProvider.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            JavaLensProvider.$$$reportNull$$$0(2);
        }
        if (__ == null) {
            JavaLensProvider.$$$reportNull$$$0(3);
        }
        return new FactoryInlayHintsCollector(editor){

            public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
                String usagesHint;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (sink == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!(element instanceof PsiMember) || element instanceof PsiTypeParameter) {
                    return true;
                }
                PsiMember member = (PsiMember)element;
                if (member.getName() == null) {
                    return true;
                }
                SmartList hints = new SmartList();
                if (settings.isShowUsages() && (usagesHint = JavaTelescope.usagesHint(member, file)) != null) {
                    hints.add(new InlResult(){

                        @Override
                        public void onClick(@NotNull Editor editor, @NotNull PsiElement element, MouseEvent event) {
                            if (editor == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (element == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            FUCounterUsageLogger.getInstance().logEvent(file.getProject(), JavaLensProvider.FUS_GROUP_ID, JavaLensProvider.USAGES_CLICKED_EVENT_ID);
                            GotoDeclarationAction.startFindUsages((Editor)editor, (Project)file.getProject(), (PsiElement)element, (RelativePoint)new RelativePoint(event));
                        }

                        @Override
                        @NotNull
                        public String getRegularText() {
                            String string = usagesHint;
                            if (string == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 2: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 2: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "editor";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "element";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1$1";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getRegularText";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "onClick";
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 2: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                }
                if (settings.isShowImplementations()) {
                    int overridings;
                    int inheritors;
                    if (element instanceof PsiClass && (inheritors = JavaTelescope.collectInheritingClasses((PsiClass)element)) != 0) {
                        hints.add(new InlResult(){

                            @Override
                            public void onClick(@NotNull Editor editor, @NotNull PsiElement element, MouseEvent event) {
                                if (editor == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                if (element == null) {
                                    2.$$$reportNull$$$0(1);
                                }
                                FeatureUsageData data = new FeatureUsageData().addData("location", "class");
                                FUCounterUsageLogger.getInstance().logEvent(file.getProject(), JavaLensProvider.FUS_GROUP_ID, JavaLensProvider.IMPLEMENTATIONS_CLICKED_EVENT_ID, data);
                                GutterIconNavigationHandler<PsiElement> navigationHandler = MarkerType.SUBCLASSED_CLASS.getNavigationHandler();
                                navigationHandler.navigate(event, (PsiElement)((PsiClass)element).getNameIdentifier());
                            }

                            @Override
                            @NotNull
                            public String getRegularText() {
                                String prop = "{0, choice, 1#1 Implementation|2#{0,number} Implementations}";
                                String string = MessageFormat.format(prop, inheritors);
                                if (string == null) {
                                    2.$$$reportNull$$$0(2);
                                }
                                return string;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string;
                                switch (n) {
                                    default: {
                                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                    case 2: {
                                        string = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 3;
                                        break;
                                    }
                                    case 2: {
                                        n2 = 2;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "editor";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "element";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1$2";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1$2";
                                        break;
                                    }
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "getRegularText";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray;
                                        objectArray[2] = "onClick";
                                        break;
                                    }
                                    case 2: {
                                        break;
                                    }
                                }
                                String string2 = String.format(string, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalArgumentException(string2);
                                        break;
                                    }
                                    case 2: {
                                        runtimeException = new IllegalStateException(string2);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        });
                    }
                    if (element instanceof PsiMethod && (overridings = JavaTelescope.collectOverridingMethods((PsiMethod)element)) != 0) {
                        hints.add(new InlResult(){

                            @Override
                            public void onClick(@NotNull Editor editor, @NotNull PsiElement element, MouseEvent event) {
                                if (editor == null) {
                                    3.$$$reportNull$$$0(0);
                                }
                                if (element == null) {
                                    3.$$$reportNull$$$0(1);
                                }
                                FeatureUsageData data = new FeatureUsageData().addData("location", "method");
                                FUCounterUsageLogger.getInstance().logEvent(file.getProject(), JavaLensProvider.FUS_GROUP_ID, JavaLensProvider.IMPLEMENTATIONS_CLICKED_EVENT_ID, data);
                                GutterIconNavigationHandler<PsiElement> navigationHandler = MarkerType.OVERRIDDEN_METHOD.getNavigationHandler();
                                navigationHandler.navigate(event, (PsiElement)((PsiMethod)element).getNameIdentifier());
                            }

                            @Override
                            @NotNull
                            public String getRegularText() {
                                String prop = "{0, choice, 1#1 Implementation|2#{0,number} Implementations}";
                                String string = MessageFormat.format(prop, overridings);
                                if (string == null) {
                                    3.$$$reportNull$$$0(2);
                                }
                                return string;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string;
                                switch (n) {
                                    default: {
                                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                    case 2: {
                                        string = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 3;
                                        break;
                                    }
                                    case 2: {
                                        n2 = 2;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "editor";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "element";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1$3";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1$3";
                                        break;
                                    }
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "getRegularText";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray;
                                        objectArray[2] = "onClick";
                                        break;
                                    }
                                    case 2: {
                                        break;
                                    }
                                }
                                String string2 = String.format(string, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalArgumentException(string2);
                                        break;
                                    }
                                    case 2: {
                                        runtimeException = new IllegalStateException(string2);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        });
                    }
                }
                if (!hints.isEmpty()) {
                    PresentationFactory factory = this.getFactory();
                    Document document = editor.getDocument();
                    int offset = JavaLensProvider.getAnchorOffset(element);
                    int columnWidth = EditorUtil.getPlainSpaceWidth((Editor)editor);
                    int line = document.getLineNumber(offset);
                    int startOffset = document.getLineStartOffset(line);
                    int column = offset - startOffset;
                    SmartList presentations2 = new SmartList();
                    presentations2.add(new SpacePresentation(column * columnWidth, 0));
                    for (InlResult inlResult : hints) {
                        presentations2.add(JavaLensProvider.createPresentation(factory, element, editor, inlResult));
                        presentations2.add(new SpacePresentation(columnWidth, 0));
                    }
                    SequencePresentation shiftedPresentation = new SequencePresentation((List)presentations2);
                    SpacePresentation placeholder = new SpacePresentation(columnWidth * 5, 0);
                    InlayPresentation withSettingsAppearing = JavaLensProvider.createTopLevelPresentation(factory, (InlayPresentation)shiftedPresentation, JavaLensProvider.settings(factory, element, editor), (InlayPresentation)placeholder);
                    sink.addBlockElement(startOffset, true, true, 0, withSettingsAppearing);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sink";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1";
                objectArray[2] = "collect";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static InlayPresentation createTopLevelPresentation(@NotNull PresentationFactory factory, @NotNull InlayPresentation shifted, final @NotNull InlayPresentation settings, final @NotNull InlayPresentation settingsPlaceholder) {
        if (factory == null) {
            JavaLensProvider.$$$reportNull$$$0(4);
        }
        if (shifted == null) {
            JavaLensProvider.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            JavaLensProvider.$$$reportNull$$$0(6);
        }
        if (settingsPlaceholder == null) {
            JavaLensProvider.$$$reportNull$$$0(7);
        }
        final BiStatePresentation settingsOrPlaceholder = new BiStatePresentation(() -> settings, () -> settingsPlaceholder, false){

            public int getWidth() {
                return Math.max(settings.getWidth(), settingsPlaceholder.getWidth());
            }

            public int getHeight() {
                return Math.max(settings.getHeight(), settingsPlaceholder.getHeight());
            }
        };
        InlayPresentation withoutHover = factory.seq(new InlayPresentation[]{shifted, settingsOrPlaceholder});
        return factory.onHover(withoutHover, new InlayPresentationFactory.HoverListener(){

            public void onHover(@NotNull MouseEvent event, @NotNull Point translated) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (translated == null) {
                    3.$$$reportNull$$$0(1);
                }
                settingsOrPlaceholder.setFirst();
            }

            public void onHoverFinished() {
                settingsOrPlaceholder.setSecond();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "translated";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$3";
                objectArray[2] = "onHover";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static int getAnchorOffset(PsiElement element) {
        for (PsiElement child : element.getChildren()) {
            if (child instanceof PsiDocComment || child instanceof PsiWhiteSpace) continue;
            return child.getTextRange().getStartOffset();
        }
        return element.getTextRange().getStartOffset();
    }

    @NotNull
    private static InlayPresentation createPresentation(@NotNull PresentationFactory factory, @NotNull PsiElement element, @NotNull Editor editor, @NotNull InlResult result) {
        if (factory == null) {
            JavaLensProvider.$$$reportNull$$$0(8);
        }
        if (element == null) {
            JavaLensProvider.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            JavaLensProvider.$$$reportNull$$$0(10);
        }
        if (result == null) {
            JavaLensProvider.$$$reportNull$$$0(11);
        }
        InlayPresentation text2 = factory.smallText(result.getRegularText());
        InlayPresentation inlayPresentation = factory.referenceOnHover(text2, (event, translated) -> result.onClick(editor, element, event));
        if (inlayPresentation == null) {
            JavaLensProvider.$$$reportNull$$$0(12);
        }
        return inlayPresentation;
    }

    @NotNull
    private static InlayPresentation settings(@NotNull PresentationFactory factory, @NotNull PsiElement element, @NotNull Editor editor) {
        if (factory == null) {
            JavaLensProvider.$$$reportNull$$$0(13);
        }
        if (element == null) {
            JavaLensProvider.$$$reportNull$$$0(14);
        }
        if (editor == null) {
            JavaLensProvider.$$$reportNull$$$0(15);
        }
        return JavaLensProvider.createPresentation(factory, element, editor, new InlResult(){

            @Override
            public void onClick(@NotNull Editor editor, @NotNull PsiElement element, MouseEvent event) {
                if (editor == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (element == null) {
                    4.$$$reportNull$$$0(1);
                }
                Project project = element.getProject();
                FUCounterUsageLogger.getInstance().logEvent(project, JavaLensProvider.FUS_GROUP_ID, JavaLensProvider.SETTING_CLICKED_EVENT_ID);
                InlayHintsConfigurable.showSettingsDialogForLanguage((Project)project, (Language)element.getLanguage());
            }

            @Override
            @NotNull
            public String getRegularText() {
                return "Settings...";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$4";
                objectArray[2] = "onClick";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public JavaLensSettings createSettings() {
        return new JavaLensSettings();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = JavaBundle.message((String)"title.lenses", (Object[])new Object[0]);
        if (string == null) {
            JavaLensProvider.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public SettingsKey<JavaLensSettings> getKey() {
        SettingsKey<JavaLensSettings> settingsKey = KEY;
        if (settingsKey == null) {
            JavaLensProvider.$$$reportNull$$$0(17);
        }
        return settingsKey;
    }

    @Nullable
    public String getPreviewText() {
        return null;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull JavaLensSettings settings) {
        if (settings == null) {
            JavaLensProvider.$$$reportNull$$$0(18);
        }
        return new JavaLensConfigurable(settings);
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        if (language == null) {
            JavaLensProvider.$$$reportNull$$$0(19);
        }
        return true;
    }

    public boolean isVisibleInSettings() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "__";
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shifted";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsPlaceholder";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCollectorFor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTopLevelPresentation";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "settings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageSupported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface InlResult {
        public void onClick(@NotNull Editor var1, @NotNull PsiElement var2, MouseEvent var3);

        @NotNull
        public String getRegularText();
    }
}

