/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.ArrayMemberAccess;
import com.intellij.codeInsight.completion.CheckInitialized;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionSorting;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.RecursionWeigher;
import com.intellij.codeInsight.completion.SlowerTypeConversions;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementExtractorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.filters.types.AssignableFromFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceExpressionCompletionContributor {
    private static final Logger LOG = Logger.getInstance(ReferenceExpressionCompletionContributor.class);

    @NotNull
    static ElementFilter getReferenceFilter(PsiElement element, boolean allowRecursion) {
        ElementFilter filter;
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceExpression.class).withParent(PsiThrowStatement.class))).accepts((Object)element)) {
            ElementFilter elementFilter = TrueFilter.INSTANCE;
            if (elementFilter == null) {
                ReferenceExpressionCompletionContributor.$$$reportNull$$$0(0);
            }
            return elementFilter;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiAnnotationParameterList.class), JavaCompletionContributor.IN_SWITCH_LABEL}))).accepts((Object)element)) {
            return new ElementExtractorFilter((ElementFilter)new AndFilter((ElementFilter)new ClassFilter(PsiField.class), (ElementFilter)new ModifierFilter("static", "final")));
        }
        final PsiForeachStatement foreach = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiForeachStatement.class);
        if (foreach != null && !PsiTreeUtil.isAncestor((PsiElement)foreach.getBody(), (PsiElement)element, (boolean)false)) {
            return new ElementExtractorFilter(new ElementFilter(){

                public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                    return element != foreach.getIterationParameter();
                }

                public boolean isClassAcceptable(Class hintClass) {
                    return true;
                }
            });
        }
        if (!allowRecursion && (filter = RecursionWeigher.recursionFilter(element)) != null) {
            return new ElementExtractorFilter(filter);
        }
        ElementFilter elementFilter = TrueFilter.INSTANCE;
        if (elementFilter == null) {
            ReferenceExpressionCompletionContributor.$$$reportNull$$$0(1);
        }
        return elementFilter;
    }

    @Nullable
    public static Runnable fillCompletionVariants(JavaSmartCompletionParameters parameters2, Consumer<? super LookupElement> result) {
        PsiElement element = parameters2.getPosition();
        if (JavaSmartCompletionContributor.INSIDE_TYPECAST_EXPRESSION.accepts((Object)element)) {
            return null;
        }
        if (JavaKeywordCompletion.isAfterPrimitiveOrArrayType(element)) {
            return null;
        }
        int offset = parameters2.getParameters().getOffset();
        PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)element.getContainingFile(), (int)offset, PsiJavaCodeReferenceElement.class, (boolean)false);
        if (reference != null) {
            ElementFilter filter = ReferenceExpressionCompletionContributor.getReferenceFilter(element, false);
            if (CheckInitialized.isInsideConstructorCall(element)) {
                filter = new AndFilter(filter, (ElementFilter)new CheckInitialized(element));
            }
            for (LookupElement item : ReferenceExpressionCompletionContributor.completeFinalReference(element, reference, filter, parameters2)) {
                result.consume((Object)item);
            }
            boolean secondTime = parameters2.getParameters().getInvocationCount() >= 2;
            Set<LookupElement> base = JavaSmartCompletionContributor.completeReference(element, reference, filter, false, true, parameters2.getParameters(), PrefixMatcher.ALWAYS_TRUE);
            for (LookupElement item : new LinkedHashSet<LookupElement>(base)) {
                ExpressionLookupItem access = ArrayMemberAccess.accessFirstElement(element, item);
                if (access == null) continue;
                base.add(access);
                PsiType type2 = access.getType();
                if (type2 == null || !parameters2.getExpectedType().isAssignableFrom(type2)) continue;
                result.consume((Object)access);
            }
            if (secondTime) {
                return new SlowerTypeConversions(base, element, reference, parameters2, result);
            }
        }
        return null;
    }

    static Set<LookupElement> completeFinalReference(final PsiElement element, PsiJavaCodeReferenceElement reference, ElementFilter filter, final JavaSmartCompletionParameters parameters2) {
        final Set<Object> used = parameters2.getParameters().getInvocationCount() < 2 ? ReferenceExpressionCompletionContributor.findConstantsUsedInSwitch(element) : Collections.emptySet();
        Set<LookupElement> elements = JavaSmartCompletionContributor.completeReference(element, reference, (ElementFilter)new AndFilter(filter, new ElementFilter(){

            public boolean isAcceptable(Object o, PsiElement context) {
                if (o instanceof CandidateInfo) {
                    CandidateInfo info = (CandidateInfo)o;
                    PsiElement member = info.getElement();
                    PsiType expectedType = parameters2.getExpectedType();
                    if (expectedType.equals(PsiType.VOID)) {
                        return member instanceof PsiMethod;
                    }
                    if (member instanceof PsiEnumConstant && used.contains(CompletionUtil.getOriginalOrSelf((PsiElement)member))) {
                        return false;
                    }
                    return AssignableFromFilter.isAcceptable(member, element, expectedType, info.getSubstitutor());
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }), false, true, parameters2.getParameters(), PrefixMatcher.ALWAYS_TRUE);
        for (LookupElement lookupElement : elements) {
            JavaMethodCallElement item;
            if (!(lookupElement.getObject() instanceof PsiMethod) || (item = (JavaMethodCallElement)lookupElement.as(JavaMethodCallElement.CLASS_CONDITION_KEY)) == null) continue;
            item.setInferenceSubstitutorFromExpectedType(element, parameters2.getExpectedType());
            if (!JavaCompletionSorting.isTooGeneric(lookupElement, (PsiMethod)item.getObject())) continue;
            item.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        }
        return elements;
    }

    @NotNull
    public static Set<PsiField> findConstantsUsedInSwitch(@Nullable PsiElement position) {
        Set<PsiField> set = JavaCompletionContributor.IN_SWITCH_LABEL.accepts((Object)position) ? ReferenceExpressionCompletionContributor.findConstantsUsedInSwitch((PsiSwitchBlock)Objects.requireNonNull(PsiTreeUtil.getParentOfType((PsiElement)position, PsiSwitchBlock.class))) : Collections.emptySet();
        if (set == null) {
            ReferenceExpressionCompletionContributor.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public static Set<PsiField> findConstantsUsedInSwitch(@NotNull PsiSwitchBlock sw) {
        PsiCodeBlock body2;
        if (sw == null) {
            ReferenceExpressionCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((body2 = sw.getBody()) == null) {
            Set<PsiField> set = Collections.emptySet();
            if (set == null) {
                ReferenceExpressionCompletionContributor.$$$reportNull$$$0(4);
            }
            return set;
        }
        LinkedHashSet<PsiField> used = new LinkedHashSet<PsiField>();
        for (PsiStatement statement : body2.getStatements()) {
            PsiExpressionList values;
            if (!(statement instanceof PsiSwitchLabelStatementBase) || (values = ((PsiSwitchLabelStatementBase)statement).getCaseValues()) == null) continue;
            for (PsiExpression value2 : values.getExpressions()) {
                PsiElement target;
                if (!(value2 instanceof PsiReferenceExpression) || !((target = ((PsiReferenceExpression)value2).resolve()) instanceof PsiField)) continue;
                used.add((PsiField)CompletionUtil.getOriginalOrSelf((PsiElement)((PsiField)target)));
            }
        }
        LinkedHashSet<PsiField> linkedHashSet = used;
        if (linkedHashSet == null) {
            ReferenceExpressionCompletionContributor.$$$reportNull$$$0(5);
        }
        return linkedHashSet;
    }

    static PsiExpression createExpression(String text2, PsiElement element) {
        return JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText(text2, element);
    }

    static String getQualifierText(@Nullable PsiElement qualifier) {
        return qualifier == null ? "" : qualifier.getText() + ".";
    }

    @Nullable
    static PsiReferenceExpression createMockReference(PsiElement place, @NotNull PsiType qualifierType, LookupElement qualifierItem) {
        if (qualifierType == null) {
            ReferenceExpressionCompletionContributor.$$$reportNull$$$0(6);
        }
        return ReferenceExpressionCompletionContributor.createMockReference(place, qualifierType, qualifierItem, ".");
    }

    @Nullable
    static PsiReferenceExpression createMockReference(PsiElement place, @NotNull PsiType qualifierType, LookupElement qualifierItem, String separator) {
        if (qualifierType == null) {
            ReferenceExpressionCompletionContributor.$$$reportNull$$$0(7);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getProject());
        if (qualifierItem.getObject() instanceof PsiClass) {
            String qname = ((PsiClass)qualifierItem.getObject()).getQualifiedName();
            if (qname == null) {
                return null;
            }
            String text2 = qname + separator + "xxx";
            try {
                PsiExpression expr2 = factory.createExpressionFromText(text2, place);
                if (expr2 instanceof PsiReferenceExpression) {
                    return (PsiReferenceExpression)expr2;
                }
                return null;
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        return (PsiReferenceExpression)factory.createExpressionFromText("xxx" + separator + "xxx", (PsiElement)JavaCompletionUtil.createContextWithXxxVariable(place, qualifierType));
    }

    static String getSpace(boolean needSpace) {
        return needSpace ? " " : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sw";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceFilter";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findConstantsUsedInSwitch";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findConstantsUsedInSwitch";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createMockReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

