/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.JUnitLauncherTask;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.ListenerDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.SingleTestClass;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestRequest;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Resources;

public class TestClasses
extends TestDefinition {
    private final Resources resources = new Resources();

    public void add(ResourceCollection resourceCollection) {
        this.resources.add(resourceCollection);
    }

    @Override
    List<TestRequest> createTestRequests(JUnitLauncherTask launcherTask) {
        List<SingleTestClass> tests = this.getTests();
        if (tests.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TestRequest> requests = new ArrayList<TestRequest>();
        for (SingleTestClass test : tests) {
            requests.addAll(test.createTestRequests(launcherTask));
        }
        return requests;
    }

    private List<SingleTestClass> getTests() {
        if (this.resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SingleTestClass> tests = new ArrayList<SingleTestClass>();
        for (Resource resource : this.resources) {
            String name;
            if (!resource.isExists() || !(name = resource.getName()).endsWith(".class")) continue;
            String className = name.substring(0, name.lastIndexOf(46));
            BatchSourcedSingleTest test = new BatchSourcedSingleTest(className.replace(File.separatorChar, '.').replace('/', '.').replace('\\', '.'));
            tests.add(test);
        }
        return tests;
    }

    private final class BatchSourcedSingleTest
    extends SingleTestClass {
        private BatchSourcedSingleTest(String testClassName) {
            this.setName(testClassName);
        }

        @Override
        String getIfProperty() {
            return TestClasses.this.getIfProperty();
        }

        @Override
        String getUnlessProperty() {
            return TestClasses.this.getUnlessProperty();
        }

        @Override
        boolean isHaltOnFailure() {
            return TestClasses.this.isHaltOnFailure();
        }

        @Override
        String getFailureProperty() {
            return TestClasses.this.getFailureProperty();
        }

        @Override
        List<ListenerDefinition> getListeners() {
            return TestClasses.this.getListeners();
        }

        @Override
        String getOutputDir() {
            return TestClasses.this.getOutputDir();
        }

        @Override
        String[] getIncludeEngines() {
            return TestClasses.this.getIncludeEngines();
        }

        @Override
        String[] getExcludeEngines() {
            return TestClasses.this.getExcludeEngines();
        }
    }
}

