/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.tree;

import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.tree.AbstractDomElementNode;
import org.jetbrains.annotations.NotNull;

public class GenericValueNode
extends AbstractDomElementNode {
    protected GenericDomValue myModelElement;
    protected String myTagName;

    public GenericValueNode(GenericDomValue modelElement, SimpleNode parent) {
        super(modelElement, parent);
        this.myModelElement = modelElement;
        this.myTagName = modelElement.getXmlElementName();
    }

    @Override
    public String getNodeName() {
        return this.getPropertyName();
    }

    @Override
    public String getTagName() {
        return this.myTagName;
    }

    @Override
    public DomElement getDomElement() {
        return this.myModelElement;
    }

    protected void doUpdate() {
        this.setUniformIcon(this.getNodeIcon());
        this.clearColoredText();
        String stringValue = this.myModelElement.getStringValue();
        Object value = this.myModelElement.getValue();
        if (value instanceof Boolean) {
            this.addColoredFragment(this.getNodeName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.addColoredFragment("=", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.addColoredFragment(String.valueOf(value), SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
        } else if (stringValue != null) {
            this.addColoredFragment(this.getNodeName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.addColoredFragment("=", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.addColoredFragment("\"" + stringValue + "\"", SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
        } else {
            this.addColoredFragment(this.getNodeName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    public SimpleNode @NotNull [] getChildren() {
        if (NO_CHILDREN == null) {
            GenericValueNode.$$$reportNull$$$0(0);
        }
        return NO_CHILDREN;
    }

    public Object @NotNull [] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myModelElement};
        if (objectArray == null) {
            GenericValueNode.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/xml/tree/GenericValueNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

