/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;

public final class TextMateEditorUtils {
    @Nullable
    public static CharSequence getCurrentScopeSelector(@NotNull EditorEx editor) {
        TextMateLanguageDescriptor languageDescriptor;
        VirtualFile file;
        if (editor == null) {
            TextMateEditorUtils.$$$reportNull$$$0(0);
        }
        EditorHighlighter highlighter = editor.getHighlighter();
        SelectionModel selection = editor.getSelectionModel();
        int offset = selection.hasSelection() ? selection.getSelectionStart() : editor.getCaretModel().getOffset();
        HighlighterIterator iterator = highlighter.createIterator(offset);
        String result = null;
        if (offset != 0 || !iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            String string = result = tokenType != null ? tokenType.toString() : null;
        }
        if (result == null && (file = editor.getVirtualFile()) != null && (languageDescriptor = TextMateService.getInstance().getLanguageDescriptorByFileName(file.getName())) != null) {
            return languageDescriptor.getScopeName();
        }
        return result;
    }

    @Nullable
    public static TextMateBracePair getHighlightingPairForLeftChar(char c, @Nullable String currentSelector) {
        if (!TextMateService.getInstance().getPreferencesRegistry().isPossibleLeftHighlightingBrace(c)) {
            return null;
        }
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getAllPairsForMatcher(currentSelector);
        for (TextMateBracePair pair : pairs) {
            if (c != pair.leftChar) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static TextMateBracePair getHighlightingPairForRightChar(char c, @Nullable String currentSelector) {
        if (!TextMateService.getInstance().getPreferencesRegistry().isPossibleRightHighlightingBrace(c)) {
            return null;
        }
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getAllPairsForMatcher(currentSelector);
        for (TextMateBracePair pair : pairs) {
            if (c != pair.rightChar) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static TextMateBracePair getSmartTypingPairForLeftChar(char c, @Nullable CharSequence currentSelector) {
        if (!TextMateService.getInstance().getPreferencesRegistry().isPossibleLeftSmartTypingBrace(c)) {
            return null;
        }
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getSmartTypingPairs(currentSelector);
        for (TextMateBracePair pair : pairs) {
            if (c != pair.leftChar) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static TextMateBracePair getSmartTypingPairForRightChar(char c, @Nullable CharSequence currentSelector) {
        if (!TextMateService.getInstance().getPreferencesRegistry().isPossibleRightSmartTypingBrace(c)) {
            return null;
        }
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getSmartTypingPairs(currentSelector);
        for (TextMateBracePair pair : pairs) {
            if (c != pair.rightChar) continue;
            return pair;
        }
        return null;
    }

    private static Set<TextMateBracePair> getAllPairsForMatcher(@Nullable String selector) {
        HashSet<TextMateBracePair> result = new HashSet<TextMateBracePair>();
        if (selector != null) {
            List<Preferences> preferencesForSelector = TextMateService.getInstance().getPreferencesRegistry().getPreferences(selector);
            for (Preferences preferences : preferencesForSelector) {
                Set<TextMateBracePair> highlightingPairs = preferences.getHighlightingPairs();
                if (highlightingPairs == null) continue;
                if (highlightingPairs.isEmpty()) {
                    return Collections.emptySet();
                }
                result.addAll(highlightingPairs);
            }
            for (Preferences preferences : preferencesForSelector) {
                Set<TextMateBracePair> smartTypingPairs = preferences.getSmartTypingPairs();
                if (smartTypingPairs == null) continue;
                result.addAll(preferences.getSmartTypingPairs());
            }
        }
        result.addAll(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        return result;
    }

    private static Set<TextMateBracePair> getSmartTypingPairs(@Nullable CharSequence currentSelector) {
        if (currentSelector != null) {
            List<Preferences> preferencesForSelector = TextMateService.getInstance().getPreferencesRegistry().getPreferences(currentSelector);
            for (Preferences preferences : preferencesForSelector) {
                Set<TextMateBracePair> smartTypingPairs = preferences.getSmartTypingPairs();
                if (smartTypingPairs == null) continue;
                if (smartTypingPairs.isEmpty()) {
                    return Collections.emptySet();
                }
                HashSet<TextMateBracePair> result = new HashSet<TextMateBracePair>(smartTypingPairs);
                result.addAll(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
                return result;
            }
        }
        return new HashSet<TextMateBracePair>(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }

    private TextMateEditorUtils() {
    }

    @NotNull
    public static <K, V> Map<K, V> compactMap(@NotNull Map<K, V> map) {
        if (map == null) {
            TextMateEditorUtils.$$$reportNull$$$0(1);
        }
        if (map.isEmpty()) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                TextMateEditorUtils.$$$reportNull$$$0(2);
            }
            return map2;
        }
        if (map.size() == 1) {
            Map.Entry<K, V> singleEntry = map.entrySet().iterator().next();
            Map<K, V> map3 = Collections.singletonMap(singleEntry.getKey(), singleEntry.getValue());
            if (map3 == null) {
                TextMateEditorUtils.$$$reportNull$$$0(3);
            }
            return map3;
        }
        if (!(map instanceof HashMap)) {
            Map<K, V> map4 = map;
            if (map4 == null) {
                TextMateEditorUtils.$$$reportNull$$$0(4);
            }
            return map4;
        }
        HashMap<K, V> result = new HashMap<K, V>(map.size(), 1.0f);
        result.putAll(map);
        HashMap<K, V> hashMap = result;
        if (hashMap == null) {
            TextMateEditorUtils.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    public static void processExtensions(@NotNull CharSequence fileName, @NotNull Processor<? super CharSequence> processor) {
        CharSequence extension;
        if (fileName == null) {
            TextMateEditorUtils.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            TextMateEditorUtils.$$$reportNull$$$0(7);
        }
        if (!processor.process((Object)fileName)) {
            return;
        }
        int index = StringUtil.indexOf((CharSequence)fileName, (char)'.');
        while (index >= 0 && (extension = fileName.subSequence(index + 1, fileName.length())).length() != 0) {
            if (!processor.process((Object)extension)) {
                return;
            }
            index = StringUtil.indexOf((CharSequence)fileName, (char)'.', (int)(index + 1));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/editor/TextMateEditorUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/editor/TextMateEditorUtils";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "compactMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentScopeSelector";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compactMap";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

