/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.constraints;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000 +2\u00020\u0001:\u0002+,B'\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00002\f\u0010\u000f\u001a\b\u0018\u00010\u0010R\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0002J(\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0000J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0011H\u0014J\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u001f\u001a\u00020\tJ\r\u0010 \u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010!J\u000f\u0010\"\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0000H\u0002J\b\u0010&\u001a\u00020'H\u0016J\u0016\u0010(\u001a\u0004\u0018\u00010\u00002\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0011H\u0002J\u0016\u0010)\u001a\u0004\u0018\u00010\u00002\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0011H\u0002J\u000e\u0010*\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0000R\u0014\u0010\u000b\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "", "indents", "", "types", "", "isExplicit", "", "charsEaten", "", "([I[C[ZI)V", "base", "getBase", "()Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "addModifierIfNeeded", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "containsListMarkers", "", "upToIndex", "createNewConstraints", "eatItselfFromString", "", "s", "extendsList", "other", "extendsPrev", "fetchListMarker", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints$ListMarkerInfo;", "getCharsEaten", "getIndent", "getLastExplicit", "()Ljava/lang/Boolean;", "getLastType", "", "()Ljava/lang/Character;", "startsWith", "toString", "", "tryAddBlockQuote", "tryAddListItem", "upstreamWith", "Companion", "ListMarkerInfo", "3ce148cfd89a773"})
public class MarkdownConstraints {
    private final int[] indents;
    private final char[] types;
    private final boolean[] isExplicit;
    private final int charsEaten;
    @NotNull
    private static final MarkdownConstraints BASE;
    private static final char BQ_CHAR = '>';
    public static final Companion Companion;

    @NotNull
    public MarkdownConstraints getBase() {
        return BASE;
    }

    @NotNull
    public MarkdownConstraints createNewConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkParameterIsNotNull((Object)indents, (String)"indents");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)isExplicit, (String)"isExplicit");
        return new MarkdownConstraints(indents, types, isExplicit, charsEaten);
    }

    @NotNull
    public final CharSequence eatItselfFromString(@NotNull CharSequence s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        if (s.length() < this.charsEaten) {
            return "";
        }
        return s.subSequence(this.charsEaten, s.length());
    }

    public final int getIndent() {
        int[] nArray = this.indents;
        boolean bl = false;
        if (nArray.length == 0) {
            return 0;
        }
        return ArraysKt.last((int[])this.indents);
    }

    public final int getCharsEaten(@NotNull CharSequence s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        return Math.min(this.charsEaten, s.length());
    }

    @Nullable
    public Character getLastType() {
        return ArraysKt.lastOrNull((char[])this.types);
    }

    @Nullable
    public final Boolean getLastExplicit() {
        return ArraysKt.lastOrNull((boolean[])this.isExplicit);
    }

    public final boolean upstreamWith(@NotNull MarkdownConstraints other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return other.startsWith(this) && !this.containsListMarkers();
    }

    public final boolean extendsPrev(@NotNull MarkdownConstraints other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.startsWith(other) && !this.containsListMarkers(other.types.length);
    }

    public final boolean extendsList(@NotNull MarkdownConstraints other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        char[] cArray = other.types;
        boolean bl = false;
        if (cArray.length == 0) {
            throw (Throwable)new IllegalArgumentException("List constraints should contain at least one item");
        }
        return this.startsWith(other) && !this.containsListMarkers(other.types.length - 1);
    }

    private final boolean startsWith(MarkdownConstraints other) {
        boolean bl;
        block4: {
            int n = this.indents.length;
            int m = other.indents.length;
            if (n < m) {
                return false;
            }
            int n2 = 0;
            Iterable $this$none$iv = (Iterable)new IntRange(n2, m - 1);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$none$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(this.types[it] != other.types[it])) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean containsListMarkers() {
        return this.containsListMarkers(this.types.length);
    }

    private final boolean containsListMarkers(int upToIndex) {
        boolean bl;
        block3: {
            int n = 0;
            Iterable $this$any$iv = (Iterable)new IntRange(n, upToIndex - 1);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(this.types[it] != BQ_CHAR && this.isExplicit[it])) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final MarkdownConstraints addModifierIfNeeded(@Nullable LookaheadText.Position pos) {
        if (pos == null || pos.getOffsetInCurrentLine() == -1) {
            return null;
        }
        if (HorizontalRuleProvider.Companion.isHorizontalRule(pos.getCurrentLine(), pos.getOffsetInCurrentLine())) {
            return null;
        }
        MarkdownConstraints markdownConstraints = this.tryAddListItem(pos);
        if (markdownConstraints == null) {
            markdownConstraints = this.tryAddBlockQuote(pos);
        }
        return markdownConstraints;
    }

    @Nullable
    protected ListMarkerInfo fetchListMarker(@NotNull LookaheadText.Position pos) {
        char c;
        int offset;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        char c2 = pos.getChar();
        if (c2 == '*' || c2 == '-' || c2 == '+') {
            return new ListMarkerInfo(1, c2, 1);
        }
        String line = pos.getCurrentLine();
        for (offset = pos.getOffsetInCurrentLine(); offset < line.length() && '0' <= (c = line.charAt(offset)) && '9' >= c; ++offset) {
        }
        if (offset > pos.getOffsetInCurrentLine() && offset - pos.getOffsetInCurrentLine() <= 9 && offset < line.length() && (line.charAt(offset) == '.' || line.charAt(offset) == ')')) {
            return new ListMarkerInfo(offset + 1 - pos.getOffsetInCurrentLine(), line.charAt(offset), offset + 1 - pos.getOffsetInCurrentLine());
        }
        return null;
    }

    private final MarkdownConstraints tryAddListItem(LookaheadText.Position pos) {
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        int n = spacesBefore = offset > 0 && line.charAt(offset - 1) == '\t' ? (4 - this.getIndent() % 4) % 4 : 0;
        while (offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3) {
            ++spacesBefore;
            ++offset;
        }
        if (offset == line.length()) {
            return null;
        }
        LookaheadText.Position position = pos.nextPosition(offset - pos.getOffsetInCurrentLine());
        if (position == null) {
            Intrinsics.throwNpe();
        }
        ListMarkerInfo listMarkerInfo = this.fetchListMarker(position);
        if (listMarkerInfo == null) {
            return null;
        }
        ListMarkerInfo markerInfo = listMarkerInfo;
        int spacesAfter = 0;
        int markerEndOffset = offset += markerInfo.getMarkerLength();
        block5: while (offset < line.length()) {
            switch (line.charAt(offset)) {
                case ' ': {
                    ++spacesAfter;
                    break;
                }
                case '\t': {
                    spacesAfter += 4 - spacesAfter % 4;
                    break;
                }
                default: {
                    break block5;
                }
            }
            ++offset;
        }
        if (spacesAfter > 0 && spacesAfter < 5 && offset < line.length()) {
            return MarkdownConstraints.Companion.MarkdownConstraints(this, spacesBefore + markerInfo.getMarkerIndent() + spacesAfter, markerInfo.getMarkerType(), true, offset);
        }
        if (spacesAfter >= 5 && offset < line.length() || offset == line.length()) {
            return MarkdownConstraints.Companion.MarkdownConstraints(this, spacesBefore + markerInfo.getMarkerIndent() + 1, markerInfo.getMarkerType(), true, Math.min(offset, markerEndOffset + 1));
        }
        return null;
    }

    private final MarkdownConstraints tryAddBlockQuote(LookaheadText.Position pos) {
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        for (spacesBefore = 0; offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3; ++spacesBefore, ++offset) {
        }
        if (offset == line.length() || line.charAt(offset) != BQ_CHAR) {
            return null;
        }
        int spacesAfter = 0;
        if (++offset >= line.length() || line.charAt(offset) == ' ' || line.charAt(offset) == '\t') {
            spacesAfter = 1;
            if (offset < line.length()) {
                ++offset;
            }
        }
        return MarkdownConstraints.Companion.MarkdownConstraints(this, spacesBefore + 1 + spacesAfter, MarkdownConstraints.BQ_CHAR, true, offset);
    }

    @NotNull
    public String toString() {
        char[] cArray = this.types;
        StringBuilder stringBuilder = new StringBuilder().append("MdConstraints: ");
        boolean bl = false;
        String string = new String(cArray);
        return stringBuilder.append(string).append("(").append(this.getIndent()).append(")").toString();
    }

    protected MarkdownConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkParameterIsNotNull((Object)indents, (String)"indents");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)isExplicit, (String)"isExplicit");
        this.indents = indents;
        this.types = types;
        this.isExplicit = isExplicit;
        this.charsEaten = charsEaten;
    }

    static {
        Companion = new Companion(null);
        BASE = new MarkdownConstraints(new int[0], new char[0], new boolean[0], 0);
        BQ_CHAR = (char)62;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/intellij/markdown/parser/constraints/MarkdownConstraints$ListMarkerInfo;", "", "markerLength", "", "markerType", "", "markerIndent", "(ICI)V", "getMarkerIndent", "()I", "getMarkerLength", "getMarkerType", "()C", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "3ce148cfd89a773"})
    protected static final class ListMarkerInfo {
        private final int markerLength;
        private final char markerType;
        private final int markerIndent;

        public final int getMarkerLength() {
            return this.markerLength;
        }

        public final char getMarkerType() {
            return this.markerType;
        }

        public final int getMarkerIndent() {
            return this.markerIndent;
        }

        public ListMarkerInfo(int markerLength, char markerType, int markerIndent) {
            this.markerLength = markerLength;
            this.markerType = markerType;
            this.markerIndent = markerIndent;
        }

        public final int component1() {
            return this.markerLength;
        }

        public final char component2() {
            return this.markerType;
        }

        public final int component3() {
            return this.markerIndent;
        }

        @NotNull
        public final ListMarkerInfo copy(int markerLength, char markerType, int markerIndent) {
            return new ListMarkerInfo(markerLength, markerType, markerIndent);
        }

        public static /* synthetic */ ListMarkerInfo copy$default(ListMarkerInfo listMarkerInfo, int n, char c, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = listMarkerInfo.markerLength;
            }
            if ((n3 & 2) != 0) {
                c = listMarkerInfo.markerType;
            }
            if ((n3 & 4) != 0) {
                n2 = listMarkerInfo.markerIndent;
            }
            return listMarkerInfo.copy(n, c, n2);
        }

        @NotNull
        public String toString() {
            return "ListMarkerInfo(markerLength=" + this.markerLength + ", markerType=" + this.markerType + ", markerIndent=" + this.markerIndent + ")";
        }

        public int hashCode() {
            return (this.markerLength * 31 + this.markerType) * 31 + this.markerIndent;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListMarkerInfo)) break block3;
                    ListMarkerInfo listMarkerInfo = (ListMarkerInfo)object;
                    if (!(this.markerLength == listMarkerInfo.markerLength) || !(this.markerType == listMarkerInfo.markerType) || !(this.markerIndent == listMarkerInfo.markerIndent)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u001c\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0018\u00010\u0015R\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u001a\u0010\u0018\u001a\u00020\u00042\n\u0010\u0014\u001a\u00060\u0015R\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/intellij/markdown/parser/constraints/MarkdownConstraints$Companion;", "", "()V", "BASE", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "getBASE", "()Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "BQ_CHAR", "", "getBQ_CHAR", "()C", "MarkdownConstraints", "parent", "newIndentDelta", "", "newType", "newExplicit", "", "newOffset", "fillFromPrevious", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "prevLineConstraints", "fromBase", "3ce148cfd89a773"})
    public static final class Companion {
        @NotNull
        public final MarkdownConstraints getBASE() {
            return BASE;
        }

        public final char getBQ_CHAR() {
            return BQ_CHAR;
        }

        private final MarkdownConstraints MarkdownConstraints(MarkdownConstraints parent, int newIndentDelta, char newType, boolean newExplicit, int newOffset) {
            int n = parent.indents.length;
            int[] _indents = new int[n + 1];
            char[] _types = new char[n + 1];
            boolean[] _isExplicit = new boolean[n + 1];
            System.arraycopy(parent.indents, 0, _indents, 0, n);
            System.arraycopy(parent.types, 0, _types, 0, n);
            System.arraycopy(parent.isExplicit, 0, _isExplicit, 0, n);
            _indents[n] = parent.getIndent() + newIndentDelta;
            _types[n] = newType;
            _isExplicit[n] = newExplicit;
            return parent.createNewConstraints(_indents, _types, _isExplicit, newOffset);
        }

        @NotNull
        public final MarkdownConstraints fromBase(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints prevLineConstraints) {
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)prevLineConstraints, (String)"prevLineConstraints");
            boolean bl = pos.getOffsetInCurrentLine() == -1;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            MarkdownConstraints result = this.fillFromPrevious(pos, prevLineConstraints);
            String line = pos.getCurrentLine();
            while (true) {
                int offset;
                if (result.addModifierIfNeeded(pos.nextPosition(1 + (offset = result.getCharsEaten(line)))) != null) continue;
                break;
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MarkdownConstraints fillFromPrevious(@Nullable LookaheadText.Position pos, @NotNull MarkdownConstraints prevLineConstraints) {
            void indexPrev;
            Intrinsics.checkParameterIsNotNull((Object)prevLineConstraints, (String)"prevLineConstraints");
            if (pos == null) {
                return prevLineConstraints.getBase();
            }
            boolean bl = pos.getOffsetInCurrentLine() == -1;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-MarkdownConstraints$Companion$fillFromPrevious$22 = false;
                String $i$a$-assert-MarkdownConstraints$Companion$fillFromPrevious$22 = "given " + pos;
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-MarkdownConstraints$Companion$fillFromPrevious$22));
            }
            String line = pos.getCurrentLine();
            int startOffset = 0;
            int prevN = prevLineConstraints.indents.length;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            Function1 getBlockQuoteIndent2 = (Function1)new Function1<Integer, Integer>(line){
                final /* synthetic */ String $line;

                @Nullable
                public final Integer invoke(int startOffset) {
                    int blockQuoteIndent;
                    int offset = startOffset;
                    for (blockQuoteIndent = 0; blockQuoteIndent < 3 && offset < this.$line.length() && this.$line.charAt(offset) == ' '; ++blockQuoteIndent, ++offset) {
                    }
                    return offset < this.$line.length() && this.$line.charAt(offset) == MarkdownConstraints.Companion.getBQ_CHAR() ? Integer.valueOf(blockQuoteIndent + 1) : null;
                }
                {
                    this.$line = string;
                    super(1);
                }
            };
            Function1 fillMaybeBlockquoteAndListIndents2 = (Function1)new Function1<MarkdownConstraints, MarkdownConstraints>((Ref.IntRef)indexPrev, prevN, startOffset, line, prevLineConstraints, getBlockQuoteIndent2){
                final /* synthetic */ Ref.IntRef $indexPrev;
                final /* synthetic */ int $prevN;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ String $line;
                final /* synthetic */ MarkdownConstraints $prevLineConstraints;
                final /* synthetic */ Function1 $getBlockQuoteIndent;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final MarkdownConstraints invoke(@NotNull MarkdownConstraints constraints) {
                    int n;
                    int bonusForTheBlockquote;
                    int deltaIndent;
                    void totalSpaces;
                    void offset;
                    void spacesSeen;
                    Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
                    if (this.$indexPrev.element >= this.$prevN) {
                        return constraints;
                    }
                    Ref.IntRef intRef = new Ref.IntRef();
                    intRef.element = this.$startOffset + constraints.getCharsEaten(this.$line);
                    Ref.IntRef intRef2 = new Ref.IntRef();
                    intRef2.element = 0;
                    Ref.IntRef intRef3 = new Ref.IntRef();
                    intRef3.element = 0;
                    Function1 hasKMoreSpaces2 = (Function1)new Function1<Integer, Boolean>(this, (Ref.IntRef)spacesSeen, (Ref.IntRef)offset, (Ref.IntRef)totalSpaces){
                        final /* synthetic */ fillFromPrevious.fillMaybeBlockquoteAndListIndents.1 this$0;
                        final /* synthetic */ Ref.IntRef $spacesSeen;
                        final /* synthetic */ Ref.IntRef $offset;
                        final /* synthetic */ Ref.IntRef $totalSpaces;

                        public final boolean invoke(int k) {
                            boolean bl;
                            int oldSpacesSeen = this.$spacesSeen.element;
                            int oldOffset = this.$offset.element;
                            block4: while (this.$spacesSeen.element < k && this.$offset.element < this.this$0.$line.length()) {
                                int n;
                                switch (this.this$0.$line.charAt(this.$offset.element)) {
                                    case ' ': {
                                        n = 1;
                                        break;
                                    }
                                    case '\t': {
                                        n = 4 - this.$totalSpaces.element % 4;
                                        break;
                                    }
                                    default: {
                                        break block4;
                                    }
                                }
                                int deltaSpaces = n;
                                this.$spacesSeen.element += deltaSpaces;
                                this.$totalSpaces.element += deltaSpaces;
                                int n2 = this.$offset.element;
                                this.$offset.element = n2 + 1;
                            }
                            if (this.$offset.element == this.this$0.$line.length()) {
                                this.$spacesSeen.element = Integer.MAX_VALUE;
                            }
                            if (k <= this.$spacesSeen.element) {
                                this.$spacesSeen.element -= k;
                                bl = true;
                            } else {
                                this.$offset.element = oldOffset;
                                this.$spacesSeen.element = oldSpacesSeen;
                                bl = false;
                            }
                            return bl;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$spacesSeen = intRef;
                            this.$offset = intRef2;
                            this.$totalSpaces = intRef3;
                            super(1);
                        }
                    };
                    Integer bqIndent = null;
                    if (MarkdownConstraints.access$getTypes$p(this.$prevLineConstraints)[this.$indexPrev.element] == MarkdownConstraints.Companion.getBQ_CHAR()) {
                        Integer n2 = (Integer)this.$getBlockQuoteIndent.invoke((Object)offset.element);
                        if (n2 == null) {
                            return constraints;
                        }
                        bqIndent = (int)n2;
                        offset.element += bqIndent.intValue();
                        int n3 = this.$indexPrev.element;
                        this.$indexPrev.element = n3 + 1;
                    } else {
                        bqIndent = null;
                    }
                    int oldIndexPrev = this.$indexPrev.element;
                    while (this.$indexPrev.element < this.$prevN && MarkdownConstraints.access$getTypes$p(this.$prevLineConstraints)[this.$indexPrev.element] != MarkdownConstraints.Companion.getBQ_CHAR() && ((Boolean)hasKMoreSpaces2.invoke((Object)(deltaIndent = MarkdownConstraints.access$getIndents$p(this.$prevLineConstraints)[this.$indexPrev.element] - (this.$indexPrev.element == 0 ? 0 : MarkdownConstraints.access$getIndents$p(this.$prevLineConstraints)[this.$indexPrev.element - 1])))).booleanValue()) {
                        int n4 = this.$indexPrev.element;
                        this.$indexPrev.element = n4 + 1;
                    }
                    MarkdownConstraints result = constraints;
                    if (bqIndent != null) {
                        bonusForTheBlockquote = (Boolean)hasKMoreSpaces2.invoke((Object)1) != false ? 1 : 0;
                        result = org.intellij.markdown.parser.constraints.MarkdownConstraints$Companion.access$MarkdownConstraints(MarkdownConstraints.Companion, result, bqIndent + bonusForTheBlockquote, MarkdownConstraints.Companion.getBQ_CHAR(), true, offset.element);
                    }
                    if ((bonusForTheBlockquote = oldIndexPrev) <= (n = this.$indexPrev.element - 1)) {
                        while (true) {
                            void index;
                            int deltaIndent2 = MarkdownConstraints.access$getIndents$p(this.$prevLineConstraints)[index] - (index == false ? 0 : MarkdownConstraints.access$getIndents$p(this.$prevLineConstraints)[index - true]);
                            result = org.intellij.markdown.parser.constraints.MarkdownConstraints$Companion.access$MarkdownConstraints(MarkdownConstraints.Companion, result, deltaIndent2, MarkdownConstraints.access$getTypes$p(this.$prevLineConstraints)[index], false, offset.element);
                            if (index == n) break;
                            ++index;
                        }
                    }
                    return result;
                }
                {
                    this.$indexPrev = intRef;
                    this.$prevN = n;
                    this.$startOffset = n2;
                    this.$line = string;
                    this.$prevLineConstraints = markdownConstraints;
                    this.$getBlockQuoteIndent = function1;
                    super(1);
                }
            };
            MarkdownConstraints result = prevLineConstraints.getBase();
            MarkdownConstraints nextConstraints;
            while (!Intrinsics.areEqual((Object)(nextConstraints = (MarkdownConstraints)fillMaybeBlockquoteAndListIndents2.invoke((Object)result)), (Object)result)) {
                result = nextConstraints;
            }
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

