/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.internal.AbstractWorker;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.IsolatedClassLoaderWorkerRequirement;
import org.gradle.workers.internal.IsolatedClassloaderWorker;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerPublicServicesBuilder;
import org.gradle.workers.internal.WorkerRequirement;

public class IsolatedClassloaderWorkerFactory
implements WorkerFactory {
    private final BuildOperationExecutor buildOperationExecutor;
    private final ServiceRegistry internalServices;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final LegacyTypesSupport legacyTypesSupport;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;
    private final InstantiatorFactory instantiatorFactory;

    public IsolatedClassloaderWorkerFactory(BuildOperationExecutor buildOperationExecutor, ServiceRegistry internalServices, ClassLoaderRegistry classLoaderRegistry) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.internalServices = internalServices;
        this.classLoaderRegistry = classLoaderRegistry;
        this.legacyTypesSupport = internalServices.get(LegacyTypesSupport.class);
        this.actionExecutionSpecFactory = internalServices.get(ActionExecutionSpecFactory.class);
        this.instantiatorFactory = internalServices.get(InstantiatorFactory.class);
    }

    @Override
    public BuildOperationAwareWorker getWorker(final WorkerRequirement workerRequirement) {
        return new AbstractWorker(this.buildOperationExecutor){

            @Override
            public DefaultWorkResult execute(ActionExecutionSpec spec, BuildOperationRef parentBuildOperation) {
                return this.executeWrappedInBuildOperation(spec, parentBuildOperation, workSpec -> {
                    DefaultServiceRegistry workServices = new WorkerPublicServicesBuilder(IsolatedClassloaderWorkerFactory.this.internalServices).withInternalServicesVisible(workSpec.isInternalServicesRequired()).build();
                    ClassLoader workerInfrastructureClassloader = IsolatedClassloaderWorkerFactory.this.classLoaderRegistry.getPluginsClassLoader();
                    ClassLoaderStructure classLoaderStructure = ((IsolatedClassLoaderWorkerRequirement)workerRequirement).getClassLoaderStructure();
                    ClassLoader workerClassLoader = IsolatedClassloaderWorker.createIsolatedWorkerClassloader(classLoaderStructure, workerInfrastructureClassloader, IsolatedClassloaderWorkerFactory.this.legacyTypesSupport);
                    IsolatedClassloaderWorker worker = new IsolatedClassloaderWorker(workerClassLoader, workServices, IsolatedClassloaderWorkerFactory.this.actionExecutionSpecFactory, IsolatedClassloaderWorkerFactory.this.instantiatorFactory);
                    return worker.execute(workSpec);
                });
            }
        };
    }

    @Override
    public IsolationMode getIsolationMode() {
        return IsolationMode.CLASSLOADER;
    }
}

